/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlLoopVariable
extends RenameableFakePsiElement
implements FtlVariable {
    private final FtlListDirective myDirective;
    private final PsiElement myNameElement;
    private final FtlLoopVariable[] myDependents;
    private final Computable<? extends FtlType> myType;

    protected FtlLoopVariable(@NotNull FtlListDirective directive, @NotNull PsiElement nameElement, boolean withDependents, Computable<? extends FtlType> type) {
        FtlLoopVariable[] ftlLoopVariableArray;
        if (directive == null) {
            FtlLoopVariable.$$$reportNull$$$0(0);
        }
        if (nameElement == null) {
            FtlLoopVariable.$$$reportNull$$$0(1);
        }
        super((PsiElement)directive);
        this.myDirective = directive;
        this.myNameElement = nameElement;
        if (withDependents) {
            FtlLoopVariable[] ftlLoopVariableArray2 = new FtlLoopVariable[2];
            ftlLoopVariableArray2[0] = this.createDependent((PsiType)PsiType.BOOLEAN, "_has_next");
            ftlLoopVariableArray = ftlLoopVariableArray2;
            ftlLoopVariableArray2[1] = this.createDependent((PsiType)PsiType.INT, "_index");
        } else {
            ftlLoopVariableArray = new FtlLoopVariable[]{};
        }
        this.myDependents = ftlLoopVariableArray;
        this.myType = type;
    }

    @NotNull
    private FtlLoopVariable createDependent(PsiType varType, final String suffix) {
        FtlLoopVariable ftlLoopVariable = new FtlLoopVariable(this.myDirective, this.myNameElement, false, () -> FtlPsiType.wrap(varType)){

            @Override
            @NotNull
            public FtlLoopVariable getMainVariable() {
                FtlLoopVariable ftlLoopVariable = FtlLoopVariable.this;
                if (ftlLoopVariable == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ftlLoopVariable;
            }

            @Override
            @NotNull
            public String getSuffix() {
                String string = suffix;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                return this;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlLoopVariable$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMainVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSuffix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlLoopVariable$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setName";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (ftlLoopVariable == null) {
            FtlLoopVariable.$$$reportNull$$$0(2);
        }
        return ftlLoopVariable;
    }

    @NotNull
    public FtlLoopVariable getMainVariable() {
        FtlLoopVariable ftlLoopVariable = this;
        if (ftlLoopVariable == null) {
            FtlLoopVariable.$$$reportNull$$$0(3);
        }
        return ftlLoopVariable;
    }

    public FtlLoopVariable[] getDependents() {
        return this.myDependents;
    }

    public FtlLoopVariable[] uniteWithDependents() {
        FtlLoopVariable[] ftlLoopVariableArray;
        if (this.myDependents.length == 0) {
            FtlLoopVariable[] ftlLoopVariableArray2 = new FtlLoopVariable[1];
            ftlLoopVariableArray = ftlLoopVariableArray2;
            ftlLoopVariableArray2[0] = this;
        } else {
            ftlLoopVariableArray = (FtlLoopVariable[])ArrayUtil.append((Object[])this.myDependents, (Object)this);
        }
        return ftlLoopVariableArray;
    }

    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.myDirective);
        if (localSearchScope == null) {
            FtlLoopVariable.$$$reportNull$$$0(4);
        }
        return localSearchScope;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myNameElement;
        if (psiElement == null) {
            FtlLoopVariable.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public FtlListDirective getDirective() {
        return this.myDirective;
    }

    @NotNull
    public String getSuffix() {
        if ("" == null) {
            FtlLoopVariable.$$$reportNull$$$0(6);
        }
        return "";
    }

    @NotNull
    public String getName() {
        String string = this.myNameElement.getText() + this.getSuffix();
        if (string == null) {
            FtlLoopVariable.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            FtlLoopVariable.$$$reportNull$$$0(8);
        }
        FtlXmlRootTag tag = FtlPsiUtil.parseFtlFile("<#list a as " + name + ">", this.getProject());
        FtlListDirective directive = (FtlListDirective)tag.getSubDirectives()[0];
        this.myDirective.getNode().replaceChild(this.myNameElement.getNode(), directive.getNameElements().get(0).getNode());
        return this;
    }

    public PsiElement getParent() {
        return this.myDirective;
    }

    public String getTypeName() {
        return FreeMarkerBundle.message("type.name.variable", new Object[0]);
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    @Nullable
    public FtlType getType() {
        return (FtlType)this.myType.compute();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlLoopVariable)) {
            return false;
        }
        FtlLoopVariable variable = (FtlLoopVariable)o;
        return this.myNameElement == variable.myNameElement && this.getSuffix().equals(variable.getSuffix());
    }

    public int hashCode() {
        return Objects.hash(this.myNameElement, this.getSuffix());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlLoopVariable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlLoopVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainVariable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

