/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlBlock
extends TemplateLanguageBlock {
    protected FtlBlock(@NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings codeStyleSettings, @NotNull ASTNode node, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (blockFactory == null) {
            FtlBlock.$$$reportNull$$$0(0);
        }
        if (codeStyleSettings == null) {
            FtlBlock.$$$reportNull$$$0(1);
        }
        if (node == null) {
            FtlBlock.$$$reportNull$$$0(2);
        }
        super(blockFactory, codeStyleSettings, node, foreignChildren);
    }

    public Indent getIndent() {
        if (this.getParent() == null || this.getParent().getParent() == null || this.isRootTagChild()) {
            return Indent.getNoneIndent();
        }
        return FtlBlock.getFtlElementIndent(this.getNode().getElementType());
    }

    static Indent getFtlElementIndent(IElementType type) {
        if (type == FtlCompositeElementTypes.INTERPOLATION) {
            return Indent.getNormalIndent();
        }
        return FtlBlock.isIndependentDirective(type) ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    private static boolean isIndependentDirective(IElementType type) {
        if (type instanceof FtlDirectiveType) {
            String directiveName = ((FtlDirectiveType)type).getDirectiveName();
            return !directiveName.equals("else") && !directiveName.equals("elseIf");
        }
        return type == FtlCompositeElementTypes.USER_DIRECTIVE;
    }

    private boolean isRootTagChild() {
        ASTNode parent = this.getNode().getTreeParent();
        return parent == null || parent.getElementType() == FtlCompositeElementTypes.ROOT_TAG;
    }

    protected IElementType getTemplateTextElementType() {
        return FtlElementTypes.TEMPLATE_TEXT;
    }

    @Nullable
    public Spacing getRightNeighborSpacing(@NotNull Block rightNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        if (rightNeighbor == null) {
            FtlBlock.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            FtlBlock.$$$reportNull$$$0(4);
        }
        if (rightNeighbor instanceof DataLanguageBlockWrapper) {
            if (FtlBlock.mustPreserveSpacing(parent)) {
                return Spacing.getReadOnlySpacing();
            }
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)1);
        }
        return null;
    }

    private static boolean mustPreserveSpacing(@NotNull DataLanguageBlockWrapper parent) {
        Block original;
        if (parent == null) {
            FtlBlock.$$$reportNull$$$0(5);
        }
        return (original = parent.getOriginal()) instanceof AbstractSyntheticBlock && ((AbstractSyntheticBlock)original).shouldKeepWhiteSpacesInside();
    }

    @Nullable
    public Spacing getLeftNeighborSpacing(@Nullable Block leftNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        if (parent == null) {
            FtlBlock.$$$reportNull$$$0(6);
        }
        if (FtlBlock.isIndependentDirective(this.getNode().getElementType()) && this.widenToLineStart(this.getTextRange()) != null) {
            return Spacing.getReadOnlySpacing();
        }
        return super.getLeftNeighborSpacing(leftNeighbor, parent, thisBlockIndex);
    }

    protected Indent getChildIndent() {
        return Indent.getNoneIndent();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            FtlBlock.$$$reportNull$$$0(7);
        }
        if (child2 instanceof DataLanguageBlockWrapper && this.widenToLineStart(child2.getTextRange()) != null) {
            return Spacing.getReadOnlySpacing();
        }
        return super.getSpacing(child1, child2);
    }

    @Nullable
    private Integer widenToLineStart(TextRange range) {
        int nodeStart;
        CharSequence text = this.getDocumentText();
        int lineStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)((nodeStart = range.getStartOffset()) - 1), (String)" \t") + 1;
        return lineStart > 0 && text.charAt(lineStart - 1) == '\n' ? Integer.valueOf(lineStart) : null;
    }

    @NotNull
    private CharSequence getDocumentText() {
        PsiFile file = Objects.requireNonNull(SharedImplUtil.getContainingFile((ASTNode)this.myNode));
        CharSequence charSequence = Objects.requireNonNull(file.getViewProvider().getDocument()).getImmutableCharSequence();
        if (charSequence == null) {
            FtlBlock.$$$reportNull$$$0(8);
        }
        return charSequence;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange range = super.getTextRange();
        if (!FtlBlock.isIndependentDirective(this.getNode().getElementType())) {
            TextRange textRange = range;
            if (textRange == null) {
                FtlBlock.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        Integer lineStart = this.widenToLineStart(range);
        TextRange textRange = lineStart == null ? range : new TextRange(lineStart.intValue(), range.getEndOffset());
        if (textRange == null) {
            FtlBlock.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    public boolean isRequiredRange(TextRange range) {
        return !StringUtil.isEmptyOrSpaces((CharSequence)range.subSequence(this.getDocumentText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightNeighbor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/formatter/FtlBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/formatter/FtlBlock";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRightNeighborSpacing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mustPreserveSpacing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLeftNeighborSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

