/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinDeploymentProvider;
import org.intellij.j2ee.web.resin.ResinModel;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.ResinPersistentDataHelper;
import org.intellij.j2ee.web.resin.resin.WebApp;
import org.intellij.j2ee.web.resin.resin.configuration.ResinConfigurationStrategy;
import org.intellij.j2ee.web.resin.resin.configuration.ResinGeneratedConfig;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResinConfiguration {
    private static final Logger LOG = Logger.getInstance(ResinConfiguration.class);
    @NonNls
    private static final String JAVAC_ELEMENT = "javac";
    @NonNls
    private static final String ARGS_ATTRIBUTE = "args";
    @NonNls
    private static final String COMPILER_ATTRIBUTE = "compiler";
    @NonNls
    private static final String COMPILER_ATTRIBUTE_VALUE = "internal";
    @NonNls
    private static final String ARGS_ATTRIBUTE_VALUE = "-source 1.5";
    @NonNls
    private static final String ARGS_ATTRIBUTE_VALUE_PREFIX = "-g";
    private final ResinInstallation myInstallation;
    private final ResinGeneratedConfig myGeneratedConfig;
    private final File mySourceConfig;
    private final ResinConfigurationStrategy myStrategy;

    public ResinConfiguration(ResinModel serverModel) throws ExecutionException {
        ResinPersistentDataHelper helper = serverModel.getHelper();
        this.myInstallation = helper.getInstallationOrError();
        LOG.assertTrue(this.myInstallation != null);
        try {
            this.mySourceConfig = serverModel.findConfFile();
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
        this.myStrategy = helper.getStrategy();
        LOG.assertTrue(this.myStrategy != null);
        if (serverModel.isReadOnlyConfiguration()) {
            this.myGeneratedConfig = null;
        } else {
            try {
                Element document;
                if (this.mySourceConfig.length() == 0L) {
                    InputStream is = this.myStrategy.getDefaultResinConfContent();
                    if (is == null) {
                        throw new ExecutionException(ResinBundle.message("run.resin.conf.doesnt.exist", new Object[0]));
                    }
                    document = JDOMUtil.load((InputStream)is);
                } else {
                    document = JDOMUtil.load((File)this.mySourceConfig);
                }
                this.myGeneratedConfig = new ResinGeneratedConfig(document, "resin");
                ResinConfiguration.patchConfigToMakeDebuggerWork(document);
                this.myStrategy.init(serverModel, document);
                this.myStrategy.setPort(serverModel.getPort());
            }
            catch (JDOMException e) {
                throw new ExecutionException(ResinBundle.message("run.resin.conf.load.error", new Object[0]), (Throwable)e);
            }
            catch (IOException e) {
                throw new ExecutionException(ResinBundle.message("run.resin.conf.load.error", new Object[0]), (Throwable)e);
            }
            for (DeploymentModel model : serverModel.getCommonModel().getDeploymentModels()) {
                WebApp webApp;
                if (model.getDeploymentMethod() != ResinDeploymentProvider.CONF_DEPLOYMENT_METHOD || (webApp = ResinDeploymentProvider.getWebApp(model)) == null) continue;
                this.deploy(webApp);
            }
            this.save();
        }
    }

    public String getServerId() {
        return this.myStrategy.getServerId();
    }

    private static void patchConfigToMakeDebuggerWork(@NotNull Element element) {
        Attribute args;
        Element javac;
        if (element == null) {
            ResinConfiguration.$$$reportNull$$$0(0);
        }
        if ((javac = element.getChild(JAVAC_ELEMENT, element.getNamespace())) == null) {
            javac = new Element(JAVAC_ELEMENT, element.getNamespace());
            javac.setAttribute(COMPILER_ATTRIBUTE, COMPILER_ATTRIBUTE_VALUE);
            javac.setAttribute(ARGS_ATTRIBUTE, ARGS_ATTRIBUTE_VALUE);
            element.addContent(javac);
        }
        if (!(args = javac.getAttribute(ARGS_ATTRIBUTE)).getValue().contains(ARGS_ATTRIBUTE_VALUE_PREFIX)) {
            args.setValue("-g " + args.getValue());
        }
    }

    public ResinInstallation getInstallation() {
        return this.myInstallation;
    }

    private boolean isWritable() {
        return this.myGeneratedConfig != null;
    }

    public File getConfigFile() {
        return this.isWritable() ? this.myGeneratedConfig.getFile() : this.mySourceConfig;
    }

    public void deploy(WebApp webApp) throws ExecutionException {
        if (!this.isWritable()) {
            return;
        }
        this.myStrategy.deploy(webApp);
        this.save();
    }

    public boolean undeploy(WebApp webApp) throws ExecutionException {
        if (!this.isWritable()) {
            return false;
        }
        boolean result = this.myStrategy.undeploy(webApp);
        this.save();
        return result;
    }

    private void save() throws ExecutionException {
        this.myGeneratedConfig.save();
        this.myStrategy.save();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/j2ee/web/resin/resin/ResinConfiguration", "patchConfigToMakeDebuggerWork"));
    }
}

