/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNSDescriptor;
import org.jetbrains.annotations.NotNull;

public class ELFunctionInsertHandler
extends BasicInsertHandler<LookupElement> {
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            ELFunctionInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            ELFunctionInsertHandler.$$$reportNull$$$0(1);
        }
        super.handleInsert(context, item);
        PsiElement current = context.getFile().findElementAt(context.getStartOffset());
        if (current == null) {
            return;
        }
        PsiElement grandParent = current.getParent().getParent();
        if (grandParent instanceof ELFunctionCallExpression) {
            ELFunctionCallExpression callExpression = (ELFunctionCallExpression)grandParent;
            ELVariable namespace = callExpression.getNamespace();
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)current, XmlTag.class);
            if (tag == null) {
                return;
            }
            String namespaceByPrefix = tag.getNamespaceByPrefix(namespace.getText());
            XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(namespaceByPrefix, true);
            if (nsDescriptor instanceof TldDescriptor) {
                ELVariable method = callExpression.getMethod();
                if (method == null) {
                    return;
                }
                FunctionDescriptor functionDescriptor = ((TldDescriptor)nsDescriptor).getFunctionDescriptor(method.getText());
                TemplateManager templateManager = TemplateManager.getInstance((Project)context.getProject());
                Template template = templateManager.createTemplate("", "");
                int index = 0;
                template.addTextSegment("(");
                if (functionDescriptor != null) {
                    for (int i = 0; i < functionDescriptor.getParameterCount(); ++i) {
                        if (i != 0) {
                            template.addTextSegment(", ");
                        }
                        MacroCallNode expression = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
                        template.addVariable(Integer.toString(index++), (Expression)expression, (Expression)expression, true);
                    }
                }
                template.addTextSegment(")");
                templateManager.startTemplate(context.getEditor(), template);
            }
        } else {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)current, XmlTag.class);
            if (tag == null) {
                return;
            }
            String namespaceByPrefix = tag.getNamespaceByPrefix(current.getText());
            if (namespaceByPrefix.length() > 0) {
                Editor editor = context.getEditor();
                CaretModel caretModel = editor.getCaretModel();
                editor.getDocument().insertString(caretModel.getOffset(), (CharSequence)":");
                caretModel.moveToOffset(caretModel.getOffset() + 1);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/ELFunctionInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

