/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp.unescapedEl;

import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.jsp.AbstractWrapFix;
import com.intellij.codeInspection.jsp.WrapInTagFix;
import com.intellij.codeInspection.jsp.unescapedEl.JspUnescapedElOptionsPanel;
import com.intellij.codeInspection.jsp.unescapedEl.SafeTagInfo;
import com.intellij.jsp.impl.TypeAwareAttributeDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.ELElementType;
import com.intellij.psi.jsp.el.ELBinaryExpression;
import com.intellij.psi.jsp.el.ELConditionalExpression;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.jsp.el.ELUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspUnescapedElInspection
extends XmlSuppressableInspectionTool
implements ELTokenType {
    private static final TokenSet SAFE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{JSP_EL_AND, JSP_EL_OR, JSP_EL_NOT_KEYWORD, JSP_EL_NOT, JSP_EL_EQ, JSP_EL_NE, JSP_EL_LT, JSP_EL_GT, JSP_EL_LE, JSP_EL_GE, JSP_EL_TRUE, JSP_EL_FALSE, JSP_EL_NULL, JSP_EL_INSTANCEOF, JSP_EL_EMPTY, JSP_EL_DIV, JSP_EL_MOD, JSP_EL_LESS, JSP_EL_GREATER, JSP_EL_LESS_OR_EQUAL, JSP_EL_GREATER_OR_EQUAL, JSP_EL_MINUS, JSP_EL_PLUS, JSP_EL_DIVISION, JSP_EL_MODULO, JSP_EL_MULTIPLY, JSP_EL_NOT_EQUAL, JSP_EL_EQUAL, JSP_EL_AND_AND, JSP_EL_OR_OR, ELElementType.JSP_EL_LITERAL});
    public List<SafeTagInfo> safeTags = new ArrayList<SafeTagInfo>(Arrays.asList(new SafeTagInfo("http://java.sun.com/jsp/jstl/core", "out", "value", true)));
    public boolean suggestEscapeXml = true;
    private final NotNullLazyValue<JspUnescapedElOptionsPanel> myPanel = new NotNullLazyValue<JspUnescapedElOptionsPanel>(){

        @NotNull
        protected JspUnescapedElOptionsPanel compute() {
            JspUnescapedElOptionsPanel jspUnescapedElOptionsPanel = new JspUnescapedElOptionsPanel(JspUnescapedElInspection.this);
            if (jspUnescapedElOptionsPanel == null) {
                4.$$$reportNull$$$0(0);
            }
            return jspUnescapedElOptionsPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$4", "compute"));
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(0);
        }
        ELElementVisitor eLElementVisitor = new ELElementVisitor(){

            @Override
            public void visitELExpressionHolder(@NotNull ELExpressionHolder expressionHolder) {
                XmlAttribute attr;
                PsiElement[] children;
                if (expressionHolder == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((children = expressionHolder.getChildren()).length == 1) {
                    IElementType type;
                    PsiElement child = children[0];
                    if (SAFE_OPERATIONS.contains(child.getNode().getElementType())) {
                        return;
                    }
                    if (child instanceof ELBinaryExpression) {
                        type = ((ELBinaryExpression)child).getOperationSign();
                        if (SAFE_OPERATIONS.contains(type)) {
                            return;
                        }
                    } else if (child instanceof ELUnaryExpression) {
                        IElementType sign = ((ELUnaryExpression)child).getOperationSign();
                        if (SAFE_OPERATIONS.contains(sign)) {
                            return;
                        }
                    } else if (child instanceof ELConditionalExpression) {
                        ELExpression then = ((ELConditionalExpression)child).getThen();
                        ELExpression eLExpression = ((ELConditionalExpression)child).getElse();
                        if (then instanceof ELLiteralExpression && eLExpression instanceof ELLiteralExpression) {
                            return;
                        }
                    } else {
                        if (child instanceof ELLiteralExpression) {
                            return;
                        }
                        if (child instanceof ELExpression && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)(type = ELResolveUtil.resolveContextAsType((ELExpression)child)))) {
                            return;
                        }
                    }
                }
                if ((attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)expressionHolder, XmlAttribute.class)) != null) {
                    String type;
                    String namespace = attr.getParent().getNamespace();
                    for (String uri : XmlUtil.JSTL_CORE_URIS) {
                        if (!uri.equals(namespace)) continue;
                        return;
                    }
                    XmlAttributeDescriptor xmlAttributeDescriptor = attr.getDescriptor();
                    if (xmlAttributeDescriptor instanceof TypeAwareAttributeDescriptor && TypeConversionUtil.isPrimitive((String)(type = ((TypeAwareAttributeDescriptor)xmlAttributeDescriptor).getType()))) {
                        return;
                    }
                    for (SafeTagInfo info : JspUnescapedElInspection.this.safeTags) {
                        if (!info.matchAttribute(attr)) continue;
                        return;
                    }
                    if (!JspUnescapedElInspection.isEscapedByJSTL(expressionHolder)) {
                        JspUnescapedElInspection.this.reportProblem(expressionHolder, problemsHolder, attr, JspUnescapedElInspection.this.suggestEscapeXml ? new EscapeByJSTL() : null);
                    }
                } else {
                    Language language;
                    PsiElement parent = expressionHolder.getParent();
                    if (parent != null && ((language = parent.getLanguage()) == NewJspLanguage.INSTANCE || language == JSPXLanguage.INSTANCE)) {
                        JspUnescapedElInspection.this.reportProblem(expressionHolder, problemsHolder, null, null);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionHolder", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$1", "visitELExpressionHolder"));
            }
        };
        if (eLElementVisitor == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(1);
        }
        return eLElementVisitor;
    }

    private static boolean isEscapedByJSTL(ELExpressionHolder expressionHolder) {
        ELFunctionCallExpression call;
        PsiElement[] children = expressionHolder.getChildren();
        return children.length == 1 && children[0] instanceof ELFunctionCallExpression && "escapeXml".equals((call = (ELFunctionCallExpression)children[0]).getFunctionName());
    }

    private void reportProblem(ELExpressionHolder expressionHolder, ProblemsHolder problemsHolder, @Nullable XmlAttribute attribute, @Nullable LocalQuickFix additional) {
        XmlTag tag;
        BaseJspFile jspFile = BaseJspUtil.getJspFile((PsiElement)expressionHolder);
        ArrayList<RegisterAsSafeFix> fixes = new ArrayList<RegisterAsSafeFix>(ContainerUtil.mapNotNull(this.safeTags, (Function)((NullableFunction)tagInfo -> {
            if (jspFile == null || ExtendedTagInsertHandler.suggestPrefix((XmlFile)jspFile, (String)tagInfo.namespace) == null) {
                return null;
            }
            return tagInfo.fix ? new WrapInTagFix((SafeTagInfo)tagInfo) : null;
        })));
        ContainerUtil.addIfNotNull(fixes, (Object)additional);
        if (attribute != null && (tag = attribute.getParent()) != null) {
            fixes.add(new RegisterAsSafeFix("Register <" + tag.getLocalName() + " " + attribute.getLocalName() + "=\"\"> as safe place"));
            fixes.add(new RegisterAsSafeFix("Register <" + tag.getLocalName() + "> tag as safe place"){

                @Override
                protected SafeTagInfo createInfo(XmlAttribute attribute) {
                    return new SafeTagInfo(attribute.getParent().getNamespace(), attribute.getParent().getLocalName(), null, false);
                }
            });
            fixes.add(new RegisterAsSafeFix("Register all tags from " + tag.getNamespace() + " as safe"){

                @Override
                protected SafeTagInfo createInfo(XmlAttribute attribute) {
                    return new SafeTagInfo(attribute.getParent().getNamespace(), null, null, false);
                }
            });
        }
        problemsHolder.registerProblem((PsiElement)expressionHolder, "Unescaped EL expression", fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return ((JspUnescapedElOptionsPanel)this.myPanel.getValue()).getOptionsPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RegisterAsSafeFix
    implements LocalQuickFix {
        private final String myName;

        RegisterAsSafeFix(String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JspInspectionGroupNames.JSP_INSPECTIONS;
            if (string == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(3);
            }
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class);
            InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile().modifyToolSettings(Key.create((String)JspUnescapedElInspection.this.getShortName()), descriptor.getPsiElement(), inspection -> inspection.safeTags.add(this.createInfo(attribute)));
        }

        protected SafeTagInfo createInfo(XmlAttribute attribute) {
            XmlTag tag = attribute.getParent();
            return new SafeTagInfo(tag.getNamespace(), tag.getLocalName(), attribute.getLocalName(), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EscapeByJSTL
    extends AbstractWrapFix {
        private EscapeByJSTL() {
        }

        @NotNull
        public String getName() {
            if ("Wrap in JSTL escapeXml() function" == null) {
                EscapeByJSTL.$$$reportNull$$$0(0);
            }
            return "Wrap in JSTL escapeXml() function";
        }

        @Override
        protected String getNamespace() {
            return "http://java.sun.com/jsp/jstl/functions";
        }

        @Override
        protected PsiElement getElementToReplace(PsiElement holder) {
            return holder.getChildren()[0];
        }

        @Override
        protected StringBuilder buildNewText(String prefix, String text) {
            return new StringBuilder().append(prefix).append(":escapeXml(").append(text).append(')');
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/unescapedEl/JspUnescapedElInspection$EscapeByJSTL", "getName"));
        }
    }
}

