/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.web.WebContextManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.JspContextManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebContextProvider
extends FileContextProvider {
    private final WebContextManager myWebContextManager;
    private final JspContextManager myJspContextManager;

    public WebContextProvider(Project project, JspContextManager jspContextManager) {
        this.myJspContextManager = jspContextManager;
        this.myWebContextManager = WebContextManager.getInstance((Project)project);
    }

    protected boolean isAvailable(PsiFile file) {
        return true;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContextFolders(PsiFile file) {
        PsiFileSystemItem item = this.myWebContextManager.getContextFolder(file);
        if (item != null) {
            Set<PsiFileSystemItem> set = Collections.singleton(item);
            if (set == null) {
                WebContextProvider.$$$reportNull$$$0(0);
            }
            return set;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            WebContextProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public PsiFile getContextFile(PsiFile file) {
        return this.myJspContextManager.getContextFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebContextProvider", "getContextFolders"));
    }
}

