/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerState;
import com.intellij.lexer.PrefixSuffixStripperLexer;
import com.intellij.psi.impl.source.parsing.jsp.JspLexer;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class JspHighlightingLexer
extends Lexer {
    private final JspLexer myJspLexer = new JspLexer(true);
    private final PrefixSuffixStripperLexer myScriptletLexer = new PrefixSuffixStripperLexer("<%", JspTokenType.JSP_SCRIPTLET_START, "%>", JspTokenType.JSP_SCRIPTLET_END, (IElementType)BaseJspElementType.JSP_SCRIPTLET);
    private final PrefixSuffixStripperLexer myExpressionLexer = new PrefixSuffixStripperLexer("<%=", JspTokenType.JSP_EXPRESSION_START, "%>", JspTokenType.JSP_EXPRESSION_END, (IElementType)BaseJspElementType.JSP_EXPRESSION);
    private final PrefixSuffixStripperLexer myDeclarationLexer = new PrefixSuffixStripperLexer("<%!", JspTokenType.JSP_DECLARATION_START, "%>", JspTokenType.JSP_DECLARATION_END, (IElementType)BaseJspElementType.JSP_DECLARATION);
    private int myBufferEnd;
    private int myTokenStart;
    private int myTokenEnd;
    private IElementType myTokenType;
    private Queue<Token> myTokenQueue;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JspHighlightingLexer.$$$reportNull$$$0(0);
        }
        this.myJspLexer.start(buffer, startOffset, endOffset, initialState & 0xF);
        this.myTokenQueue = new LinkedList<Token>();
        this.myTokenStart = this.myTokenEnd = startOffset;
        this.myTokenType = null;
        this.myBufferEnd = endOffset;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myJspLexer.getBufferSequence();
        if (charSequence == null) {
            JspHighlightingLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public int getState() {
        int jspState = this.myJspLexer.getState();
        assert (jspState == (jspState & 0xF));
        return jspState | this.myTokenQueue.size() << 4;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    public void advance() {
        this.myTokenType = null;
        if (this.myTokenQueue.poll() == null) {
            this.myJspLexer.advance();
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        MyPosition myPosition = new MyPosition(this.myTokenStart, new MyState(new LinkedList<Token>(this.myTokenQueue), this.myJspLexer.position()));
        if (myPosition == null) {
            JspHighlightingLexer.$$$reportNull$$$0(2);
        }
        return myPosition;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            JspHighlightingLexer.$$$reportNull$$$0(3);
        }
        MyPosition pos = (MyPosition)position;
        this.myTokenType = null;
        this.myTokenStart = this.myTokenEnd = pos.getOffset();
        this.myJspLexer.start(this.myJspLexer.getBufferSequence(), pos.state.jspState.start, this.myBufferEnd, pos.state.jspState.state);
        this.myJspLexer.restore(pos.state.jspState);
        this.myTokenQueue = pos.state.queue;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myTokenStart = this.myTokenEnd;
        Token queuedToken = this.myTokenQueue.peek();
        if (queuedToken != null) {
            this.myTokenType = queuedToken.tokenType;
            this.myTokenEnd = queuedToken.tokenEnd;
            return;
        }
        IElementType jsp = this.myJspLexer.getTokenType();
        if (jsp == BaseJspElementType.JSP_SCRIPTLET) {
            this.fedQueueFromLexer((Lexer)this.myScriptletLexer);
        } else if (jsp == BaseJspElementType.JSP_EXPRESSION) {
            this.fedQueueFromLexer((Lexer)this.myExpressionLexer);
        } else if (jsp == BaseJspElementType.JSP_DECLARATION) {
            this.fedQueueFromLexer((Lexer)this.myDeclarationLexer);
        } else {
            this.myTokenType = jsp;
            this.myTokenEnd = this.myJspLexer.getTokenEnd();
        }
    }

    public boolean isInsideSQAttributeValue() {
        return this.myJspLexer.getAfterState() == 4;
    }

    public boolean isInsideDQAttributeValue() {
        return this.myJspLexer.getAfterState() == 5;
    }

    private void fedQueueFromLexer(Lexer lexer) {
        IElementType type;
        lexer.start(this.myJspLexer.getBufferSequence(), this.myJspLexer.getTokenStart(), this.myJspLexer.getTokenEnd());
        this.myJspLexer.advance();
        while ((type = lexer.getTokenType()) != null) {
            Token token = new Token(lexer.getTokenEnd(), lexer.getTokenStart(), type);
            this.myTokenQueue.offer(token);
            lexer.advance();
        }
        this.locateToken();
    }

    public void setFile(BaseJspFile file) {
        this.myJspLexer.setFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/JspHighlightingLexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/JspHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPosition
    implements LexerPosition {
        public final int start;
        public final MyState state;

        MyPosition(int start, MyState state) {
            this.start = start;
            this.state = state;
        }

        public int getOffset() {
            return this.start;
        }

        public int getState() {
            return 0;
        }
    }

    private static class MyState
    implements LexerState {
        public final Queue<Token> queue;
        public final JspLexer.Position jspState;

        MyState(Queue<Token> queue, JspLexer.Position jspState) {
            this.queue = queue;
            this.jspState = jspState;
        }

        public short intern() {
            return 0;
        }
    }

    private static class Token {
        public final int tokenStart;
        public final int tokenEnd;
        public final IElementType tokenType;

        Token(int tokenEnd, int tokenStart, IElementType tokenType) {
            this.tokenEnd = tokenEnd;
            this.tokenStart = tokenStart;
            this.tokenType = tokenType;
        }
    }
}

