/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.java.ReadonlyWhitespaceBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.JspTextSyntheticBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspTextBlock
extends AbstractXmlBlock {
    @Nullable
    private final Block myBaseLanguageBlock;
    private final Indent myParentIndent;
    private final Language myLanguage;
    private boolean myHeadIncomplete = false;
    private boolean myTailIncomplete = false;
    private TextRange cdataStartRange;
    private TextRange cdataEndRange;
    private TextRange cdataRange;
    private boolean hasNewLinesInCdata;
    private boolean hasNewLinesInCdataSet;
    private String myNodeText;
    private TextRange myNodeRange;

    public JspTextBlock(ASTNode node, XmlFormattingPolicy policy, Pair<PsiElement, Language> rootBlockInfo, Indent indent) {
        super(node, null, null, policy);
        this.myParentIndent = indent;
        this.myLanguage = (Language)rootBlockInfo.getSecond();
        this.myBaseLanguageBlock = policy.getOrCreateBlockFor(rootBlockInfo);
    }

    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    public boolean isTextElement() {
        return true;
    }

    protected List<Block> buildChildren() {
        if (this.myBaseLanguageBlock == null) {
            return new ArrayList<Block>();
        }
        ArrayList<Block> result = new ArrayList<Block>();
        this.extractBlocks(this.myBaseLanguageBlock, this.myNode.getTextRange(), result);
        for (Block block : result) {
            if (!(block instanceof JspTextSyntheticBlock)) continue;
            ((JspTextSyntheticBlock)block).setIndent(this.myParentIndent);
        }
        return result;
    }

    private boolean extractBlocks(Block parentBlock, TextRange textRange, ArrayList<Block> result) {
        if (textRange.getStartOffset() >= textRange.getEndOffset()) {
            return false;
        }
        TextRange blockRange = parentBlock.getTextRange();
        if (blockRange.getStartOffset() >= textRange.getStartOffset() && blockRange.getEndOffset() <= textRange.getEndOffset()) {
            result.add(parentBlock);
            this.findCdataStart(parentBlock);
            return true;
        }
        if (blockRange.getEndOffset() < textRange.getStartOffset()) {
            return false;
        }
        if (blockRange.getStartOffset() >= textRange.getEndOffset()) {
            return false;
        }
        List subBlocks = parentBlock.getSubBlocks();
        ArrayList<Block> localResult = new ArrayList<Block>();
        int fromIndex = -1;
        for (int i = 0; i < subBlocks.size(); ++i) {
            Block block = (Block)subBlocks.get(i);
            TextRange subRange = block.getTextRange();
            if (subRange.getStartOffset() < textRange.getStartOffset() && subRange.getEndOffset() > textRange.getStartOffset() && subRange.getEndOffset() <= textRange.getEndOffset()) {
                this.myHeadIncomplete = true;
            }
            if (subRange.getStartOffset() >= textRange.getStartOffset() && subRange.getStartOffset() < textRange.getEndOffset() && subRange.getEndOffset() > textRange.getEndOffset()) {
                this.myTailIncomplete = true;
            }
            boolean added = this.extractBlocks(block, (TextRange)new UnfairTextRange(Math.max(textRange.getStartOffset(), subRange.getStartOffset()), Math.min(textRange.getEndOffset(), subRange.getEndOffset())), localResult);
            if (fromIndex != -1 || !added) continue;
            fromIndex = i;
        }
        if (!localResult.isEmpty()) {
            String str;
            int firstBlockStartOffset = ((Block)localResult.get(0)).getTextRange().getStartOffset();
            int lastBlockEndOffset = ((Block)localResult.get(localResult.size() - 1)).getTextRange().getEndOffset();
            Indent parentIndent = firstBlockStartOffset > blockRange.getStartOffset() && lastBlockEndOffset < blockRange.getEndOffset() ? Indent.getNoneIndent() : parentBlock.getIndent();
            if (this.shoouldResetOwnIndent() && localResult.size() == 1 && localResult.get(0) instanceof JspTextSyntheticBlock) {
                ((JspTextSyntheticBlock)localResult.get(0)).setIndent(Indent.getNoneIndent());
            }
            JspTextSyntheticBlock syntheticBlock = new JspTextSyntheticBlock(parentBlock, fromIndex, parentIndent, localResult);
            result.add(syntheticBlock);
            this.findCdataStart(syntheticBlock);
            if (this.cdataStartRange != null && this.cdataStartRange.getStartOffset() == syntheticBlock.getTextRange().getStartOffset()) {
                syntheticBlock.setSpacing(JspTextBlock.createCdataSpacing());
            }
            if (this.cdataEndRange == null && this.containsCdata(syntheticBlock, str = "]]>")) {
                this.cdataEndRange = syntheticBlock.getTextRange();
                syntheticBlock.setSpacing(JspTextBlock.createCdataSpacing());
            }
            return true;
        }
        TextRange intersection = blockRange.intersection(textRange);
        if (intersection != null) {
            result.add((Block)new ReadonlyWhitespaceBlock(intersection, null, null, Indent.getNoneIndent()));
        }
        return true;
    }

    private static Spacing createCdataSpacing() {
        return Spacing.createSpacing((int)-1, (int)-1, (int)0, (boolean)true, (int)2);
    }

    private void findCdataStart(Block parentBlock) {
        String str;
        if (this.cdataStartRange == null && this.containsCdata(parentBlock, str = "<![CDATA[")) {
            Block block = this.findInnerMostBlockWithCData(parentBlock, str);
            if (block == null) {
                block = parentBlock;
            }
            this.cdataStartRange = block.getTextRange();
        }
    }

    private Block findInnerMostBlockWithCData(Block parentBlock, String str) {
        for (Block b : parentBlock.getSubBlocks()) {
            if (!this.containsCdata(b, str)) continue;
            Block subBlock = this.findInnerMostBlockWithCData(b, str);
            return subBlock != null ? subBlock : b;
        }
        return null;
    }

    private boolean containsCdata(Block b, String string) {
        return this.getText(b).contains(string);
    }

    private String getText(Block b) {
        if (this.myNodeText == null) {
            this.myNodeText = this.myNode.getText();
            this.myNodeRange = this.myNode.getTextRange();
        }
        TextRange syntheticRange = b.getTextRange();
        int start = syntheticRange.getStartOffset() - this.myNodeRange.getStartOffset();
        return this.myNodeText.substring(start, start + syntheticRange.getLength());
    }

    private boolean shoouldResetOwnIndent() {
        return this.myLanguage == StdLanguages.HTML || this.myLanguage == StdLanguages.JSP || this.myLanguage == StdLanguages.XML || this.myLanguage == StdLanguages.XHTML;
    }

    protected XmlTag findXmlTagAt(ASTNode child, int startOffset) {
        return JspTextBlock.findJspTag(child, startOffset);
    }

    @Nullable
    static XmlTag findJspTag(ASTNode child, int startOffset) {
        FileViewProvider viewProvider = child.getPsi().getContainingFile().getViewProvider();
        PsiFile file = viewProvider.getPsi(viewProvider.getBaseLanguage());
        if (file.getLanguage() != StdLanguages.JSP) {
            return null;
        }
        ASTNode rootToIgnore = JspTextBlock.getRootFor(child);
        JspFile jspFile = (JspFile)file;
        JspxFileViewProvider provider = jspFile.getViewProvider();
        PsiFile[] psiRoots = new PsiFile[]{provider.getPsi((Language)NewJspLanguage.INSTANCE), jspFile.getBaseLanguageRoot(), provider.getPsi(JspWithOtherWorldIntegrationService.getJavaLanguage())};
        for (int i = 0; i < 2; ++i) {
            XmlTag result = JspTextBlock.findTagInRoot((PsiElement)psiRoots[i], rootToIgnore, startOffset);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static XmlTag findTagInRoot(PsiElement jspRoot, ASTNode rootToIgnore, int startOffset) {
        ASTNode found;
        if (jspRoot.getNode() != rootToIgnore && (found = jspRoot.getNode().findLeafElementAt(startOffset)) != null) {
            ASTNode foundTag = JspTextBlock.findTagParentWithTheSameOffset(found);
            if (foundTag == null) {
                return null;
            }
            PsiElement foundPsiElement = foundTag.getPsi();
            if (foundPsiElement instanceof XmlTag) {
                return (XmlTag)foundTag.getPsi();
            }
        }
        return null;
    }

    @Nullable
    public static Pair<PsiElement, Language> findPsiRootAt(ASTNode child, boolean processJavaTree) {
        ASTNode found;
        PsiFile jspRoot;
        FileViewProvider viewProvider = child.getPsi().getContainingFile().getViewProvider();
        PsiFile file = viewProvider.getPsi(viewProvider.getBaseLanguage());
        if (!(file instanceof JspFile)) {
            return null;
        }
        int startOffset = child.getTextRange().getStartOffset();
        ASTNode rootToIgnore = JspTextBlock.getRootFor(child);
        if (file.getLanguage() == StdLanguages.JSP && (jspRoot = file.getViewProvider().getPsi((Language)NewJspLanguage.INSTANCE)).getNode() != rootToIgnore && (found = jspRoot.getNode().findLeafElementAt(startOffset)) != null && !(found.getPsi() instanceof XmlText) && !(found.getPsi() instanceof JspScriptlet) && found.getElementType() != JspTokenType.JAVA_CODE) {
            return Pair.create((Object)jspRoot, (Object)StdLanguages.XML);
        }
        if (!processJavaTree || !viewProvider.getLanguages().contains(StdLanguages.JAVA)) {
            return null;
        }
        PsiElement declElement = viewProvider.findElementAt(startOffset, StdLanguages.JAVA);
        if (declElement == null) {
            return null;
        }
        return Pair.create((Object)TreeUtil.getFileElement((TreeElement)((TreeElement)declElement.getNode())).getPsi(), (Object)StdLanguages.JAVA);
    }

    private static ASTNode getRootFor(ASTNode child) {
        return TreeUtil.getFileElement((TreeElement)((TreeElement)child));
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            JspTextBlock.$$$reportNull$$$0(0);
        }
        if (this.myBaseLanguageBlock != null) {
            return this.myBaseLanguageBlock.getSpacing(child1, child2);
        }
        return null;
    }

    public Indent getIndent() {
        return Indent.getNoneIndent();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (newChildIndex > 0 && this.getSubBlocks().get(newChildIndex - 1) instanceof JspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                JspTextBlock.$$$reportNull$$$0(1);
            }
            return childAttributes;
        }
        if (newChildIndex == 0 && this.getSubBlocks().get(0) instanceof JspTextSyntheticBlock) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
            if (childAttributes == null) {
                JspTextBlock.$$$reportNull$$$0(2);
            }
            return childAttributes;
        }
        if (this.myBaseLanguageBlock != null) {
            ChildAttributes childAttributes = this.myBaseLanguageBlock.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                JspTextBlock.$$$reportNull$$$0(3);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(null, null);
        if (childAttributes == null) {
            JspTextBlock.$$$reportNull$$$0(4);
        }
        return childAttributes;
    }

    public String toString() {
        return this.myNode.getText();
    }

    protected static ASTNode findTagParentWithTheSameOffset(ASTNode correspondingNode) {
        int offset = correspondingNode.getTextRange().getStartOffset();
        ASTNode result = correspondingNode;
        while (result.getTreeParent() != null && result.getTreeParent().getTextRange().getStartOffset() == offset) {
            if (result.getTreeParent().getPsi() instanceof XmlTag) {
                return result.getTreeParent();
            }
            result = result.getTreeParent();
        }
        return result;
    }

    public boolean isHeadIncomplete() {
        return this.myHeadIncomplete;
    }

    public boolean isTailIncomplete() {
        return this.myTailIncomplete;
    }

    private boolean isReadOnly(Block block) {
        if (!this.hasNewLinesInCdataSet) {
            if (this.cdataStartRange != null && this.cdataEndRange != null) {
                this.cdataRange = new TextRange(this.cdataStartRange.getStartOffset(), this.cdataEndRange.getEndOffset());
                for (int i = this.cdataStartRange.getEndOffset(); i < this.cdataEndRange.getStartOffset(); ++i) {
                    if (this.myNodeText.charAt(i - this.myNodeRange.getStartOffset()) != '\n') continue;
                    this.hasNewLinesInCdata = true;
                    break;
                }
            } else {
                this.hasNewLinesInCdata = true;
            }
            this.hasNewLinesInCdataSet = true;
        }
        if (this.hasNewLinesInCdata) {
            return false;
        }
        return this.cdataRange.contains(block.getTextRange()) && block.getSubBlocks().size() > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/JspTextBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/JspTextBlock";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

