/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.jsp;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilderDriver;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxJavaLexer
extends LexerBase {
    @NonNls
    private static final String EXPRESSION_TAG = "expression";
    @NonNls
    private static final String DECLARATION_TAG = "declaration";
    @NonNls
    private static final String SCRIPTLET_TAG = "scriptlet";
    @NonNls
    private static final String ROOT_TAG = "root";
    private final Lexer myJavaLexer;
    private final List<Token> myTokenQueue;
    private int myLastTokenEnd = 0;
    private int myCurrentToken = 0;
    private CharSequence myBuffer;
    private int myBufferEnd;
    private Token myNullToken;

    public JspxJavaLexer(CharSequence text, LanguageLevel level) {
        this.myJavaLexer = JavaParserDefinition.createLexer((LanguageLevel)level);
        this.myTokenQueue = new ArrayList<Token>(1000);
        this.myBufferEnd = text.length();
        this.myBuffer = text;
        this.fillQueue(text);
    }

    private void offerToken(Token token) {
        if (this.myLastTokenEnd < token.tokenStart) {
            this.myTokenQueue.add(new Token(JspTokenType.JSP_TEMPLATE_DATA, this.myLastTokenEnd, token.tokenStart));
        }
        if (this.myLastTokenEnd > token.tokenStart) {
            return;
        }
        this.myTokenQueue.add(token);
        this.myLastTokenEnd = token.tokenEnd;
    }

    private void jspActionStart(int start) {
        this.offerToken(new Token(XmlTokenType.XML_START_TAG_START, start, start + 1));
        this.offerToken(new Token(XmlTokenType.XML_TAG_END, start + 1, start + 2));
    }

    private void jspActionEnd(int end) {
        this.offerToken(new Token(XmlTokenType.XML_END_TAG_START, Math.max(0, end - 2), end - 1));
        this.offerToken(new Token(XmlTokenType.XML_TAG_END, end - 1, end));
    }

    private void fillQueue(final CharSequence text) {
        XmlBuilder processor = new XmlBuilder(){
            private final Stack<JavaFragmentBuilder> myFragmentStack = new Stack();
            private int depth = 0;
            private JavaFragmentBuilder myCurrentFragment = null;

            public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
            }

            public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startOffset, int endOffset, int headerEndOffset) {
                if (startOffset == endOffset) {
                    return XmlBuilder.ProcessingOrder.TAGS;
                }
                this.terminateFragmentIfNecessary();
                ++this.depth;
                if (this.depth == 1) {
                    JspxJavaLexer.this.offerToken(new Token(JspTokenType.JSPX_ROOT_TAG_HEADER, JspxJavaLexer.this.myLastTokenEnd, headerEndOffset));
                    return XmlBuilder.ProcessingOrder.TAGS;
                }
                boolean jspSpecialTag = "http://java.sun.com/JSP/Page".equals(namespace);
                if (jspSpecialTag) {
                    if (Comparing.equal((CharSequence)JspxJavaLexer.ROOT_TAG, (CharSequence)localName)) {
                        return XmlBuilder.ProcessingOrder.TAGS;
                    }
                    if (Comparing.equal((CharSequence)JspxJavaLexer.SCRIPTLET_TAG, (CharSequence)localName)) {
                        this.myCurrentFragment = new JavaFragmentBuilder(startOffset, endOffset, JspTokenType.JSP_SCRIPTLET_START, JspTokenType.JSP_SCRIPTLET_END);
                        return XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS;
                    }
                    if (Comparing.equal((CharSequence)JspxJavaLexer.DECLARATION_TAG, (CharSequence)localName)) {
                        this.myCurrentFragment = new JavaFragmentBuilder(startOffset, endOffset, JspTokenType.JSP_DECLARATION_START, JspTokenType.JSP_DECLARATION_END);
                        return XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS;
                    }
                    if (Comparing.equal((CharSequence)JspxJavaLexer.EXPRESSION_TAG, (CharSequence)localName)) {
                        this.myCurrentFragment = new JavaFragmentBuilder(startOffset, endOffset, JspTokenType.JSP_EXPRESSION_START, JspTokenType.JSP_EXPRESSION_END);
                        return XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS;
                    }
                    JspxJavaLexer.this.jspActionStart(startOffset);
                } else if (!this.isTemplateDataNs(namespace)) {
                    JspxJavaLexer.this.jspActionStart(startOffset);
                    if (CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"%=", (int)startOffset, (int)headerEndOffset) >= 0) {
                        return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                    }
                }
                return XmlBuilder.ProcessingOrder.TAGS;
            }

            private void terminateFragmentIfNecessary() {
                if (this.myCurrentFragment != null) {
                    this.myCurrentFragment.feedTextsToJava();
                    this.myFragmentStack.push(this.myCurrentFragment);
                }
            }

            public void endTag(CharSequence localName, String namespace, int startOffset, int endOffset) {
                if (startOffset == endOffset) {
                    return;
                }
                if (JspxJavaLexer.this.myLastTokenEnd > endOffset) {
                    return;
                }
                boolean jspSpecialTag = "http://java.sun.com/JSP/Page".equals(namespace);
                if (jspSpecialTag) {
                    if (Comparing.equal((CharSequence)JspxJavaLexer.SCRIPTLET_TAG, (CharSequence)localName) || Comparing.equal((CharSequence)JspxJavaLexer.DECLARATION_TAG, (CharSequence)localName) || Comparing.equal((CharSequence)JspxJavaLexer.EXPRESSION_TAG, (CharSequence)localName)) {
                        if (this.myCurrentFragment != null) {
                            this.myCurrentFragment.done();
                            this.myCurrentFragment = this.myFragmentStack.isEmpty() ? null : this.myFragmentStack.pop();
                        }
                    } else if (!Comparing.equal((CharSequence)JspxJavaLexer.ROOT_TAG, (CharSequence)localName)) {
                        JspxJavaLexer.this.jspActionEnd(endOffset);
                    }
                } else if (!this.isTemplateDataNs(namespace)) {
                    JspxJavaLexer.this.jspActionEnd(endOffset);
                }
                --this.depth;
                if (this.depth == 0) {
                    JspxJavaLexer.this.offerToken(new Token(JspTokenType.JSPX_ROOT_TAG_FOOTER, JspxJavaLexer.this.myLastTokenEnd, endOffset));
                }
            }

            private boolean isTemplateDataNs(String namespace) {
                return "http://www.w3.org/1999/xhtml".equals(namespace) || Arrays.asList(XmlUtil.FACELETS_URIS).contains(namespace) || "".equals(namespace);
            }

            public void attribute(CharSequence name, CharSequence value, int startOffset, int endOffset) {
                int exprEnd;
                int exprStart = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"%=", (int)startOffset, (int)endOffset);
                if (exprStart >= 0 && (exprEnd = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"%", (int)(exprStart + 2), (int)endOffset)) >= 0) {
                    JspxJavaLexer.this.offerToken(new Token(JspTokenType.JSP_EXPRESSION_START, exprStart, exprStart + 2));
                    JspxJavaLexer.this.fedExpressionTexts(exprStart, exprEnd, text);
                    JspxJavaLexer.this.offerToken(new Token(JspTokenType.JSP_EXPRESSION_END, exprEnd, exprEnd + 1));
                }
            }

            public void textElement(CharSequence display, CharSequence physical, int startOffset, int endOffset) {
                assert (this.myCurrentFragment != null);
                this.myCurrentFragment.text(display, startOffset, endOffset);
            }

            public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                if (this.myCurrentFragment != null) {
                    this.myCurrentFragment.feedTextsToJava();
                }
            }

            public void error(@NotNull String message, int startOffset, int endOffset) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/psi/impl/source/parsing/jsp/JspxJavaLexer$1", "error"));
            }
        };
        XmlBuilderDriver driver = new XmlBuilderDriver(text);
        driver.addImplicitBinding("jsp", "http://java.sun.com/JSP/Page");
        driver.build(processor);
        if (this.myLastTokenEnd < this.myBufferEnd) {
            this.myTokenQueue.add(new Token(JspTokenType.JSP_TEMPLATE_DATA, this.myLastTokenEnd, this.myBufferEnd));
        }
    }

    private void fedExpressionTexts(int exprStart, int exprEnd, CharSequence text) {
        JavaFragmentBuilder builder = new JavaFragmentBuilder(exprStart + 2, exprEnd, null, null);
        int curTextStart = exprStart + 2;
        while (true) {
            int entityIndex = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"&", (int)curTextStart, (int)exprEnd);
            int entityDoneIndex = 0;
            if (entityIndex > 0) {
                entityDoneIndex = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)";", (int)entityIndex, (int)exprEnd) + 1;
            }
            if (entityIndex <= 0 || entityDoneIndex <= 0) break;
            CharSequence preEntityPhysical = text.subSequence(curTextStart, entityIndex);
            CharSequence entityPhysical = text.subSequence(entityIndex, entityDoneIndex);
            String entityDisplay = new String(new char[]{XmlUtil.getCharFromEntityRef((String)entityPhysical.toString())});
            builder.text(preEntityPhysical, curTextStart, entityIndex);
            builder.text(entityDisplay, entityIndex, entityDoneIndex);
            curTextStart = entityDoneIndex;
        }
        CharSequence physical = text.subSequence(curTextStart, exprEnd);
        builder.text(physical, curTextStart, exprEnd);
        builder.done();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JspxJavaLexer.$$$reportNull$$$0(0);
        }
        assert (initialState == 0);
        this.myBuffer = buffer;
        this.myBufferEnd = endOffset;
        this.myNullToken = new Token(null, endOffset, endOffset);
        this.myCurrentToken = 0;
        while (this.currentToken().tokenStart < startOffset) {
            this.advance();
        }
    }

    @Nullable
    public IElementType getTokenType() {
        return this.currentToken().tokenType;
    }

    public int getTokenStart() {
        return this.currentToken().tokenStart;
    }

    public int getTokenEnd() {
        return this.currentToken().tokenEnd;
    }

    private Token currentToken() {
        if (this.myCurrentToken >= this.myTokenQueue.size()) {
            return this.myNullToken;
        }
        Token token = this.myTokenQueue.get(this.myCurrentToken);
        return token.tokenStart < this.myBufferEnd ? token : this.myNullToken;
    }

    public int getState() {
        return 0;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            JspxJavaLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public void advance() {
        if (this.currentToken() != this.myNullToken) {
            ++this.myCurrentToken;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/parsing/jsp/JspxJavaLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/parsing/jsp/JspxJavaLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JavaFragmentBuilder {
        private final int myTagStart;
        private final int myTagEnd;
        private final IElementType myPrefix;
        private final IElementType mySuffix;
        private final TIntArrayList myPhysicalStarts = new TIntArrayList();
        private final TIntArrayList myDisplayStarts = new TIntArrayList();
        private final StringBuilder myDisplayBuilder = new StringBuilder();
        private int myRealPhysicalStart = 0;
        private int myRealPhysicalEnd = 0;
        private int myFedUpTo = 0;

        JavaFragmentBuilder(int tagStart, int tagEnd, IElementType prefix, IElementType suffix) {
            this.myTagStart = tagStart;
            this.myTagEnd = tagEnd;
            this.myPrefix = prefix;
            this.mySuffix = suffix;
        }

        public void text(CharSequence display, int startOffset, int endOffset) {
            if (display.length() == 0) {
                return;
            }
            if (this.myRealPhysicalStart == 0) {
                this.myRealPhysicalStart = startOffset;
            }
            this.myRealPhysicalEnd = endOffset;
            this.myPhysicalStarts.add(startOffset);
            this.myDisplayStarts.add(this.myDisplayBuilder.length());
            this.myDisplayBuilder.append(display);
        }

        public void done() {
            if (this.myDisplayBuilder.length() > 0) {
                this.feedTextsToJava();
                if (JspxJavaLexer.this.myLastTokenEnd < this.myTagEnd && this.mySuffix != null) {
                    JspxJavaLexer.this.offerToken(new Token(this.mySuffix, JspxJavaLexer.this.myLastTokenEnd, this.myTagEnd));
                }
            }
        }

        private int displayToPhysical(int displayIndex) {
            if (this.myDisplayStarts.isEmpty()) {
                return displayIndex;
            }
            int bsResult = this.myDisplayStarts.binarySearch(displayIndex);
            if (bsResult >= 0) {
                return this.myPhysicalStarts.get(bsResult);
            }
            int insertionIndex = -bsResult - 1;
            int prevPhysGapStart = insertionIndex > 0 ? this.myPhysicalStarts.get(insertionIndex - 1) : 0;
            int prevDisplayGapStart = insertionIndex > 0 ? this.myDisplayStarts.get(insertionIndex - 1) : 0;
            return displayIndex - prevDisplayGapStart + prevPhysGapStart;
        }

        public void feedTextsToJava() {
            if (this.myFedUpTo == 0 && this.myPrefix != null) {
                JspxJavaLexer.this.offerToken(new Token(this.myPrefix, this.myTagStart, Math.max(this.myRealPhysicalStart, this.myTagStart)));
            }
            JspxJavaLexer.this.myJavaLexer.start((CharSequence)this.myDisplayBuilder, this.myFedUpTo, this.myDisplayBuilder.length());
            this.myFedUpTo = this.myDisplayBuilder.length();
            while (JspxJavaLexer.this.myJavaLexer.getTokenType() != null) {
                int displayStart = JspxJavaLexer.this.myJavaLexer.getTokenStart();
                int displayEnd = JspxJavaLexer.this.myJavaLexer.getTokenEnd();
                Token token = new Token(JspxJavaLexer.this.myJavaLexer.getTokenType(), this.displayToPhysical(displayStart), Math.min(this.myRealPhysicalEnd, this.displayToPhysical(displayEnd)));
                JspxJavaLexer.this.offerToken(token);
                JspxJavaLexer.this.myJavaLexer.advance();
            }
        }
    }

    private class Token {
        public final int tokenStart;
        public final int tokenEnd;
        public final IElementType tokenType;

        Token(IElementType tokenType, int tokenStart, int tokenEnd) {
            this.tokenEnd = tokenEnd;
            this.tokenStart = tokenStart;
            this.tokenType = tokenType;
        }

        public String toString() {
            return JspxJavaLexer.this.myBuffer.subSequence(this.tokenStart, this.tokenEnd).toString();
        }
    }
}

