/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.jsp.impl.JspElementDescriptor;
import com.intellij.jsp.impl.JspElementDescriptorEx;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.jsp.el.impl.JspElVariablesProvider;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.MethodPropertyReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspReferencesProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    private static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    protected static final String NAME_ATTR_NAME = "name";

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JspReferencesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JspReferencesProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof XmlAttributeValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JspReferencesProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttribute attribute = (XmlAttribute)element.getParent();
        String localName = attribute.getLocalName();
        XmlTag tag = attribute.getParent();
        String tagLocalName = tag.getLocalName();
        String namespace = tag.getNamespace();
        if (NAME_ATTR_NAME.equals(localName) || "name-given".equals(localName)) {
            PsiElement grandParent = tag.getParent();
            if (BaseJspUtil.getDirectiveKindByTag(tag) != null) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new SchemaReferencesProvider.NameReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }
            if (grandParent instanceof XmlTag && ((XmlTag)grandParent).getDescriptor() instanceof JspElementDescriptor && ATTRIBUTE_TAG_NAME.equals(tagLocalName)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new ExternalAttributeReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
            if (JspReferencesProvider.isPropertyReferenceTagName(tagLocalName, namespace)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new BeanReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(5);
                }
                return psiReferenceArray;
            }
            if (ELEMENT_TAG_NAME.equals(tagLocalName)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new TagReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(6);
                }
                return psiReferenceArray;
            }
            if (ATTRIBUTE_TAG_NAME.equals(tagLocalName) && grandParent instanceof XmlTag && ELEMENT_TAG_NAME.equals(((XmlTag)grandParent).getLocalName())) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new AttributeReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(7);
                }
                return psiReferenceArray;
            }
        } else {
            if ("fragment".equals(localName) && BaseJspUtil.getDirectiveKindByTag(attribute.getParent()) == null) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new FragmentReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(8);
                }
                return psiReferenceArray;
            }
            if ("name-from-attribute".equals(localName) && JspDirectiveKind.VARIABLE == BaseJspUtil.getDirectiveKindByTag(attribute.getParent())) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new NameFromAttributeReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(9);
                }
                return psiReferenceArray;
            }
            if ("property".equals(localName) && JspReferencesProvider.isPropertyReferenceTagName(tagLocalName, namespace)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new MethodPropertyReference(element, !JspReferencesProvider.isWritablePropertyTagName(tagLocalName))};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(10);
                }
                return psiReferenceArray;
            }
            if ("id".equals(localName) && ("useBean".equals(tagLocalName) && "http://java.sun.com/JSP/Page".equals(namespace) || "define".equals(tagLocalName))) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new BeanVarSelfReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(11);
                }
                return psiReferenceArray;
            }
            if ("var".equals(localName) || "varStatus".equals(localName)) {
                if ("remove".equals(tagLocalName)) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new VariableReference(element)};
                    if (psiReferenceArray == null) {
                        JspReferencesProvider.$$$reportNull$$$0(12);
                    }
                    return psiReferenceArray;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new VariableOrSelfReference(element, "var".equals(localName))};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(13);
                }
                return psiReferenceArray;
            }
            if ("scope".equals(localName) && namespace.startsWith("http://java.sun.com/jsp/jstl")) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new RequestReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(14);
                }
                return psiReferenceArray;
            }
            if ("dynamic-attributes".equals(localName) && BaseJspUtil.getDirectiveKindByTag(tag) != null) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new AttributeValueSelfReference(element)};
                if (psiReferenceArray == null) {
                    JspReferencesProvider.$$$reportNull$$$0(15);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JspReferencesProvider.$$$reportNull$$$0(16);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isWritablePropertyTagName(@NonNls String tagLocalName) {
        return "setProperty".equals(tagLocalName) || "write".equals(tagLocalName);
    }

    private static boolean isPropertyReferenceTagName(@NonNls String tagLocalName, @NonNls String namespace) {
        boolean jspTag = "http://java.sun.com/JSP/Page".equals(namespace);
        return jspTag && ("getProperty".equals(tagLocalName) || "setProperty".equals(tagLocalName)) || !jspTag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_TAG_NAME;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FragmentReference
    extends BasicAttributeValueReference {
        FragmentReference(PsiElement element) {
            super(element);
        }

        @Nullable
        protected String getName(XmlTag tag) {
            return tag.getAttributeValue(JspReferencesProvider.NAME_ATTR_NAME);
        }

        @Nullable
        public PsiElement resolve() {
            final String fragmentAttributeName = this.getCanonicalText();
            if (fragmentAttributeName.isEmpty()) {
                return null;
            }
            final PsiElement[] result = new PsiElement[1];
            this.processAttributes(new PsiElementProcessor<XmlTag>(){

                public boolean execute(@NotNull XmlTag tag) {
                    String attributeName;
                    if (tag == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (fragmentAttributeName.equals(attributeName = this.getName(tag))) {
                        result[0] = tag;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$FragmentReference$1", "execute"));
                }
            });
            return result[0];
        }

        protected boolean isValidResult(XmlTag tag) {
            return true;
        }

        private void processAttributes(PsiElementProcessor<XmlTag> processor) {
            XmlTag[] attributeDirectives;
            for (XmlTag attributeDirective : attributeDirectives = this.getDeclarationTags()) {
                if (!this.isAcceptableAttribute(attributeDirective) || processor.execute((PsiElement)attributeDirective)) continue;
                return;
            }
        }

        protected boolean isAcceptableAttribute(XmlTag attributeDirective) {
            return attributeDirective.getAttributeValue("fragment") != null;
        }

        protected XmlTag[] getDeclarationTags() {
            return JspPsiUtil.getJspFile((PsiElement)this.myElement.getContainingFile()).getDirectiveTags(JspDirectiveKind.ATTRIBUTE, false);
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList fragmentAttributes = new ArrayList(1);
            this.processAttributes(new PsiElementProcessor<XmlTag>(){

                public boolean execute(@NotNull XmlTag tag) {
                    String attributeName;
                    if (tag == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((attributeName = this.getName(tag)) != null && !attributeName.isEmpty() && this.isNotAlreadyPresent(attributeName) && this.isValidResult(tag)) {
                        fragmentAttributes.add(attributeName);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$FragmentReference$2", "execute"));
                }
            });
            Object[] objectArray = ArrayUtil.toStringArray(fragmentAttributes);
            if (objectArray == null) {
                FragmentReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        protected boolean isNotAlreadyPresent(String attributeName) {
            return true;
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$FragmentReference", "getVariants"));
        }
    }

    static class NameFromAttributeReference
    extends FragmentReference {
        NameFromAttributeReference(PsiElement element) {
            super(element);
        }

        @Override
        protected boolean isAcceptableAttribute(XmlTag attributeDirective) {
            return true;
        }

        @Override
        protected boolean isValidResult(XmlTag tag) {
            return JspUtil.checkValidNameFromAttribute(tag) == null;
        }
    }

    public static class ExternalAttributeReference
    extends FragmentReference {
        public ExternalAttributeReference(PsiElement element) {
            super(element);
        }

        @Override
        protected boolean isAcceptableAttribute(XmlTag attributeDirective) {
            return true;
        }

        @Override
        protected String getName(XmlTag tag) {
            String name;
            PsiMetaData metaData = tag.getMetaData();
            if (metaData != null && (name = metaData.getName()) != null) {
                return name;
            }
            return super.getName(tag);
        }

        @Override
        protected XmlTag[] getDeclarationTags() {
            XmlTag customTag = (XmlTag)this.myElement.getParent().getParent().getParent();
            XmlElementDescriptor descriptor = customTag.getDescriptor();
            if (descriptor != null) {
                XmlAttributeDescriptor[] attributesDescriptors = descriptor.getAttributesDescriptors(customTag);
                ArrayList<XmlTag> result = new ArrayList<XmlTag>(attributesDescriptors.length);
                for (XmlAttributeDescriptor attributesDescriptor : attributesDescriptors) {
                    result.add((XmlTag)attributesDescriptor.getDeclaration());
                }
                return result.toArray(XmlTag.EMPTY);
            }
            return XmlTag.EMPTY;
        }

        @Override
        protected boolean isNotAlreadyPresent(String attributeName) {
            XmlTag customTag = (XmlTag)this.myElement.getParent().getParent().getParent();
            XmlElementDescriptor descriptor = customTag.getDescriptor();
            if (descriptor != null) {
                return customTag.getAttributeValue(attributeName) == null && !((JspElementDescriptorEx)descriptor).isRequiredAttributeImplicitlyPresent(customTag, attributeName);
            }
            return true;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            XmlAttributeDescriptor xmlAttributeDescriptor;
            PsiElement psiElement = super.resolve();
            if (psiElement != null) {
                return psiElement;
            }
            XmlTag customTag = (XmlTag)this.myElement.getParent().getParent().getParent();
            XmlElementDescriptor descriptor = customTag.getDescriptor();
            if (descriptor != null && (xmlAttributeDescriptor = descriptor.getAttributeDescriptor(this.getCanonicalText(), customTag)) instanceof AnyXmlAttributeDescriptor) {
                return this.myElement;
            }
            return null;
        }
    }

    static class BeanReference
    extends BasicAttributeValueReference {
        BeanReference(PsiElement element) {
            super(element);
        }

        private boolean processTagsWithId(PsiElement parent, XmlTag tag, PsiElementProcessor<XmlTag> processor) {
            if (parent instanceof XmlTag) {
                XmlTag parentTag = (XmlTag)parent;
                if (!processor.execute((PsiElement)parentTag)) {
                    return false;
                }
                for (XmlTag subTag : parentTag.getSubTags()) {
                    if (subTag == tag) break;
                    if (processor.execute((PsiElement)subTag)) continue;
                    return false;
                }
                if (parent instanceof JspXmlRootTag) {
                    PsiFile containingFile = parent.getContainingFile();
                    if (containingFile == null) {
                        return false;
                    }
                    this.processEmptyContext(containingFile, processor);
                    return false;
                }
                return this.processTagsWithId(parentTag.getParent(), parentTag, processor);
            }
            return false;
        }

        protected void processEmptyContext(PsiFile containingFile, PsiElementProcessor<XmlTag> processor) {
            JspUtil.visitAllIncludedFilesRecursively(JspPsiUtil.getJspFile((PsiElement)containingFile), file -> {
                XmlUtil.processXmlElements((XmlElement)file, (PsiElementProcessor)processor, (boolean)true);
                return true;
            }, true);
        }

        protected boolean checkOneTag(XmlTag subTag, String beanId) {
            return this.isAcceptableTagType(subTag) && beanId.equals(this.getKeyAttributeValue(subTag));
        }

        protected boolean isAcceptableTagType(XmlTag subTag) {
            String localName = subTag.getLocalName();
            String namespace = subTag.getNamespace();
            return "useBean".equals(localName) && "http://java.sun.com/JSP/Page".equals(namespace) || "define".equals(localName);
        }

        private void startProcessing(PsiElementProcessor<XmlTag> processor) {
            PsiElement parent = this.myElement.getParent().getParent();
            if (parent instanceof XmlTag) {
                this.processTagsWithId(parent.getParent(), (XmlTag)parent, processor);
            }
        }

        protected boolean isTagResult() {
            return false;
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result = new PsiElement[1];
            final String name = this.getCanonicalText();
            this.startProcessing((PsiElementProcessor<XmlTag>)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    XmlTag subTag;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlTag && this.checkOneTag(subTag = (XmlTag)element, name)) {
                        result[0] = this.isTagResult() ? subTag : this.getKeyAttribute(subTag).getValueElement();
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", JspReferencesProvider.ELEMENT_TAG_NAME, "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$BeanReference$1", "execute"));
                }
            });
            if (!this.isTagResult() && result[0] != null) {
                PsiElement psiElement;
                PsiReference[] references = result[0].getReferences();
                PsiElement psiElement2 = psiElement = references.length > 0 ? references[references.length - 1].resolve() : null;
                if (psiElement != null) {
                    result[0] = psiElement;
                }
            }
            return result[0];
        }

        @Nullable
        protected XmlAttribute getKeyAttribute(XmlTag tag) {
            return tag.getAttribute("id");
        }

        @Nullable
        protected String getKeyAttributeValue(XmlTag tag) {
            return tag.getAttributeValue("id");
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList tags = new ArrayList(1);
            this.startProcessing((PsiElementProcessor<XmlTag>)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    String idValue;
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlTag && this.isAcceptableTagType((XmlTag)element) && (idValue = this.getKeyAttributeValue((XmlTag)element)) != null) {
                        tags.add(idValue);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", JspReferencesProvider.ELEMENT_TAG_NAME, "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$BeanReference$2", "execute"));
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(tags);
            if (objectArray == null) {
                BeanReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$BeanReference", "getVariants"));
        }
    }

    static class RequestReference
    extends BasicAttributeValueReference {
        private static final String[] REQUEST_TYPES = new String[]{"request", "page", "session", "application"};

        RequestReference(PsiElement element) {
            super(element);
        }

        @Nullable
        public PsiElement resolve() {
            return Arrays.binarySearch(REQUEST_TYPES, this.getCanonicalText()) >= 0 ? this.myElement : null;
        }

        @NotNull
        public Object[] getVariants() {
            if (REQUEST_TYPES == null) {
                RequestReference.$$$reportNull$$$0(0);
            }
            return REQUEST_TYPES;
        }

        public boolean isSoft() {
            return false;
        }

        static {
            Arrays.sort(REQUEST_TYPES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$RequestReference", "getVariants"));
        }
    }

    static class VariableReference
    extends BeanReference {
        VariableReference(PsiElement element) {
            super(element);
        }

        @Override
        protected boolean isTagResult() {
            return true;
        }

        @Override
        protected boolean isAcceptableTagType(XmlTag subTag) {
            return super.isAcceptableTagType(subTag) || subTag.getAttributeValue("name-given") != null;
        }

        @Override
        protected XmlAttribute getKeyAttribute(XmlTag tag) {
            XmlAttribute keyAttribute = super.getKeyAttribute(tag);
            if (keyAttribute == null) {
                keyAttribute = tag.getAttribute("name-given");
            }
            return keyAttribute;
        }

        @Override
        protected String getKeyAttributeValue(XmlTag tag) {
            String keyValue = super.getKeyAttributeValue(tag);
            if (keyValue == null) {
                keyValue = tag.getAttributeValue("name-given");
            }
            return keyValue;
        }

        @Override
        protected void processEmptyContext(PsiFile containingFile, PsiElementProcessor<XmlTag> processor) {
            XmlTag[] directiveTags;
            super.processEmptyContext(containingFile, processor);
            for (XmlTag tag : directiveTags = JspPsiUtil.getJspFile((PsiElement)containingFile).getDirectiveTags(JspDirectiveKind.VARIABLE, true)) {
                if (processor.execute((PsiElement)tag)) continue;
                return;
            }
        }
    }

    static class VariableOrSelfReference
    extends VariableReference {
        private final boolean myVar;

        VariableOrSelfReference(PsiElement element, boolean var) {
            super(element);
            this.myVar = var;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            PsiElement psiElement = super.resolve();
            if (psiElement != null) {
                return psiElement;
            }
            if (!this.myVar) {
                return this.getElement();
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class);
            final String name = this.getCanonicalText();
            final Ref result = new Ref();
            ELResolveUtil.walkFromContext(tag, new ELElementProcessor(){

                @Override
                public boolean processNSPrefix(String prefix) {
                    return true;
                }

                @Override
                public boolean processVariable(PsiVariable variable) {
                    PsiElement declaration;
                    if (variable instanceof JspImplicitVariable && (declaration = ((JspImplicitVariable)variable).getDeclaration()) == this.getElement()) {
                        return true;
                    }
                    if (name.equals(variable.getName())) {
                        result.set((Object)variable);
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean processMethod(PsiMethod method) {
                    return true;
                }

                @Override
                public boolean processProperty(IProperty property) {
                    return true;
                }

                @Override
                public void setSubstitutor(PsiSubstitutor substitutor) {
                }

                @Override
                public String getNameHint() {
                    return name;
                }
            }, JspElVariablesProvider.DEFAULT_JSP_VAR_TYPE_PROVIDER, this.getElement().getParent());
            return result.get() == null ? this.getElement() : (PsiElement)result.get();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                VariableOrSelfReference.$$$reportNull$$$0(0);
            }
            PsiElement element2 = this.resolve();
            if (element instanceof JspImplicitVariable && ((JspImplicitVariable)element).getDeclaration() instanceof XmlAttributeValue && element2 instanceof XmlAttributeValue) {
                return ((XmlAttributeValue)((JspImplicitVariable)element).getDeclaration()).getValue().equals(((XmlAttributeValue)element2).getValue());
            }
            if (element instanceof XmlAttributeValue && element2 instanceof XmlAttributeValue) {
                return ((XmlAttributeValue)element).getValue().equals(((XmlAttributeValue)element2).getValue());
            }
            return this.myElement.getManager().areElementsEquivalent(element, element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", JspReferencesProvider.ELEMENT_TAG_NAME, "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$VariableOrSelfReference", "isReferenceTo"));
        }
    }

    public static class BeanVarSelfReference
    extends AttributeValueSelfReference {
        public BeanVarSelfReference(PsiElement element) {
            super(element);
        }

        @Nullable
        public PsiElement resolve() {
            PsiElement element = this.myElement.getParent().getParent();
            List<JspImplicitVariable> list = ELResolveUtil.createOrGetVariables((XmlTag)element, JspElVariablesProvider.DEFAULT_JSP_VAR_TYPE_PROVIDER);
            if (list != null) {
                String toSearch = this.getCanonicalText();
                for (JspImplicitVariable var : list) {
                    if (!toSearch.equals(var.getName())) continue;
                    return var;
                }
            }
            return null;
        }
    }

    private static class AttributeReference
    extends BasicAttributeValueReference {
        AttributeReference(PsiElement element) {
            super(element);
        }

        @Nullable
        private static XmlAttributeValue getElementName(XmlTag tag) {
            XmlAttributeValue value;
            XmlTag grandParentTag;
            PsiElement parent = tag.getParent();
            if (parent instanceof XmlTag && JspReferencesProvider.ELEMENT_TAG_NAME.equals(((XmlTag)parent).getLocalName()) && (grandParentTag = (XmlTag)parent).getAttributeValue(JspReferencesProvider.NAME_ATTR_NAME) != null && PsiTreeUtil.findChildOfType((PsiElement)(value = grandParentTag.getAttribute(JspReferencesProvider.NAME_ATTR_NAME).getValueElement()), OuterLanguageElement.class) == null) {
                return value;
            }
            return null;
        }

        private void processElements(Processor<XmlAttributeDescriptor> processor) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
            XmlAttributeValue value = AttributeReference.getElementName(tag);
            if (value == null) {
                return;
            }
            PsiReference[] references = value.getReferences();
            if (references.length > 0) {
                PsiReference reference = references[0];
                XmlElementDescriptor tagDescriptor = null;
                if (reference instanceof TagReference) {
                    tagDescriptor = ((TagReference)reference).doResolve();
                } else {
                    PsiMetaData metaData;
                    PsiElement psiElement = reference.resolve();
                    if (psiElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)psiElement).getMetaData()) instanceof XmlElementDescriptor) {
                        tagDescriptor = (XmlElementDescriptor)metaData;
                    }
                }
                if (tagDescriptor != null) {
                    for (XmlAttributeDescriptor d : tagDescriptor.getAttributesDescriptors(tag)) {
                        if (processor.process((Object)d)) continue;
                        return;
                    }
                }
            }
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result = new PsiElement[1];
            this.processElements(new Processor<XmlAttributeDescriptor>(){
                final String elementName;
                {
                    this.elementName = this.getCanonicalText();
                }

                public boolean process(XmlAttributeDescriptor descriptor) {
                    if (descriptor.getName().equals(this.elementName)) {
                        result[0] = descriptor.getDeclaration();
                        return false;
                    }
                    return true;
                }
            });
            return result[0];
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList variants = new ArrayList(3);
            this.processElements((Processor<XmlAttributeDescriptor>)((Processor)descriptor -> {
                variants.add(descriptor);
                return true;
            }));
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                AttributeReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return AttributeReference.getElementName((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class)) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$AttributeReference", "getVariants"));
        }
    }

    private static class TagReference
    extends BasicAttributeValueReference {
        TagReference(PsiElement element) {
            super(element);
        }

        private void processElements(Processor<XmlElementDescriptor> processor) {
            block5: {
                String prefix;
                XmlTag tag;
                block4: {
                    tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
                    PsiElement parent = tag.getParent();
                    prefix = XmlUtil.findPrefixByQualifiedName((String)this.getCanonicalText());
                    if (!(parent instanceof XmlTag) || !prefix.equals(((XmlTag)parent).getNamespacePrefix())) break block4;
                    XmlElementDescriptor descriptor = ((XmlTag)parent).getDescriptor();
                    if (descriptor == null) break block5;
                    for (XmlElementDescriptor d : descriptor.getElementsDescriptors((XmlTag)parent)) {
                        if (processor.process((Object)d)) continue;
                        return;
                    }
                    break block5;
                }
                XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(tag.getNamespaceByPrefix(prefix), true);
                if (nsDescriptor == null) {
                    nsDescriptor = tag.getNSDescriptor("http://www.w3.org/1999/xhtml", true);
                }
                if (nsDescriptor != null) {
                    XmlElementDescriptor[] rootElementsDescriptors;
                    for (XmlElementDescriptor d : rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors(((XmlFile)tag.getContainingFile()).getDocument())) {
                        if (processor.process((Object)d)) continue;
                        return;
                    }
                }
            }
        }

        @Nullable
        public PsiElement resolve() {
            XmlElementDescriptor descriptor = this.doResolve();
            return descriptor != null ? descriptor.getDeclaration() : null;
        }

        protected XmlElementDescriptor doResolve() {
            final XmlElementDescriptor[] descriptor = new XmlElementDescriptor[1];
            this.processElements(new Processor<XmlElementDescriptor>(){
                final String elementName;
                {
                    this.elementName = XmlUtil.findLocalNameByQualifiedName((String)this.getCanonicalText());
                }

                public boolean process(XmlElementDescriptor xmlElementDescriptor) {
                    if (xmlElementDescriptor.getName().equals(this.elementName)) {
                        descriptor[0] = xmlElementDescriptor;
                        return false;
                    }
                    return true;
                }
            });
            return descriptor[0];
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList variants = new ArrayList(3);
            this.processElements((Processor<XmlElementDescriptor>)((Processor)xmlElementDescriptor -> {
                variants.add(xmlElementDescriptor);
                return true;
            }));
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                TagReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspReferencesProvider$TagReference", "getVariants"));
        }
    }
}

