/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.IoProfiler;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IoTable
extends DataStoreTable<IoStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            IoTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Io_Files_Data", "AppId INTEGER NOT NULL", "FileSessionId INTEGER NOT NULL", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "Data BLOB");
            this.createTable("Io_Speed_Data", "AppId INTEGER NOT NULL", "Session INTEGER NOT NULL", "EndTime INTEGER", "Type INTEGER", "Speed INTEGER");
            this.createUniqueIndex("Io_Files_Data", "FileSessionId", "Session");
            this.createUniqueIndex("Io_Speed_Data", "AppId", "Session", "EndTime", "Type");
        }
        catch (SQLException ex) {
            IoTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(IoStatements.INSERT_IO_DATA, "INSERT OR REPLACE INTO Io_Files_Data (AppId, FileSessionId, Session, StartTime, EndTime, Data) VALUES (?, ?, ?, ?, ?, ?)");
            this.createStatement(IoStatements.QUERY_IO_DATA, "SELECT Data FROM Io_Files_Data WHERE AppId = ? AND Session = ? AND (EndTime > ? OR EndTime = -1) AND StartTime <= ?");
            this.createStatement(IoStatements.INSERT_SPEED_DATA, "INSERT OR IGNORE INTO Io_Speed_Data (AppId, Session, EndTime, Type, Speed) VALUES (?, ?, ?, ?, ?)");
            this.createStatement(IoStatements.QUERY_SPEED_DATA, "SELECT EndTime, Speed FROM Io_Speed_Data WHERE AppId = ? AND Session = ? AND Type = ? AND EndTime > ? AND EndTime <= ?");
        }
        catch (SQLException ex) {
            IoTable.onError(ex);
        }
    }

    public void insert(int appId, Common.Session session, IoProfiler.FileSession fileSession) {
        this.execute(IoStatements.INSERT_IO_DATA, appId, fileSession.getIoSessionId(), session, fileSession.getStartTimestamp(), fileSession.getEndTimestamp(), fileSession.toByteArray());
    }

    public void insert(int appId, Common.Session session, long endTimestamp, IoProfiler.IoSpeedData speedData) {
        this.execute(IoStatements.INSERT_SPEED_DATA, appId, session, endTimestamp, speedData.getTypeValue(), speedData.getSpeed());
    }

    private static Common.CommonData getCommonData(int appId, Common.Session session, long endTimestamp) {
        Common.CommonData.Builder builder = Common.CommonData.newBuilder();
        builder.setProcessId(appId);
        builder.setSession(session);
        builder.setEndTimestamp(endTimestamp);
        return builder.build();
    }

    public List<IoProfiler.FileSession> getFileData(int appId, Common.Session session, long startTimestamp, long endTimestamp) {
        boolean fileSessionColumn = true;
        try {
            ArrayList<IoProfiler.FileSession> fileData = new ArrayList<IoProfiler.FileSession>();
            ResultSet results = this.executeQuery(IoStatements.QUERY_IO_DATA, appId, session, startTimestamp, endTimestamp);
            while (results.next()) {
                byte[] data = results.getBytes(1);
                if (data == null) continue;
                IoProfiler.FileSession.Builder builder = IoProfiler.FileSession.newBuilder();
                builder.mergeFrom(data);
                fileData.add(builder.build());
            }
            return fileData;
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            IoTable.onError(ex);
            return null;
        }
    }

    public List<IoProfiler.IoSpeedData> getSpeedData(int appId, Common.Session session, long startTimestamp, long endTimestamp, IoProfiler.IoType type) {
        boolean endTimeColumn = true;
        int speedColumn = 2;
        try {
            ArrayList<IoProfiler.IoSpeedData> speedData = new ArrayList<IoProfiler.IoSpeedData>();
            ResultSet results = this.executeQuery(IoStatements.QUERY_SPEED_DATA, appId, session, type.getNumber(), startTimestamp, endTimestamp);
            while (results.next()) {
                IoProfiler.IoSpeedData.Builder speedDataBuilder = IoProfiler.IoSpeedData.newBuilder();
                speedDataBuilder.setBasicInfo(IoTable.getCommonData(appId, session, results.getLong(1)));
                speedDataBuilder.setType(type);
                speedDataBuilder.setSpeed(results.getLong(2));
                speedData.add(speedDataBuilder.build());
            }
            return speedData;
        }
        catch (SQLException ex) {
            IoTable.onError(ex);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/datastore/database/IoTable", "initialize"));
    }

    public static enum IoStatements {
        INSERT_IO_DATA,
        QUERY_IO_DATA,
        INSERT_SPEED_DATA,
        QUERY_SPEED_DATA;

    }
}

