/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profiler.protobuf3jarjar.GeneratedMessageV3;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import com.android.tools.profiler.protobuf3jarjar.Message;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryStatsTable
extends DataStoreTable<MemoryStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            MemoryStatsTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Memory_Samples", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Type INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp, Type)");
            this.createTable("Memory_AllocationInfo", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "InfoData BLOB", "LegacyEventsData BLOB", "LegacyDumpData BLOB", "PRIMARY KEY(Session, StartTime)");
            this.createTable("Memory_LegacyAllocationStack", "Session INTEGER NOT NULL", "Id INTEGER", "Data BLOB", "PRIMARY KEY(Session, Id)");
            this.createTable("Memory_LegacyAllocatedClass", "Session INTEGER NOT NULL", "Id INTEGER", "Data BLOB", "PRIMARY KEY(Session, Id)");
            this.createTable("Memory_HeapDump", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "Status INTEGER", "InfoData BLOB", "DumpData BLOB", "PRIMARY KEY(Session, StartTime)");
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @NotNull
    public MemoryProfiler.MemoryData getData(MemoryProfiler.MemoryRequest request) {
        long sessionId = request.getSession().getSessionId();
        long startTime = request.getStartTime();
        long endTime = request.getEndTime();
        List<MemoryProfiler.MemoryData.MemorySample> memorySamples = this.getResultsInfo(MemoryStatements.QUERY_MEMORY, sessionId, startTime, endTime, MemoryProfiler.MemoryData.MemorySample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.AllocStatsSample> allocStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.AllocStatsSample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.GcStatsSample> gcStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_GC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.GcStatsSample.getDefaultInstance());
        List<MemoryProfiler.HeapDumpInfo> heapDumpSamples = this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, sessionId, startTime, endTime, MemoryProfiler.HeapDumpInfo.getDefaultInstance());
        List<MemoryProfiler.AllocationsInfo> allocationSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOCATION_INFO_BY_TIME, sessionId, startTime, endTime, MemoryProfiler.AllocationsInfo.getDefaultInstance());
        MemoryProfiler.MemoryData.Builder response = MemoryProfiler.MemoryData.newBuilder().addAllMemSamples(memorySamples).addAllAllocStatsSamples(allocStatsSamples).addAllGcStatsSamples(gcStatsSamples).addAllHeapDumpInfos(heapDumpSamples).addAllAllocationsInfo(allocationSamples);
        MemoryProfiler.MemoryData memoryData = response.build();
        if (memoryData == null) {
            MemoryStatsTable.$$$reportNull$$$0(1);
        }
        return memoryData;
    }

    public void insertMemory(Common.Session session, List<MemoryProfiler.MemoryData.MemorySample> samples) {
        for (MemoryProfiler.MemoryData.MemorySample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.MEMORY.ordinal(), sample.toByteArray());
        }
    }

    public void insertAllocStats(Common.Session session, List<MemoryProfiler.MemoryData.AllocStatsSample> samples) {
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.ALLOC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertGcStats(Common.Session session, List<MemoryProfiler.MemoryData.GcStatsSample> samples) {
        for (MemoryProfiler.MemoryData.GcStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getStartTime(), MemorySamplesType.GC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertOrReplaceHeapInfo(Common.Session session, MemoryProfiler.HeapDumpInfo info) {
        this.execute(MemoryStatements.INSERT_OR_REPLACE_HEAP_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), MemoryProfiler.DumpDataResponse.Status.NOT_READY.ordinal(), info.toByteArray());
    }

    public MemoryProfiler.DumpDataResponse.Status getHeapDumpStatus(Common.Session session, long dumpTime) {
        try {
            ResultSet result = this.executeQuery(MemoryStatements.QUERY_HEAP_STATUS_BY_ID, session.getSessionId(), dumpTime);
            if (result.next()) {
                return MemoryProfiler.DumpDataResponse.Status.forNumber((int)result.getInt(1));
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return MemoryProfiler.DumpDataResponse.Status.NOT_FOUND;
    }

    public List<MemoryProfiler.HeapDumpInfo> getHeapDumpInfoByRequest(Common.Session session, MemoryProfiler.ListDumpInfosRequest request) {
        return this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, session.getSessionId(), request.getStartTime(), request.getEndTime(), MemoryProfiler.HeapDumpInfo.getDefaultInstance());
    }

    public void insertHeapDumpData(Common.Session session, long dumpTime, MemoryProfiler.DumpDataResponse.Status status, ByteString data) {
        this.execute(MemoryStatements.UPDATE_HEAP_DUMP, data.toByteArray(), status.getNumber(), session.getSessionId(), dumpTime);
    }

    @Nullable
    public byte[] getHeapDumpData(Common.Session session, long dumpTime) {
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_HEAP_DUMP_BY_ID, session.getSessionId(), dumpTime);
            if (resultSet.next()) {
                return resultSet.getBytes(1);
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    public void insertOrReplaceAllocationsInfo(Common.Session session, MemoryProfiler.AllocationsInfo info) {
        this.execute(MemoryStatements.INSERT_OR_REPLACE_ALLOCATIONS_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), info.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public void updateLegacyAllocationEvents(Common.Session session, long trackingStartTime, @NotNull MemoryProfiler.LegacyAllocationEventsResponse legacyAllocationEventsResponse) {
        void allocationData;
        if (legacyAllocationEventsResponse == null) {
            MemoryStatsTable.$$$reportNull$$$0(2);
        }
        this.execute(MemoryStatements.UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS, allocationData.toByteArray(), session.getSessionId(), trackingStartTime);
    }

    public void updateLegacyAllocationDump(Common.Session session, long trackingStartTime, byte[] data) {
        this.execute(MemoryStatements.UPDATE_LEGACY_ALLOCATIONS_INFO_DUMP, data, session.getSessionId(), trackingStartTime);
    }

    @Nullable
    public MemoryProfiler.AllocationsInfo getAllocationsInfo(Common.Session session, long trackingStartTime) {
        try {
            byte[] bytes;
            ResultSet results = this.executeQuery(MemoryStatements.QUERY_ALLOCATION_INFO_BY_ID, session.getSessionId(), trackingStartTime);
            if (results.next() && (bytes = results.getBytes(1)) != null) {
                return MemoryProfiler.AllocationsInfo.parseFrom((byte[])bytes);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    @Nullable
    public MemoryProfiler.LegacyAllocationEventsResponse getLegacyAllocationData(Common.Session session, long trackingStartTime) {
        try {
            byte[] bytes;
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_EVENTS_BY_ID, session.getSessionId(), trackingStartTime);
            if (resultSet.next() && (bytes = resultSet.getBytes(1)) != null) {
                return MemoryProfiler.LegacyAllocationEventsResponse.parseFrom((byte[])resultSet.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    @Nullable
    public byte[] getLegacyAllocationDumpData(Common.Session session, long trackingStartTime) {
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_DUMP_BY_ID, session.getSessionId(), trackingStartTime);
            if (resultSet.next()) {
                return resultSet.getBytes(1);
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    public void insertLegacyAllocationContext(@NotNull Common.Session session, @NotNull List<MemoryProfiler.AllocatedClass> classes, @NotNull List<MemoryProfiler.AllocationStack> stacks) {
        if (session == null) {
            MemoryStatsTable.$$$reportNull$$$0(3);
        }
        if (classes == null) {
            MemoryStatsTable.$$$reportNull$$$0(4);
        }
        if (stacks == null) {
            MemoryStatsTable.$$$reportNull$$$0(5);
        }
        classes.forEach(klass -> {
            if (session == null) {
                MemoryStatsTable.$$$reportNull$$$0(9);
            }
            this.execute(MemoryStatements.INSERT_LEGACY_ALLOCATED_CLASS, session.getSessionId(), klass.getClassId(), klass.toByteArray());
        });
        stacks.forEach(stack -> {
            if (session == null) {
                MemoryStatsTable.$$$reportNull$$$0(8);
            }
            this.execute(MemoryStatements.INSERT_LEGACY_ALLOCATION_STACK, session.getSessionId(), stack.getStackId(), stack.toByteArray());
        });
    }

    @NotNull
    public MemoryProfiler.AllocationContextsResponse getLegacyAllocationContexts(@NotNull MemoryProfiler.LegacyAllocationContextsRequest request) {
        if (request == null) {
            MemoryStatsTable.$$$reportNull$$$0(6);
        }
        MemoryProfiler.AllocationContextsResponse.Builder builder = MemoryProfiler.AllocationContextsResponse.newBuilder();
        try {
            MemoryProfiler.AllocatedClass data;
            int i;
            for (i = 0; i < request.getClassIdsCount(); ++i) {
                ResultSet classResultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATED_CLASS, request.getSession().getSessionId(), request.getClassIds(i));
                if (!classResultSet.next()) continue;
                data = ((MemoryProfiler.AllocatedClass.Builder)MemoryProfiler.AllocatedClass.newBuilder().mergeFrom(classResultSet.getBytes(1))).build();
                builder.addAllocatedClasses(data);
            }
            for (i = 0; i < request.getStackIdsCount(); ++i) {
                ResultSet stackResultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_STACK, request.getSession().getSessionId(), request.getStackIds(i));
                if (!stackResultSet.next()) continue;
                data = ((MemoryProfiler.AllocationStack.Builder)MemoryProfiler.AllocationStack.newBuilder().mergeFrom(stackResultSet.getBytes(1))).build();
                builder.addAllocationStacks((MemoryProfiler.AllocationStack)data);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        MemoryProfiler.AllocationContextsResponse allocationContextsResponse = builder.build();
        if (allocationContextsResponse == null) {
            MemoryStatsTable.$$$reportNull$$$0(7);
        }
        return allocationContextsResponse;
    }

    private <T extends GeneratedMessageV3> List<T> getResultsInfo(MemoryStatements query, long sessionId, long startTime, long endTime, T defaultInstance) {
        ArrayList<GeneratedMessageV3> datas = new ArrayList<GeneratedMessageV3>();
        try {
            ResultSet resultSet = this.executeQuery(query, sessionId, startTime, endTime);
            while (resultSet.next()) {
                Message data = defaultInstance.toBuilder().mergeFrom(resultSet.getBytes(1)).build();
                datas.add((GeneratedMessageV3)data);
            }
        }
        catch (InvalidProtocolBufferException | ClassCastException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return datas;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationData";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacks";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyAllocationContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateLegacyAllocationEvents";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertLegacyAllocationContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyAllocationContexts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertLegacyAllocationContext$1";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertLegacyAllocationContext$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum MemorySamplesType {
        MEMORY,
        ALLOC_STATS,
        GC_STATS;

    }

    public static enum MemoryStatements {
        INSERT_SAMPLE("INSERT OR IGNORE INTO Memory_Samples (Session, Timestamp, Type, Data) VALUES (?, ?, ?, ?)"),
        QUERY_MEMORY(String.format("SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.MEMORY.ordinal())),
        QUERY_ALLOC_STATS(String.format("SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.ALLOC_STATS.ordinal())),
        QUERY_GC_STATS(String.format("SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.GC_STATS.ordinal())),
        INSERT_OR_REPLACE_HEAP_INFO("INSERT OR REPLACE INTO Memory_HeapDump (Session, StartTime, EndTime, Status, InfoData) VALUES (?, ?, ?, ?, ?)"),
        UPDATE_HEAP_DUMP("UPDATE Memory_HeapDump SET DumpData = ?, Status = ? WHERE Session = ? AND StartTime = ?"),
        QUERY_HEAP_INFO_BY_TIME("SELECT InfoData FROM Memory_HeapDump where Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_HEAP_DUMP_BY_ID("SELECT DumpData FROM Memory_HeapDump where Session = ? AND StartTime = ?"),
        QUERY_HEAP_STATUS_BY_ID("SELECT Status FROM Memory_HeapDump where Session = ? AND StartTime = ?"),
        INSERT_OR_REPLACE_ALLOCATIONS_INFO("INSERT OR REPLACE INTO Memory_AllocationInfo (Session, StartTime, EndTime, InfoData) VALUES (?, ?, ?, ?)"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS("UPDATE Memory_AllocationInfo SET LegacyEventsData = ? WHERE Session = ? AND StartTime = ?"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_DUMP("UPDATE Memory_AllocationInfo SET LegacyDumpData = ? WHERE Session = ? AND StartTime = ?"),
        QUERY_ALLOCATION_INFO_BY_TIME("SELECT InfoData FROM Memory_AllocationInfo WHERE Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_ALLOCATION_INFO_BY_ID("SELECT InfoData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?"),
        QUERY_LEGACY_ALLOCATION_EVENTS_BY_ID("SELECT LegacyEventsData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?"),
        QUERY_LEGACY_ALLOCATION_DUMP_BY_ID("SELECT LegacyDumpData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?"),
        INSERT_LEGACY_ALLOCATION_STACK("INSERT OR IGNORE INTO Memory_LegacyAllocationStack (Session, Id, Data) VALUES (?, ?, ?)"),
        INSERT_LEGACY_ALLOCATED_CLASS("INSERT OR IGNORE INTO Memory_LegacyAllocatedClass (Session, Id, Data) VALUES (?, ?, ?)"),
        QUERY_LEGACY_ALLOCATION_STACK("Select Data FROM Memory_LegacyAllocationStack WHERE Session = ? AND Id = ?"),
        QUERY_LEGACY_ALLOCATED_CLASS("Select Data FROM Memory_LegacyAllocatedClass WHERE Session = ? AND Id = ?");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            if (sqlStatement == null) {
                MemoryStatements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                MemoryStatements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

