/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;

public class MemoryJvmtiDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myPollingService;
    private final MemoryLiveAllocationTable myLiveAllocationTable;
    private final Common.Session mySession;

    public MemoryJvmtiDataPoller(Common.Session session, MemoryLiveAllocationTable liveAllocationTable, MemoryServiceGrpc.MemoryServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.mySession = session;
        this.myLiveAllocationTable = liveAllocationTable;
        this.myPollingService = pollingService;
    }

    @Override
    public void poll() {
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(this.myDataRequestStartTimestampNs).setEndTime(Long.MAX_VALUE);
        MemoryProfiler.MemoryData response = this.myPollingService.getJvmtiData(dataRequestBuilder.build());
        for (MemoryProfiler.BatchAllocationSample sample : response.getAllocationSamplesList()) {
            this.myLiveAllocationTable.insertMethodInfo(this.mySession, sample.getMethodsList());
            this.myLiveAllocationTable.insertStackInfo(this.mySession, sample.getStacksList());
            this.myLiveAllocationTable.insertThreadInfo(this.mySession, sample.getThreadInfosList());
            this.myLiveAllocationTable.insertAllocationData(this.mySession, sample);
        }
        for (MemoryProfiler.BatchJNIGlobalRefEvent batchJniEvent : response.getJniReferenceEventBatchesList()) {
            this.myLiveAllocationTable.insertJniReferenceData(this.mySession, batchJniEvent);
        }
        if (response.getEndTimestamp() > this.myDataRequestStartTimestampNs) {
            this.myDataRequestStartTimestampNs = response.getEndTimestamp();
        }
    }
}

