/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.DeviceId;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.ProfilerTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ProfilerDevicePoller
extends PollRunner
implements DataStoreTable.DataStoreTableErrorCallback {
    private final ProfilerTable myTable;
    private final DataStoreService myService;
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myPollingService;
    private final Map<DeviceId, DeviceData> myDevices = new HashMap<DeviceId, DeviceData>();

    public ProfilerDevicePoller(DataStoreService service, ProfilerTable table, ProfilerServiceGrpc.ProfilerServiceBlockingStub pollingService) {
        super(TimeUnit.SECONDS.toNanos(1L));
        this.myTable = table;
        this.myService = service;
        this.myPollingService = pollingService;
    }

    @Override
    public void onDataStoreError(Throwable t) {
        if (this.myTable.isClosed()) {
            this.disconnect();
        }
    }

    @Override
    public void poll() {
        try {
            Profiler.GetDevicesRequest devicesRequest = Profiler.GetDevicesRequest.newBuilder().build();
            Profiler.GetDevicesResponse deviceResponse = this.myPollingService.getDevices(devicesRequest);
            for (Common.Device device : deviceResponse.getDeviceList()) {
                DeviceId deviceId = DeviceId.of(device.getDeviceId());
                this.myTable.insertOrUpdateDevice(device);
                DeviceData deviceData = this.myDevices.computeIfAbsent(deviceId, s -> new DeviceData(device));
                this.myService.setConnectedClients(deviceId, this.myPollingService.getChannel());
                Profiler.GetProcessesRequest processesRequest = Profiler.GetProcessesRequest.newBuilder().setDeviceId(deviceId.get()).build();
                Profiler.GetProcessesResponse processesResponse = this.myPollingService.getProcesses(processesRequest);
                HashSet<Common.Process> liveProcesses = new HashSet<Common.Process>();
                for (Common.Process process : processesResponse.getProcessList()) {
                    assert (process.getDeviceId() == deviceId.get());
                    this.myTable.insertOrUpdateProcess(deviceId, process);
                    liveProcesses.add(process);
                    deviceData.processes.remove(process);
                    Profiler.AgentStatusRequest agentStatusRequest = Profiler.AgentStatusRequest.newBuilder().setProcessId(process.getPid()).setDeviceId(deviceId.get()).build();
                    Profiler.AgentStatusResponse agentStatusResponse = this.myPollingService.getAgentStatus(agentStatusRequest);
                    this.myTable.updateAgentStatus(deviceId, process, agentStatusResponse);
                }
                this.killProcesses(deviceId, deviceData.processes);
                deviceData.processes.clear();
                deviceData.processes.addAll(liveProcesses);
            }
        }
        catch (StatusRuntimeException ex) {
            this.disconnect();
        }
    }

    private void disconnect() {
        for (Map.Entry<DeviceId, DeviceData> entry : this.myDevices.entrySet()) {
            this.disconnectDevice(entry.getValue().device);
            this.killProcesses(entry.getKey(), entry.getValue().processes);
            this.myService.disconnect(entry.getKey());
        }
        this.myDevices.clear();
    }

    private void disconnectDevice(Common.Device device) {
        Common.Device disconnectedDevice = device.toBuilder().setState(Common.Device.State.DISCONNECTED).build();
        this.myTable.insertOrUpdateDevice(disconnectedDevice);
    }

    private void killProcesses(DeviceId deviceId, Set<Common.Process> processes) {
        for (Common.Process process : processes) {
            Common.Process updatedProcess = process.toBuilder().setState(Common.Process.State.DEAD).build();
            this.myTable.insertOrUpdateProcess(deviceId, updatedProcess);
        }
    }

    private static final class DeviceData {
        public final Common.Device device;
        public final Set<Common.Process> processes = new HashSet<Common.Process>();

        DeviceData(Common.Device device) {
            this.device = device;
        }
    }
}

