/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class EnergyService
extends EnergyServiceGrpc.EnergyServiceImplBase
implements ServicePassThrough {
    private static final long FAKE_TIME_PERIOD_MS = 200L;
    private static final RandomData FAKE_CPU_DATA = new RandomData(20);
    private static final RandomData FAKE_NETWORK_DATA = new RandomData(30);
    @NotNull
    private final DataStoreService myService;
    private final Consumer<Runnable> myExecutor;

    public EnergyService(@NotNull DataStoreService service, Consumer<Runnable> fetchExecutor) {
        if (service == null) {
            EnergyService.$$$reportNull$$$0(0);
        }
        this.myService = service;
        this.myExecutor = fetchExecutor;
    }

    public void getData(EnergyProfiler.EnergyDataRequest request, StreamObserver<EnergyProfiler.EnergyDataResponse> responseObserver) {
        long firstSampleMs;
        EnergyProfiler.EnergyDataResponse.Builder responseBuilder = EnergyProfiler.EnergyDataResponse.newBuilder();
        long sessionStartTime = request.getSession().getStartTimestamp();
        long sessionEndTime = request.getSession().getEndTimestamp();
        long startTime = Math.max(request.getStartTimestamp() + 1L, sessionStartTime > 0L ? sessionStartTime : Long.MAX_VALUE);
        long endTime = Math.min(request.getEndTimestamp(), sessionEndTime > 0L ? sessionEndTime : Long.MAX_VALUE);
        long startTimeMs = TimeUnit.NANOSECONDS.toMillis(startTime);
        long endTimeMs = TimeUnit.NANOSECONDS.toMillis(endTime);
        for (long timeMs = firstSampleMs = startTimeMs + (200L - startTimeMs % 200L); timeMs <= endTimeMs; timeMs += 200L) {
            responseBuilder.addSampleData(EnergyProfiler.EnergyDataResponse.EnergySample.newBuilder().setTimestamp(TimeUnit.MILLISECONDS.toNanos(timeMs)).setCpuUsage(FAKE_CPU_DATA.getValue(timeMs)).setNetworkUsage(FAKE_NETWORK_DATA.getValue(timeMs)).build());
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            EnergyService.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            EnergyService.$$$reportNull$$$0(2);
        }
        if (connection == null) {
            EnergyService.$$$reportNull$$$0(3);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/EnergyService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/EnergyService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RandomData {
        private static final int NUM_VALUES = 1000;
        private final int[] values = new int[1000];

        RandomData(int bound) {
            Random random = new Random();
            for (int i = 0; i < 1000; ++i) {
                this.values[i] = random.nextInt(bound);
            }
        }

        public int getValue(long timeMs) {
            return this.values[(int)(timeMs / 100L % 1000L)];
        }
    }
}

