/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProfilerTooltipView
extends AspectObserver {
    @NotNull
    private final ProfilerTimeline myTimeline;
    @NotNull
    private final String myTitle;
    @NotNull
    protected final JLabel myHeadingLabel;
    @Nullable
    private JComponent myTooltipComponent;
    protected final Font myFont;
    private final int myMaximumLabelHeight;
    private int myMaximumWidth;

    protected ProfilerTooltipView(@NotNull ProfilerTimeline timeline, @NotNull String title) {
        if (timeline == null) {
            ProfilerTooltipView.$$$reportNull$$$0(0);
        }
        if (title == null) {
            ProfilerTooltipView.$$$reportNull$$$0(1);
        }
        this.myMaximumWidth = 0;
        this.myTimeline = timeline;
        this.myTitle = title;
        this.myHeadingLabel = new JLabel();
        this.myHeadingLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.myFont = this.myHeadingLabel.getFont().deriveFont(11.0f);
        this.myMaximumLabelHeight = this.myHeadingLabel.getFontMetrics(this.myFont).getHeight();
        this.myHeadingLabel.setFont(this.myFont);
        timeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
    }

    protected void timeChanged() {
        Range range = this.myTimeline.getTooltipRange();
        if (!range.isEmpty()) {
            String time = TimeAxisFormatter.DEFAULT.getFormattedString(this.myTimeline.getDataRange().getLength(), range.getMin() - this.myTimeline.getDataRange().getMin(), true);
            this.myHeadingLabel.setText(String.format("%s at %s", this.myTitle, time));
            this.updateMaximumLabelDimensions();
        } else {
            this.myHeadingLabel.setText("");
        }
    }

    protected final void updateMaximumLabelDimensions() {
        int oldMaxWidth = this.myMaximumWidth;
        this.myMaximumWidth = Math.max(this.myMaximumWidth, this.myHeadingLabel.getPreferredSize().width);
        this.myMaximumWidth = Math.max(this.myMaximumWidth, this.myTooltipComponent == null ? 0 : this.myTooltipComponent.getPreferredSize().width);
        if (oldMaxWidth != this.myMaximumWidth) {
            this.myHeadingLabel.setMinimumSize(new Dimension(this.myMaximumWidth, this.myMaximumLabelHeight));
        }
    }

    @NotNull
    protected abstract JComponent createTooltip();

    public final JComponent createComponent() {
        this.myTooltipComponent = this.createTooltip();
        this.myMaximumWidth = 0;
        this.myHeadingLabel.setMinimumSize(new Dimension(this.myMaximumWidth, this.myMaximumLabelHeight));
        this.updateMaximumLabelDimensions();
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "Fit,10px,*"));
        panel.add((Component)this.myHeadingLabel, new TabularLayout.Constraint(0, 0));
        panel.add((Component)this.myTooltipComponent, new TabularLayout.Constraint(2, 0));
        panel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        panel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        panel.setBorder((Border)new JBEmptyBorder(10, 10, 10, 10));
        this.timeChanged();
        return panel;
    }

    public void dispose() {
        this.myTimeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "timeline";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/ProfilerTooltipView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

