/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.BottomUpNode;
import com.android.tools.profilers.cpu.BottomUpTreeModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.TopDownNode;
import com.android.tools.profilers.cpu.TopDownTreeModel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CaptureModel {
    private static final double EPSILON = 1.0E-5;
    public static final int NO_THREAD = -1;
    @NotNull
    private final CpuProfilerStage myStage;
    @Nullable
    private CpuCapture myCapture;
    private int myThread;
    @NotNull
    private ClockType myClockType;
    @Nullable
    private Pattern myFilter;
    @Nullable
    private Details myDetails;
    private int myTotalNodeCount;
    private int myFilterNodeCount;
    private final Range myCaptureConvertedRange;

    CaptureModel(@NotNull CpuProfilerStage stage) {
        if (stage == null) {
            CaptureModel.$$$reportNull$$$0(0);
        }
        this.myClockType = ClockType.GLOBAL;
        this.myStage = stage;
        this.myCaptureConvertedRange = new Range();
        this.myThread = -1;
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        selection.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateCaptureConvertedRange);
        this.myCaptureConvertedRange.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateSelectionRange);
    }

    void setCapture(@Nullable CpuCapture capture) {
        if (this.myCapture == capture) {
            return;
        }
        this.myCapture = capture;
        if (this.myCapture != null) {
            this.setThread(this.myThread != -1 ? this.myThread : capture.getMainThreadId());
            this.myCapture.updateClockType(this.myClockType);
        } else {
            this.setThread(-1);
        }
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_SELECTION);
    }

    @Nullable
    CpuCapture getCapture() {
        return this.myCapture;
    }

    void setThread(int thread) {
        if (this.myThread == thread) {
            return;
        }
        this.myThread = thread;
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
    }

    int getThread() {
        return this.myThread;
    }

    void setClockType(@NotNull ClockType type) {
        if (type == null) {
            CaptureModel.$$$reportNull$$$0(1);
        }
        if (this.myClockType == type) {
            return;
        }
        this.myClockType = type;
        if (this.myCapture != null) {
            this.myCapture.updateClockType(this.myClockType);
        }
        this.rebuildDetails();
        this.updateCaptureConvertedRange();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CLOCK_TYPE);
    }

    @NotNull
    ClockType getClockType() {
        ClockType clockType = this.myClockType;
        if (clockType == null) {
            CaptureModel.$$$reportNull$$$0(2);
        }
        return clockType;
    }

    void setFilter(@Nullable Pattern filter) {
        if (Objects.equals(filter, this.myFilter)) {
            return;
        }
        this.myFilter = filter;
        this.rebuildDetails();
    }

    void setDetails(@Nullable Details.Type type) {
        if (type != null && this.myDetails != null && type == this.myDetails.getType()) {
            return;
        }
        this.buildDetails(type);
    }

    @Nullable
    Details getDetails() {
        return this.myDetails;
    }

    private void rebuildDetails() {
        if (this.myCapture == null) {
            this.buildDetails(null);
        } else {
            this.buildDetails(this.myDetails == null ? Details.Type.CALL_CHART : this.myDetails.getType());
        }
    }

    private void buildDetails(@Nullable Details.Type type) {
        this.updateCaptureConvertedRange();
        this.myTotalNodeCount = 0;
        this.myFilterNodeCount = 0;
        if (type != null) {
            CaptureNode node = this.getNode();
            if (node != null) {
                this.applyFilter(node, false);
            }
            this.myDetails = type.build(this.myCaptureConvertedRange, node);
        } else {
            this.myDetails = null;
        }
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_DETAILS);
    }

    @Nullable
    private CaptureNode getNode() {
        return this.myCapture != null ? this.myCapture.getCaptureNode(this.myThread) : null;
    }

    public int getNodeCount() {
        return this.myTotalNodeCount;
    }

    public int getFilterNodeCount() {
        return this.myFilterNodeCount;
    }

    private void applyFilter(@NotNull CaptureNode node, boolean matches) {
        if (node == null) {
            CaptureModel.$$$reportNull$$$0(3);
        }
        boolean nodeExactMatch = node.matchesToFilter(this.myFilter);
        matches = matches || nodeExactMatch;
        boolean allChildrenUnmatch = true;
        ++this.myTotalNodeCount;
        if (nodeExactMatch) {
            ++this.myFilterNodeCount;
        }
        for (CaptureNode child : node.getChildren()) {
            this.applyFilter(child, matches);
            if (child.isUnmatched()) continue;
            allChildrenUnmatch = false;
        }
        if (!matches && allChildrenUnmatch) {
            node.setFilterType(CaptureNode.FilterType.UNMATCH);
        } else if (nodeExactMatch && this.myFilter != null) {
            node.setFilterType(CaptureNode.FilterType.EXACT_MATCH);
        } else {
            node.setFilterType(CaptureNode.FilterType.MATCH);
        }
    }

    private void updateCaptureConvertedRange() {
        CaptureNode node;
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setConvertedRange(selection.getMin(), selection.getMax());
            return;
        }
        double convertedMin = (double)node.getStartThread() + node.threadGlobalRatio() * (selection.getMin() - (double)node.getStartGlobal());
        double convertedMax = convertedMin + node.threadGlobalRatio() * selection.getLength();
        this.setConvertedRange(convertedMin, convertedMax);
    }

    private void updateSelectionRange() {
        CaptureNode node;
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setSelectionRange(this.myCaptureConvertedRange.getMin(), this.myCaptureConvertedRange.getMax());
            return;
        }
        double threadToGlobal = 1.0 / node.threadGlobalRatio();
        double convertedMin = (double)node.getStartGlobal() + threadToGlobal * (this.myCaptureConvertedRange.getMin() - (double)node.getStartThread());
        double convertedMax = convertedMin + threadToGlobal * this.myCaptureConvertedRange.getLength();
        this.setSelectionRange(convertedMin, convertedMax);
    }

    private void setSelectionRange(double min, double max) {
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        if (Math.abs(selection.getMin() - min) > 1.0E-5 || Math.abs(selection.getMax() - max) > 1.0E-5) {
            selection.set(min, max);
        }
    }

    private void setConvertedRange(double min, double max) {
        if (Math.abs(this.myCaptureConvertedRange.getMin() - min) > 1.0E-5 || Math.abs(this.myCaptureConvertedRange.getMax() - max) > 1.0E-5) {
            this.myCaptureConvertedRange.set(min, max);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CaptureModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CaptureModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FlameChart
    implements Details {
        @NotNull
        private final Range myFlameRange;
        @Nullable
        private CaptureNode myFlameNode;
        @Nullable
        private final TopDownNode myTopDownNode;
        @NotNull
        private final Range mySelectionRange;
        @NotNull
        private final AspectModel<Aspect> myAspectModel;

        public FlameChart(@NotNull Range selectionRange, @Nullable CaptureNode captureNode) {
            if (selectionRange == null) {
                FlameChart.$$$reportNull$$$0(0);
            }
            this.mySelectionRange = selectionRange;
            this.myFlameRange = new Range();
            this.myAspectModel = new AspectModel();
            if (captureNode == null) {
                this.myFlameNode = null;
                this.myTopDownNode = null;
                return;
            }
            this.myTopDownNode = new TopDownNode(captureNode);
            selectionRange.addDependency(this.myAspectModel).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeChanged);
            this.selectionRangeChanged();
        }

        private void selectionRangeChanged() {
            this.myTopDownNode.update(this.mySelectionRange);
            if (this.myTopDownNode.getTotal() > 0.0) {
                double start = Math.max((double)this.myTopDownNode.getNodes().get(0).getStart(), this.mySelectionRange.getMin());
                this.myFlameNode = this.convertToFlameChart(this.myTopDownNode, start, 0);
            } else {
                this.myFlameNode = null;
            }
            this.myFlameRange.set(this.mySelectionRange);
            this.myAspectModel.changed((Enum)Aspect.NODE);
        }

        @NotNull
        public Range getRange() {
            Range range = this.myFlameRange;
            if (range == null) {
                FlameChart.$$$reportNull$$$0(1);
            }
            return range;
        }

        @Nullable
        public CaptureNode getNode() {
            return this.myFlameNode;
        }

        @NotNull
        public AspectModel<Aspect> getAspect() {
            AspectModel<Aspect> aspectModel = this.myAspectModel;
            if (aspectModel == null) {
                FlameChart.$$$reportNull$$$0(2);
            }
            return aspectModel;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.FLAME_CHART;
        }

        /*
         * WARNING - void declaration
         */
        private CaptureNode convertToFlameChart(@NotNull TopDownNode topDown, double start, int n) {
            void depth;
            if (topDown == null) {
                FlameChart.$$$reportNull$$$0(3);
            }
            assert (topDown.getTotal() > 0.0);
            CaptureNode node = new CaptureNode(topDown.getNodes().get(0).getData());
            node.setFilterType(topDown.getNodes().get(0).getFilterType());
            node.setStartGlobal((long)start);
            node.setStartThread((long)start);
            node.setEndGlobal((long)(start + topDown.getTotal()));
            node.setEndThread((long)(start + topDown.getTotal()));
            node.setDepth((int)depth);
            for (TopDownNode child : topDown.getChildren()) {
                child.update(this.mySelectionRange);
            }
            ArrayList sortedChildren = new ArrayList(topDown.getChildren());
            sortedChildren.sort((o1, o2) -> {
                int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
                return cmp == 0 ? Double.compare(o2.getTotal(), o1.getTotal()) : cmp;
            });
            for (TopDownNode child : sortedChildren) {
                if (child.getTotal() == 0.0) continue;
                node.addChild(this.convertToFlameChart(child, start, (int)(depth + true)));
                start += child.getTotal();
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionRange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CaptureModel$FlameChart";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topDown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CaptureModel$FlameChart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAspect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToFlameChart";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Aspect {
            NODE;

        }
    }

    public static class CallChart
    implements Details {
        @NotNull
        private final Range myRange;
        @Nullable
        private CaptureNode myNode;

        public CallChart(@NotNull Range range, @Nullable CaptureNode node) {
            if (range == null) {
                CallChart.$$$reportNull$$$0(0);
            }
            this.myRange = range;
            this.myNode = node;
        }

        @NotNull
        public Range getRange() {
            Range range = this.myRange;
            if (range == null) {
                CallChart.$$$reportNull$$$0(1);
            }
            return range;
        }

        @Nullable
        public CaptureNode getNode() {
            return this.myNode;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.CALL_CHART;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CaptureModel$CallChart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CaptureModel$CallChart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BottomUp
    implements Details {
        @Nullable
        private BottomUpTreeModel myModel;

        public BottomUp(@NotNull Range range, @Nullable CaptureNode node) {
            if (range == null) {
                BottomUp.$$$reportNull$$$0(0);
            }
            this.myModel = node == null ? null : new BottomUpTreeModel(range, new BottomUpNode(node));
        }

        @Nullable
        public BottomUpTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.BOTTOM_UP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/profilers/cpu/CaptureModel$BottomUp", "<init>"));
        }
    }

    public static class TopDown
    implements Details {
        @Nullable
        private TopDownTreeModel myModel;

        public TopDown(@NotNull Range range, @Nullable CaptureNode node) {
            if (range == null) {
                TopDown.$$$reportNull$$$0(0);
            }
            this.myModel = node == null ? null : new TopDownTreeModel(range, new TopDownNode(node));
        }

        @Nullable
        public TopDownTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.TOP_DOWN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/profilers/cpu/CaptureModel$TopDown", "<init>"));
        }
    }

    public static interface Details {
        public Type getType();

        public static enum Type {
            TOP_DOWN(TopDown::new),
            BOTTOM_UP(BottomUp::new),
            CALL_CHART(CallChart::new),
            FLAME_CHART(FlameChart::new);

            @NotNull
            private final BiFunction<Range, CaptureNode, Details> myBuilder;

            private Type(BiFunction<Range, CaptureNode, Details> builder) {
                if (builder == null) {
                    Type.$$$reportNull$$$0(0);
                }
                this.myBuilder = builder;
            }

            public Details build(Range range, CaptureNode node) {
                return this.myBuilder.apply(range, node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/profilers/cpu/CaptureModel$Details$Type", "<init>"));
            }
        }
    }
}

