/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ThreadStateDataSeries;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuThreadsModel
extends DefaultListModel<RangedCpuThread>
implements Updatable {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;

    public CpuThreadsModel(@NotNull Range range, @NotNull CpuProfilerStage stage, @NotNull Common.Session session) {
        if (range == null) {
            CpuThreadsModel.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuThreadsModel.$$$reportNull$$$0(1);
        }
        if (session == null) {
            CpuThreadsModel.$$$reportNull$$$0(2);
        }
        this.myRange = range;
        this.myStage = stage;
        this.mySession = session;
        this.myAspectObserver = new AspectObserver();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.rangeChanged();
    }

    public void rangeChanged() {
        CpuProfiler.GetThreadsRequest.Builder request = CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMax()));
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myStage.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.GetThreadsResponse response = client.getThreads(request.build());
        int i = 0;
        int j = 0;
        while (i < this.getSize() && j < response.getThreadsCount()) {
            RangedCpuThread oldThread = (RangedCpuThread)this.getElementAt(i);
            CpuProfiler.GetThreadsResponse.Thread newThread = response.getThreads(j);
            if (oldThread.getThreadId() == newThread.getTid()) {
                ++i;
                ++j;
                continue;
            }
            this.removeElementAt(i);
        }
        while (i < this.getSize()) {
            this.removeElementAt(i);
            ++i;
        }
        while (j < response.getThreadsCount()) {
            CpuProfiler.GetThreadsResponse.Thread newThread = response.getThreads(j);
            this.addElement(new RangedCpuThread(this.myRange, newThread.getTid(), newThread.getName()));
            ++j;
        }
    }

    public void update(long elapsedNs) {
        this.fireContentsChanged(this, 0, this.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/cpu/CpuThreadsModel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class RangedCpuThread {
        private final int myThreadId;
        private final String myName;
        private final Range myRange;
        private final ThreadStateDataSeries mySeries;
        private final StateChartModel<CpuProfilerStage.ThreadState> myModel;

        public RangedCpuThread(Range range, int threadId, String name) {
            this.myRange = range;
            this.myThreadId = threadId;
            this.myName = name;
            this.myModel = new StateChartModel();
            this.mySeries = new ThreadStateDataSeries(CpuThreadsModel.this.myStage, CpuThreadsModel.this.mySession, this.myThreadId);
            this.myModel.addSeries(new RangedSeries(this.myRange, (DataSeries)this.mySeries));
        }

        public int getThreadId() {
            return this.myThreadId;
        }

        public String getName() {
            return this.myName;
        }

        public StateChartModel<CpuProfilerStage.ThreadState> getModel() {
            return this.myModel;
        }

        public ThreadStateDataSeries getStateSeries() {
            return this.mySeries;
        }
    }
}

