/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class JavaMethodHChartColors {
    JavaMethodHChartColors() {
    }

    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (model == null) {
            JavaMethodHChartColors.$$$reportNull$$$0(0);
        }
        if (!(model instanceof JavaMethodModel)) {
            throw new IllegalStateException("Model must be an instance of JavaMethodModel.");
        }
    }

    private static boolean isMethodVendor(CaptureNodeModel method) {
        return method.getFullName().startsWith("java.") || method.getFullName().startsWith("sun.") || method.getFullName().startsWith("javax.") || method.getFullName().startsWith("apple.") || method.getFullName().startsWith("com.apple.");
    }

    private static boolean isMethodPlatform(CaptureNodeModel method) {
        return method.getFullName().startsWith("android.") || method.getFullName().startsWith("com.android.");
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureModel.Details.Type chartType, boolean isUnmatched) {
        if (model == null) {
            JavaMethodHChartColors.$$$reportNull$$$0(1);
        }
        JavaMethodHChartColors.validateModel(model);
        Color color = chartType == CaptureModel.Details.Type.CALL_CHART ? (JavaMethodHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_CALLCHART_VENDOR : (JavaMethodHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_CALLCHART_PLATFORM : ProfilerColors.CPU_CALLCHART_APP)) : (JavaMethodHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_FLAMECHART_VENDOR : (JavaMethodHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_FLAMECHART_PLATFORM : ProfilerColors.CPU_FLAMECHART_APP));
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getBorderColor(@NotNull CaptureNodeModel model, CaptureModel.Details.Type chartType, boolean isUnmatched) {
        if (model == null) {
            JavaMethodHChartColors.$$$reportNull$$$0(2);
        }
        JavaMethodHChartColors.validateModel(model);
        Color color = chartType == CaptureModel.Details.Type.CALL_CHART ? (JavaMethodHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_CALLCHART_VENDOR_BORDER : (JavaMethodHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_CALLCHART_PLATFORM_BORDER : ProfilerColors.CPU_CALLCHART_APP_BORDER)) : (JavaMethodHChartColors.isMethodVendor(model) ? ProfilerColors.CPU_FLAMECHART_VENDOR_BORDER : (JavaMethodHChartColors.isMethodPlatform(model) ? ProfilerColors.CPU_FLAMECHART_PLATFORM_BORDER : ProfilerColors.CPU_FLAMECHART_APP_BORDER));
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/android/tools/profilers/cpu/JavaMethodHChartColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFillColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBorderColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

