/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.art;

import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.TraceAction;
import com.android.tools.perflib.vmtrace.VmTraceHandler;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.art.CaptureNodeConstructor;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtTraceHandler
implements VmTraceHandler {
    private static final String KEY_ELAPSED_TIME_US = "elapsed-time-usec";
    private long myStartTimeUs;
    private long myElapsedTimeUs;
    private final Map<Integer, String> myThreads = new HashMap<Integer, String>();
    private final Map<Long, CaptureNodeModel> myMethods = new HashMap<Long, CaptureNodeModel>();
    private final Map<Integer, CaptureNodeConstructor> myNodeConstructors = new HashMap<Integer, CaptureNodeConstructor>();
    @Nullable
    private Map<CpuThreadInfo, CaptureNode> myThreadsGraph;

    public void addThread(int id, String name) {
        this.myThreads.put(id, name);
    }

    public void addMethod(long id, MethodInfo info) {
        this.myMethods.put(id, new JavaMethodModel(info.methodName, info.className, info.signature));
    }

    public void addMethodAction(int threadId, long methodId, TraceAction methodAction, int threadTime, int globalTime) {
        CaptureNodeConstructor constructor;
        if (!this.myThreads.containsKey(threadId)) {
            this.myThreads.put(threadId, String.format("Thread id: %1$d", threadId));
        }
        if (!this.myMethods.containsKey(methodId)) {
            this.myMethods.put(methodId, new SingleNameModel("unknown"));
        }
        if ((constructor = this.myNodeConstructors.get(threadId)) == null) {
            CaptureNodeModel topLevelModel = this.createUniqueMethodForThread(threadId);
            constructor = new CaptureNodeConstructor(topLevelModel);
            this.myNodeConstructors.put(threadId, constructor);
        }
        constructor.addTraceAction(this.myMethods.get(methodId), methodAction, threadTime, globalTime);
    }

    private CaptureNodeModel createUniqueMethodForThread(int threadId) {
        long id = Long.MAX_VALUE - (long)threadId;
        assert (this.myMethods.get(id) == null) : "Unexpected error while attempting to create a unique key - key already exists";
        SingleNameModel model = new SingleNameModel(this.myThreads.get(threadId));
        this.myMethods.put(id, model);
        return model;
    }

    public Map<CpuThreadInfo, CaptureNode> getThreadsGraph() {
        if (this.myThreadsGraph == null) {
            this.myThreadsGraph = this.createThreadsGraph();
        }
        return this.myThreadsGraph;
    }

    @NotNull
    private Map<CpuThreadInfo, CaptureNode> createThreadsGraph() {
        HashMap<CpuThreadInfo, CaptureNode> threadsGraph = new HashMap<CpuThreadInfo, CaptureNode>(this.myThreads.size());
        for (Map.Entry<Integer, String> entry : this.myThreads.entrySet()) {
            int id = entry.getKey();
            String name = entry.getValue();
            CaptureNodeConstructor constructor = this.myNodeConstructors.get(id);
            if (constructor == null) continue;
            CaptureNode topLevelCall = constructor.getTopLevel();
            assert (topLevelCall != null);
            CpuThreadInfo info = new CpuThreadInfo(id, name);
            long topLevelGlobalStart = topLevelCall.getStartGlobal() + this.myStartTimeUs;
            this.adjustNodesTimeAndDepth(topLevelCall, topLevelGlobalStart, 0);
            threadsGraph.put(info, topLevelCall);
        }
        HashMap<CpuThreadInfo, CaptureNode> hashMap = threadsGraph;
        if (hashMap == null) {
            ArtTraceHandler.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    private void adjustNodesTimeAndDepth(CaptureNode node, long topLevelStart, int depth) {
        node.setStartGlobal(this.myStartTimeUs + node.getStartGlobal());
        node.setEndGlobal(this.myStartTimeUs + node.getEndGlobal());
        node.setDepth(depth);
        node.setStartThread(topLevelStart + node.getStartThread());
        node.setEndThread(topLevelStart + node.getEndThread());
        for (CaptureNode callee : node.getChildren()) {
            this.adjustNodesTimeAndDepth(callee, topLevelStart, depth + 1);
        }
    }

    public long getElapsedTimeUs() {
        return this.myElapsedTimeUs;
    }

    public long getStartTimeUs() {
        return this.myStartTimeUs;
    }

    public void setStartTimeUs(long startTimeUs) {
        this.myStartTimeUs = startTimeUs;
    }

    public void setProperty(String key, String value) {
        if (key.equals(KEY_ELAPSED_TIME_US)) {
            this.myElapsedTimeUs = Long.parseLong(value);
        }
    }

    public void setVersion(int version) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/cpu/art/ArtTraceHandler", "createThreadsGraph"));
    }
}

