/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.atrace.AtraceDecompressor;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import trebuchet.importers.ImportFeedback;
import trebuchet.io.BufferProducer;
import trebuchet.model.Model;
import trebuchet.model.ProcessModel;
import trebuchet.model.ThreadModel;
import trebuchet.model.base.SliceGroup;
import trebuchet.task.ImportTask;
import trebuchet.util.PrintlnImportFeedback;

public class AtraceParser
implements TraceParser {
    private Model myModel;
    private HashMap<CpuThreadInfo, CaptureNode> myCaptureTreeNodes = new HashMap();
    private int myProcessId;

    public AtraceParser(int processId) {
        this.myProcessId = processId;
    }

    @Override
    public void parse(File file) throws IOException {
        AtraceDecompressor reader = new AtraceDecompressor(file);
        ImportTask task = new ImportTask((ImportFeedback)new PrintlnImportFeedback());
        this.myModel = task.importBuffer((BufferProducer)reader);
        this.myCaptureTreeNodes = this.buildCaptureTreeNodes();
    }

    private double secondsToUs(double time) {
        return time * 1000000.0;
    }

    @Override
    public Map<CpuThreadInfo, CaptureNode> getCaptureTrees() {
        return this.myCaptureTreeNodes;
    }

    private HashMap<CpuThreadInfo, CaptureNode> buildCaptureTreeNodes() {
        ProcessModel selectedProcess = null;
        for (ProcessModel process : this.myModel.getProcesses()) {
            if (process.getId() != this.myProcessId) continue;
            selectedProcess = process;
            break;
        }
        HashMap<CpuThreadInfo, CaptureNode> captureTreeNodes = new HashMap<CpuThreadInfo, CaptureNode>();
        if (selectedProcess != null) {
            Range range = this.getRange();
            for (ThreadModel thread : selectedProcess.getThreads()) {
                if (!thread.getHasContent()) continue;
                CpuThreadInfo threadInfo = new CpuThreadInfo(thread.getId(), thread.getName());
                CaptureNode root = new CaptureNode(new SingleNameModel("root"));
                root.setStartGlobal((long)range.getMin());
                root.setEndGlobal((long)range.getMax());
                captureTreeNodes.put(threadInfo, root);
                for (SliceGroup slice : thread.getSlices()) {
                    CaptureNode node = this.populateCaptureNode(slice, 0);
                    root.addChild(node);
                }
            }
        }
        return captureTreeNodes;
    }

    private CaptureNode populateCaptureNode(SliceGroup slice, int depth) {
        CaptureNode node = new CaptureNode(new SingleNameModel(slice.getName()));
        node.setStartGlobal(this.convertToUserTimeUs(slice.getStartTime()));
        node.setEndGlobal(this.convertToUserTimeUs(slice.getEndTime()));
        node.setDepth(depth);
        for (SliceGroup child : slice.getChildren()) {
            node.addChild(this.populateCaptureNode(child, depth + 1));
        }
        return node;
    }

    @Override
    public Range getRange() {
        double startTimestampUs = this.convertToUserTimeUs(this.myModel.getBeginTimestamp());
        double endTimestampUs = this.convertToUserTimeUs(this.myModel.getEndTimestamp());
        return new Range(startTimestampUs, endTimestampUs);
    }

    private long convertToUserTimeUs(double offsetTime) {
        return (long)this.secondsToUs(offsetTime - this.myModel.getBeginTimestamp() + this.myModel.getParentTimestamp());
    }
}

