/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyMonitorTooltip;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyUsage;
import org.jetbrains.annotations.NotNull;

public class EnergyMonitor
extends ProfilerMonitor {
    static final BaseAxisFormatter ENERGY_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 2, 10, "mAh");
    @NotNull
    private final EnergyUsage myUsage;
    @NotNull
    private final AxisComponentModel myAxis;
    @NotNull
    private final Legends myLegends;
    @NotNull
    private final Legends myTooltipLegends;

    public EnergyMonitor(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            EnergyMonitor.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myUsage = new EnergyUsage(profilers);
        this.myAxis = new AxisComponentModel(this.myUsage.getUsageRange(), ENERGY_AXIS_FORMATTER);
        this.myAxis.setClampToMajorTicks(true);
        this.myLegends = new Legends(this.myUsage, this.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new Legends(this.myUsage, this.getTimeline().getTooltipRange(), true);
    }

    @Override
    public String getName() {
        return "ENERGY";
    }

    @Override
    public ProfilerTooltip buildTooltip() {
        return new EnergyMonitorTooltip(this);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new EnergyProfilerStage(this.getProfilers()));
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myAxis);
        this.myProfilers.getUpdater().register((Updatable)this.myLegends);
        this.myProfilers.getUpdater().register((Updatable)this.myTooltipLegends);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myAxis);
        this.myProfilers.getUpdater().unregister((Updatable)this.myLegends);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTooltipLegends);
    }

    @NotNull
    public EnergyUsage getUsage() {
        EnergyUsage energyUsage = this.myUsage;
        if (energyUsage == null) {
            EnergyMonitor.$$$reportNull$$$0(1);
        }
        return energyUsage;
    }

    @NotNull
    public AxisComponentModel getAxis() {
        AxisComponentModel axisComponentModel = this.myAxis;
        if (axisComponentModel == null) {
            EnergyMonitor.$$$reportNull$$$0(2);
        }
        return axisComponentModel;
    }

    @NotNull
    public Legends getLegends() {
        Legends legends = this.myLegends;
        if (legends == null) {
            EnergyMonitor.$$$reportNull$$$0(3);
        }
        return legends;
    }

    @NotNull
    public Legends getTooltipLegends() {
        Legends legends = this.myTooltipLegends;
        if (legends == null) {
            EnergyMonitor.$$$reportNull$$$0(4);
        }
        return legends;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAxis";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegends";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipLegends";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Legends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myUsageLegend;

        public Legends(@NotNull EnergyUsage usage, @NotNull Range range, boolean highlight) {
            if (usage == null) {
                Legends.$$$reportNull$$$0(0);
            }
            if (range == null) {
                Legends.$$$reportNull$$$0(1);
            }
            super(highlight ? 0 : 100);
            this.myUsageLegend = new SeriesLegend(usage.getUsageDataSeries(), ENERGY_AXIS_FORMATTER, range);
            this.add((Legend)this.myUsageLegend);
        }

        @NotNull
        public SeriesLegend getUsageLegend() {
            SeriesLegend seriesLegend = this.myUsageLegend;
            if (seriesLegend == null) {
                Legends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/energy/EnergyMonitor$Legends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/energy/EnergyMonitor$Legends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsageLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

