/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValueFloat;

public class CssNumber
extends CssCheckableValue
implements CssValueFloat {
    public static final int type = 5;
    ApplContext ac;
    BigDecimal value;
    boolean isInt = false;

    @Override
    public final int getType() {
        return 5;
    }

    public CssNumber() {
    }

    public CssNumber(ApplContext ac, float value) {
        this.ac = ac;
        this.value = new BigDecimal(value);
    }

    public CssNumber(float value) {
        this.value = new BigDecimal(value);
    }

    @Override
    public void set(String s, ApplContext ac) {
        this.value = new BigDecimal(s);
        this.isInt = s.indexOf(46) < 0;
        this.ac = ac;
    }

    @Override
    public void setValue(BigDecimal v) {
        this.value = v;
        try {
            v.toBigIntegerExact();
            this.isInt = true;
        }
        catch (ArithmeticException e) {
            this.isInt = false;
        }
    }

    public void setIntValue(int v) {
        this.isInt = true;
        this.value = new BigDecimal(v);
    }

    public void setFloatValue(float v) {
        this.isInt = false;
        this.value = new BigDecimal(v);
    }

    @Override
    public Object get() {
        return this.value;
    }

    @Override
    public float getValue() {
        return this.value.floatValue();
    }

    public int getInt() throws InvalidParamException {
        if (this.isInt) {
            try {
                return this.value.intValueExact();
            }
            catch (ArithmeticException aex) {
                throw new InvalidParamException("out-of-range", this.ac);
            }
        }
        throw new InvalidParamException("invalid-color", this.ac);
    }

    @Override
    public boolean isInteger() {
        return this.isInt;
    }

    @Override
    public boolean isPositive() {
        return this.value.signum() >= 0;
    }

    @Override
    public boolean isStrictlyPositive() {
        return this.value.signum() == 1;
    }

    @Override
    public boolean isZero() {
        return BigDecimal.ZERO.compareTo(this.value) == 0;
    }

    @Override
    public CssLength getLength() throws InvalidParamException {
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            return new CssLength();
        }
        throw new InvalidParamException("zero", "length", this.ac);
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            return new CssPercentage();
        }
        throw new InvalidParamException("zero", this.value.toString(), "percentage", this.ac);
    }

    @Override
    public CssTime getTime() throws InvalidParamException {
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            return new CssTime();
        }
        throw new InvalidParamException("zero", this.value.toString(), "time", this.ac);
    }

    @Override
    public CssAngle getAngle() throws InvalidParamException {
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            return new CssAngle();
        }
        throw new InvalidParamException("zero", this.value.toString(), "angle", this.ac);
    }

    @Override
    public CssFrequency getFrequency() throws InvalidParamException {
        if (this.value.compareTo(BigDecimal.ZERO) == 0) {
            return new CssFrequency();
        }
        throw new InvalidParamException("zero", this.value.toString(), "frequency", this.ac);
    }

    @Override
    public CssNumber getNumber() throws InvalidParamException {
        return this;
    }

    public String toString() {
        return this.value.toPlainString();
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssNumber && this.value.equals(((CssNumber)value).value);
    }

    @Override
    public void checkPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isPositive()) {
            throw new InvalidParamException("negative-value", this.toString(), property.getPropertyName(), ac);
        }
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isStrictlyPositive()) {
            throw new InvalidParamException("strictly-positive", this.toString(), property.getPropertyName(), ac);
        }
    }

    @Override
    public void checkInteger(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isInteger()) {
            throw new InvalidParamException("integer", this.toString(), property.getPropertyName(), ac);
        }
    }

    @Override
    public void warnPositiveness(ApplContext ac, CssProperty property) {
        if (!this.isPositive()) {
            ac.getFrame().addWarning("negative", this.toString());
        }
    }

    public void checkLowerEqualThan(ApplContext ac, double d, CssProperty property) throws InvalidParamException {
        BigDecimal other = BigDecimal.valueOf(d);
        if (this.value.compareTo(other) > 0) {
            throw new InvalidParamException("lowerequal", this.toString(), other.toPlainString(), ac);
        }
    }

    public void warnLowerEqualThan(ApplContext ac, double d, CssProperty property) {
        BigDecimal other = BigDecimal.valueOf(d);
        if (this.value.compareTo(other) > 0) {
            String[] s = new String[]{this.toString(), other.toPlainString()};
            ac.getFrame().addWarning("lowerequal", s);
        }
    }

    public void checkGreaterEqualThan(ApplContext ac, double d, CssProperty property) throws InvalidParamException {
        BigDecimal other = BigDecimal.valueOf(d);
        if (this.value.compareTo(other) < 0) {
            throw new InvalidParamException("greaterequal", this.toString(), other.toPlainString(), ac);
        }
    }

    public void warnGreaterEqualThan(ApplContext ac, double d, CssProperty property) {
        BigDecimal other = BigDecimal.valueOf(d);
        if (this.value.compareTo(other) < 0) {
            String[] s = new String[]{this.toString(), other.toPlainString()};
            ac.getFrame().addWarning("greaterequal", s);
        }
    }

    @Override
    public void checkEqualsZero(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isZero()) {
            throw new InvalidParamException("zero", "unit", this.toString(), ac);
        }
    }

    @Override
    public void warnEqualsZero(ApplContext ac, CssProperty property) {
        if (!this.isZero()) {
            ac.getFrame().addWarning("zero", "unit");
        }
    }
}

