/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.xml.ejb.CmrField;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.javaee.model.xml.ejb.Query;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.psi.QlAggregateExpression;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlRecursiveVisitor;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlSelectClause;
import com.intellij.jpa.ql.types.QlClassType;
import com.intellij.jpa.ql.types.QlCollectionType;
import com.intellij.jpa.ql.types.QlType;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.EjbQlModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateEJBFinderOrSelectorMethodHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateEJBFinderOrSelectorMethodHandler");
    @NonNls
    private static final String TYPE_VAR_PREFIX = "type";
    @NonNls
    private static final String NAME_VAR_PREFIX = "name";
    @NonNls
    private static final String FINDER_NAME_VAR = "finderName";
    @NonNls
    private static final String RETURN_TYPE_VAR = "returnType";

    public void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        QlExpression selectExpression;
        if (project == null) {
            GenerateEJBFinderOrSelectorMethodHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateEJBFinderOrSelectorMethodHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GenerateEJBFinderOrSelectorMethodHandler.$$$reportNull$$$0(2);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        boolean generateSelector = false;
        boolean remoteFinder = false;
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS && role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE && role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE || !EjbUtil.isCMP(role.getEnterpriseBean(), CmpVersion.CmpVersion_2_X)) continue;
            generateSelector = role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS;
            remoteFinder = role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE;
            break;
        }
        Pair<EditorTextField, QlFile> pair = JpaUtil.createQlEditor(project, "SELECT ", true, JpqlLanguage.EJBQL, new EjbQlModel(EjbUtil.getEjbFacet((PsiElement)psiClass).getMergedRoot(), -1), null);
        DialogBuilder builder = new DialogBuilder(project);
        builder.setDimensionServiceKey("TextControl");
        builder.setCenterPanel(((EditorTextField)pair.getFirst()).getComponent());
        builder.setPreferredFocusComponent(((EditorTextField)pair.getFirst()).getComponent());
        builder.setTitle(J2EEBundle.message((String)"dialog.title.edit.ejb.ql.query", (Object[])new Object[0]));
        builder.addOkAction();
        builder.addCancelAction();
        int result = builder.show();
        if (result != 0) {
            return;
        }
        final TreeMap parameters = new TreeMap();
        final QlFile qlFile = (QlFile)pair.getSecond();
        QlQueryExpression query = qlFile.getQuery();
        if (query != null) {
            QlSelectClause qlSelectClause = query.getSelectClause();
            selectExpression = qlSelectClause != null ? (QlExpression)ContainerUtil.getFirstItem(qlSelectClause.getExpressionList()) : null;
            query.accept(new QlRecursiveVisitor(){

                @Override
                public void visitInputParameter(@NotNull QlInputParameter o) {
                    QlIdentifier identifier;
                    int index;
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int n = index = (identifier = o.getIdentifier()) != null ? StringUtil.parseInt((String)identifier.getText(), (int)-1) : -1;
                    if (index > -1) {
                        parameters.put(index, o);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/codeInsight/generation/GenerateEJBFinderOrSelectorMethodHandler$1", "visitInputParameter"));
                }
            });
        } else {
            selectExpression = null;
        }
        int maxParameterIndex = 0;
        for (Integer integer : parameters.keySet()) {
            if (maxParameterIndex >= integer) continue;
            maxParameterIndex = integer;
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        if (generateSelector) {
            template.addTextSegment("public abstract ");
        }
        TypeExpression returnTypeExpression = new TypeExpression(project, this.getExpressionTypeVariants(psiClass, selectExpression, remoteFinder));
        template.addVariable(RETURN_TYPE_VAR, (Expression)returnTypeExpression, (Expression)returnTypeExpression, true);
        template.addTextSegment(" " + (generateSelector ? "ejbSelect" : "find"));
        final boolean generateSelector1 = generateSelector;
        EmptyExpression finderNameExpression = new EmptyExpression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult(generateSelector1 ? "Smth" : "By");
            }
        };
        template.addVariable(FINDER_NAME_VAR, (Expression)finderNameExpression, (Expression)finderNameExpression, true);
        template.addTextSegment("(");
        int parameterCount = 1;
        while (parameterCount <= maxParameterIndex) {
            QlInputParameter QlInputParameter2 = (QlInputParameter)parameters.get(parameterCount);
            if (parameterCount > 1) {
                template.addTextSegment(", ");
            }
            final int curIndex = parameterCount++;
            TypeExpression parameterTypeExpression = new TypeExpression(project, this.getParameterTypeVariants(psiClass, QlInputParameter2));
            EmptyExpression parameterNameExpression = new EmptyExpression(){

                public Result calculateResult(ExpressionContext context) {
                    return new TextResult("p" + curIndex);
                }

                public LookupElement[] calculateLookupItems(ExpressionContext context) {
                    TextRange textRange = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableRange(GenerateEJBFinderOrSelectorMethodHandler.TYPE_VAR_PREFIX + curIndex);
                    PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
                    if (psiElement == null || !(psiElement.getParent() instanceof PsiJavaCodeReferenceElement)) {
                        return null;
                    }
                    PsiClassType classType = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createType((PsiJavaCodeReferenceElement)psiElement.getParent());
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiElement.getProject());
                    SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, (PsiType)classType);
                    SuggestedNameInfo suggestedNameInfo2 = codeStyleManager.suggestUniqueVariableName(suggestedNameInfo, psiElement, true);
                    LookupElement[] items = new LookupElement[suggestedNameInfo2.names.length + 1];
                    int i = 0;
                    String defaultName = this.calculateResult(context).toString();
                    items[i++] = LookupElementBuilder.create((String)defaultName);
                    for (String name : suggestedNameInfo2.names) {
                        items[i++] = LookupElementBuilder.create((String)name);
                    }
                    return items;
                }
            };
            template.addVariable(TYPE_VAR_PREFIX + curIndex, (Expression)parameterTypeExpression, (Expression)parameterTypeExpression, true);
            template.addTextSegment(" ");
            template.addVariable(NAME_VAR_PREFIX + curIndex, (Expression)parameterNameExpression, (Expression)parameterNameExpression, true);
        }
        template.addTextSegment(") throws javax.ejb.FinderException" + (remoteFinder ? ", java.rmi.RemoteException" : "") + ";");
        editor.getCaretModel().moveToOffset(GenerateEJBFinderOrSelectorMethodHandler.getInsertOffset(editor, file));
        manager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void beforeTemplateFinished(@NotNull TemplateState state, Template template) {
                TextRange textRange;
                PsiMethod psiMethod;
                if (state == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt((textRange = state.getVariableRange(GenerateEJBFinderOrSelectorMethodHandler.FINDER_NAME_VAR)).getStartOffset()), PsiMethod.class)) != null) {
                    GenerateEJBFinderOrSelectorMethodHandler.generateQueryMetadata(psiMethod.getContainingClass(), qlFile.getText(), psiMethod);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/generation/GenerateEJBFinderOrSelectorMethodHandler$4", "beforeTemplateFinished"));
            }
        });
    }

    static int getInsertOffset(Editor editor, PsiFile psiFile) {
        PsiClass psiClass;
        int offset = editor.getCaretModel().getOffset();
        Object element = psiFile.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (!(element instanceof PsiMethod) && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null) {
            PsiMethod[] psiMethods = psiClass.getMethods();
            element = psiMethods.length > 0 ? psiMethods[0] : psiClass.getLBrace();
        }
        return element == null ? offset : element.getTextRange().getEndOffset();
    }

    private PsiType[] getParameterTypeVariants(PsiClass psiClass, QlInputParameter QlInputParameter2) {
        PsiElement parent;
        ArrayList<Object> result = new ArrayList<Object>();
        PsiElement psiElement = parent = QlInputParameter2 != null ? QlInputParameter2.getParent() : null;
        if (parent instanceof QlExpression) {
            QlType qlType;
            IElementType op = ((QlExpression)parent).getOperator();
            QlExpression operand = op != null ? (QlExpression)PsiTreeUtil.getChildOfType((PsiElement)parent, QlExpression.class) : null;
            QlType qlType2 = qlType = op != null ? ((QlExpression)parent).getType() : null;
            if (qlType != null) {
                result.addAll(this.getTypeVariants(psiClass, qlType, operand, false));
            }
        }
        if (result.size() == 0) {
            result.add(PsiType.getJavaLangObject((PsiManager)psiClass.getManager(), (GlobalSearchScope)psiClass.getResolveScope()));
        }
        return result.toArray(PsiType.EMPTY_ARRAY);
    }

    private List<PsiType> getTypeVariants(PsiClass psiClass, QlType qlType, QlExpression expression, boolean remoteOnly) {
        ArrayList<PsiType> result = new ArrayList<PsiType>();
        if (qlType == QlType.STRING) {
            result.add((PsiType)PsiType.getJavaLangString((PsiManager)psiClass.getManager(), (GlobalSearchScope)psiClass.getResolveScope()));
        } else if (qlType == QlType.NUMBER) {
            result.add((PsiType)PsiType.INT);
            result.add((PsiType)PsiType.LONG);
            result.add((PsiType)PsiType.DOUBLE);
        } else if (qlType == QlType.BOOLEAN) {
            result.add((PsiType)PsiType.BOOLEAN);
        } else if (qlType instanceof QlCollectionType || qlType instanceof QlClassType) {
            ContainerUtil.addAll(result, (Object[])this.getExpressionTypeVariants(psiClass, expression, remoteOnly));
        }
        return result;
    }

    private PsiType[] getExpressionTypeVariants(PsiClass psiClass, QlExpression selectExpression, boolean remoteOnly) {
        ArrayList<PsiType> result = new ArrayList<PsiType>();
        boolean isJava5 = PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiClass);
        if (selectExpression instanceof QlReferenceExpression) {
            Object selectElement = ((QlReferenceExpression)selectExpression).resolve();
            XmlTag xmlTag = null;
            if (selectElement instanceof XmlTag) {
                xmlTag = (XmlTag)selectElement;
            } else if (selectElement instanceof QlAliasDefinition) {
                QlEntity qlEntity;
                QlExpression referenceExpression = ((QlAliasDefinition)selectElement).getExpression();
                PsiReference r = referenceExpression instanceof QlReferenceExpression ? referenceExpression.getReference() : null;
                PsiElement resolve = r == null ? null : r.resolve();
                QlEntity qlEntity2 = qlEntity = resolve instanceof QlEntity ? (QlEntity)resolve : null;
                if (qlEntity != null && qlEntity.getPsiElement() instanceof XmlTag) {
                    xmlTag = (XmlTag)qlEntity.getPsiElement();
                }
            }
            if (xmlTag != null) {
                EntityBean ejb;
                PsiType type;
                DomElement domElement = DomManager.getDomManager((Project)selectExpression.getProject()).getDomElement(xmlTag);
                if (domElement instanceof com.intellij.javaee.model.xml.ejb.CmpField) {
                    com.intellij.javaee.model.xml.ejb.CmpField cmpField = (com.intellij.javaee.model.xml.ejb.CmpField)domElement;
                    type = EjbUtil.findType((CmpField)cmpField);
                    if (type != null) {
                        result.add(type);
                    }
                } else if (domElement instanceof CmrField) {
                    CmrField cmrField = (CmrField)domElement;
                    type = EjbUtil.findType((com.intellij.javaee.model.common.ejb.CmrField)cmrField);
                    if (type != null) {
                        result.add(type);
                    }
                } else if (domElement != null && (ejb = (EntityBean)domElement.getParentOfType(EntityBean.class, false)) != null) {
                    if (!remoteOnly && ejb.getLocal().getValue() != null) {
                        type = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType((PsiClass)ejb.getLocal().getValue());
                        result.add(type);
                    }
                    if (ejb.getRemote().getValue() != null) {
                        type = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType((PsiClass)ejb.getRemote().getValue());
                        result.add(type);
                    }
                }
            }
            if (result.size() == 0) {
                result.add((PsiType)PsiType.getJavaLangObject((PsiManager)psiClass.getManager(), (GlobalSearchScope)psiClass.getResolveScope()));
            }
            result.addAll(GenerateEJBFinderOrSelectorMethodHandler.getCollectionTypes(psiClass, result, isJava5));
        } else if (selectExpression instanceof QlAggregateExpression) {
            result.addAll(this.getTypeVariants(psiClass, selectExpression.getType(), null, remoteOnly));
        }
        if (result.size() == 0) {
            result.add((PsiType)PsiType.getJavaLangObject((PsiManager)psiClass.getManager(), (GlobalSearchScope)psiClass.getResolveScope()));
            result.addAll(GenerateEJBFinderOrSelectorMethodHandler.getCollectionTypes(psiClass, result, isJava5));
        }
        return result.toArray(PsiType.EMPTY_ARRAY);
    }

    private static List<PsiType> getCollectionTypes(PsiClass psiClass, List<PsiType> types, boolean java5) {
        ArrayList<PsiType> result = new ArrayList<PsiType>();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
        result.add((PsiType)psiElementFactory.createTypeByFQClassName("java.util.Collection", psiClass.getResolveScope()));
        result.add((PsiType)psiElementFactory.createTypeByFQClassName("java.util.List", psiClass.getResolveScope()));
        result.add((PsiType)psiElementFactory.createTypeByFQClassName("java.util.Set", psiClass.getResolveScope()));
        return result;
    }

    private static void generateQueryMetadata(PsiClass psiClass, String ejbQlString, PsiMethod method) {
        if (ejbQlString.length() == 0) {
            return;
        }
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            EnterpriseBean ejb = role.getEnterpriseBean();
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS && role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE && role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE || !EjbUtil.isCMP(ejb, CmpVersion.CmpVersion_2_X)) continue;
            EntityBean entity = (EntityBean)ModelMergerUtil.getImplementation((Object)ejb, EntityBean.class);
            if (entity == null) break;
            WriteCommandAction.writeCommandAction((Project)role.getModule().getProject(), (PsiFile[])new PsiFile[]{entity.getXmlTag().getContainingFile()}).run(() -> {
                Query query = entity.addQuery();
                query.getEjbQl().setValue((Object)ejbQlString);
                query.getQueryMethod().getMethodName().setValue((Object)method);
                MethodParams methodParams = query.getQueryMethod().getMethodParams();
                methodParams.ensureTagExists();
                for (PsiParameter parameter : method.getParameterList().getParameters()) {
                    methodParams.addMethodParam().setValue((Object)parameter.getType());
                }
            });
            break;
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/GenerateEJBFinderOrSelectorMethodHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

