/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.GenerateEJBReferenceHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GeneratePersistenceContextReferenceHandler
implements CodeInsightActionHandler {
    @NonNls
    private static final String ANNO_VAR_NAME = "anno";
    @NonNls
    private static final String UNIT_VAR_NAME = "unit";
    @NonNls
    private static final String FIELD_VAR_NAME = "field";
    @NonNls
    private static final String TYPE_VAR_NAME = "type";

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            GeneratePersistenceContextReferenceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GeneratePersistenceContextReferenceHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GeneratePersistenceContextReferenceHandler.$$$reportNull$$$0(2);
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass aClass = (PsiClass)element;
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        assert (aClass.isValid());
        assert (aClass.getContainingFile() != null);
        assert (aClass.getContainingFile() == file);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        final List unitNames = ContainerUtil.mapNotNull(JpaUtil.getPersistenceUnits(module), s -> (String)s.getName().getValue());
        final LookupElement[] unitLookupItems = (LookupElement[])ContainerUtil.map2Array((Collection)unitNames, LookupElement.class, s -> LookupElementBuilder.create((String)s).withIcon(JavaeeIcons.PERSISTENCE_UNIT_ICON));
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        Object[] annos = new String[]{"javax.persistence.PersistenceContext", "javax.persistence.PersistenceUnit"};
        LookupElement[] typeLookupItems = (LookupElement[])ContainerUtil.map2Array((Object[])annos, LookupElement.class, s -> {
            PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createTypeByFQClassName(s, GlobalSearchScope.allScope((Project)aClass.getProject()));
            return PsiTypeLookupItem.createLookupItem((PsiType)psiClassType, null);
        });
        Expression annoExpression = new Expression((String[])annos, typeLookupItems){
            final /* synthetic */ String[] val$annos;
            final /* synthetic */ LookupElement[] val$typeLookupItems;
            {
                this.val$annos = stringArray;
                this.val$typeLookupItems = lookupElementArray;
            }

            public Result calculateResult(ExpressionContext context) {
                return new TextResult(this.val$annos[0]);
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return this.val$typeLookupItems;
            }
        };
        Expression unitNameExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult((String)unitNames.get(0));
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return unitLookupItems;
            }
        };
        Expression typeExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                PsiAnnotation psiAnnotation;
                TextRange textRange = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableRange(GeneratePersistenceContextReferenceHandler.ANNO_VAR_NAME);
                PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
                if (psiElement != null && (psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAnnotation.class)) != null && "javax.persistence.PersistenceUnit".equals(psiAnnotation.getQualifiedName())) {
                    return new TextResult("javax.persistence.EntityManagerFactory");
                }
                return new TextResult("javax.persistence.EntityManager");
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return null;
            }
        };
        Expression fieldNameExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                TextResult typeResult = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableValue(GeneratePersistenceContextReferenceHandler.TYPE_VAR_NAME);
                return new TextResult(StringUtil.decapitalize((String)StringUtil.getShortName((String)typeResult.getText())));
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                TextRange textRange = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableRange(GeneratePersistenceContextReferenceHandler.TYPE_VAR_NAME);
                PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
                if (psiElement == null || !(psiElement.getParent() instanceof PsiJavaCodeReferenceElement)) {
                    return null;
                }
                PsiClassType classType = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createType((PsiJavaCodeReferenceElement)psiElement.getParent());
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.FIELD, null, null, (PsiType)classType);
                SuggestedNameInfo suggestedNameInfo2 = codeStyleManager.suggestUniqueVariableName(suggestedNameInfo, psiElement, true);
                LookupElement[] items = new LookupElement[suggestedNameInfo2.names.length + 1];
                int i = 0;
                String defaultName = StringUtil.decapitalize((String)StringUtil.getShortName((String)classType.getClassName()));
                items[i++] = LookupElementBuilder.create((String)defaultName);
                for (String name : suggestedNameInfo2.names) {
                    items[i++] = LookupElementBuilder.create((String)name);
                }
                return items;
            }
        };
        template.addTextSegment("\n@");
        template.addVariable(ANNO_VAR_NAME, annoExpression, annoExpression, true);
        if (unitNames.size() > 0) {
            template.addTextSegment("(");
            template.addTextSegment("unitName");
            template.addTextSegment("=\"");
            template.addVariable(UNIT_VAR_NAME, unitNameExpression, unitNameExpression, true);
            template.addTextSegment("\")");
        }
        template.addTextSegment("\nprivate ");
        template.addVariable(TYPE_VAR_NAME, typeExpression, typeExpression, false);
        template.addTextSegment(" ");
        template.addVariable(FIELD_VAR_NAME, fieldNameExpression, fieldNameExpression, true);
        template.addTextSegment(";\n");
        template.addEndVariable();
        editor.getCaretModel().moveToOffset(GenerateEJBReferenceHandler.getInsertOffset(editor, file));
        manager.startTemplate(editor, template);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/GeneratePersistenceContextReferenceHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

