/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbImplMethodRole;
import com.intellij.javaee.ejb.role.EjbImplMethodRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class EJBDeclarationAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)EJBDeclarationAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            EJBDeclarationAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            EJBDeclarationAction.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiMethod targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (targetMethod == null || !targetMethod.isValid()) {
            return false;
        }
        if (targetMethod.getBody() == null && !targetMethod.hasModifierProperty("abstract")) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetMethod, PsiErrorElement.class) != null) {
            return false;
        }
        if (targetMethod.getBody() != null && targetMethod.getBody().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        if (targetMethod.getDocComment() != null && targetMethod.getDocComment().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        String text = EJBDeclarationAction.getExplanation(targetMethod);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = J2EEBundle.message((String)"intention.add.method.to.ejb.interface.family", (Object[])new Object[0]);
        if (string == null) {
            EJBDeclarationAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String getExplanation(PsiMethod method) {
        PsiClass psiClass = method.getContainingClass();
        EjbClassRole classRole = OldEjbRolesUtil.getEjbRole(psiClass);
        if (classRole == null) {
            return null;
        }
        EnterpriseBean ejb = classRole.getEnterpriseBean();
        EjbMethodRoleImpl methodRole = EjbMethodRoleImpl.suggestMethodRole(classRole, method);
        if (methodRole == null) {
            return null;
        }
        if (!(methodRole instanceof EjbImplMethodRoleImpl)) {
            return null;
        }
        EjbImplMethodRoleImpl implMethodRole = (EjbImplMethodRoleImpl)methodRole;
        if (ejb == null || ejb instanceof MessageDrivenBean) {
            return null;
        }
        if (implMethodRole.findAllDeclarations().length == implMethodRole.numberOfDeclarationsRequired()) {
            return null;
        }
        PsiMethod[] suggestedDeclarations = implMethodRole.suggestDeclarations();
        if (suggestedDeclarations == null || suggestedDeclarations.length == 0) {
            return null;
        }
        if (classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS && method.hasModifierProperty("public") && !method.hasModifierProperty("static") && !EjbUtil.isSpecialEjbClassMethod(method.getName()) && !method.isConstructor()) {
            String suggestedName = suggestedDeclarations[0].getName();
            return J2EEBundle.message((String)"intention.add.method.to.ejb.interface.text", (Object[])new Object[]{suggestedName});
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        InterfaceInfo[] interfaces;
        if (project == null) {
            EJBDeclarationAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            EJBDeclarationAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        LOG.assertTrue(method != null);
        PsiClass psiClass = method.getContainingClass();
        EjbClassRole classRole = OldEjbRolesUtil.getEjbRole(psiClass);
        LOG.assertTrue(classRole != null);
        EnterpriseBean ejb = classRole.getEnterpriseBean();
        EjbMethodRoleImpl methodRole = EjbMethodRoleImpl.suggestMethodRole(classRole, method);
        LOG.assertTrue(methodRole instanceof EjbImplMethodRoleImpl);
        EjbImplMethodRole implMethodRole = (EjbImplMethodRole)methodRole;
        PsiMethod[] suggestedDeclarations = implMethodRole.suggestDeclarations();
        LOG.assertTrue(suggestedDeclarations != null && suggestedDeclarations.length == 2);
        String suggestedName = suggestedDeclarations[0].getName();
        ArrayList<InterfaceInfo> interfaceInfos = new ArrayList<InterfaceInfo>();
        switch (methodRole.getType()) {
            case EJB_METHOD_ROLE_CREATE_IMPL: 
            case EJB_METHOD_ROLE_POST_CREATE_IMPL: 
            case EJB_METHOD_ROLE_FINDER_IMPL: 
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: {
                if (ejb instanceof EjbWithHome) {
                    EjbWithHome elementWithHome = (EjbWithHome)ejb;
                    PsiClass localHomeInterface = (PsiClass)elementWithHome.getLocalHome().getValue();
                    PsiClass remoteHomeInterface = (PsiClass)elementWithHome.getHome().getValue();
                    InterfaceInfo interfaceInfo = new InterfaceInfo(new PsiClass[]{localHomeInterface}, suggestedDeclarations[0]);
                    if (localHomeInterface != null && !interfaceInfo.isImplemented()) {
                        interfaceInfos.add(interfaceInfo);
                    }
                    interfaceInfo = new InterfaceInfo(new PsiClass[]{remoteHomeInterface}, suggestedDeclarations[1]);
                    if (remoteHomeInterface != null && !interfaceInfo.isImplemented()) {
                        interfaceInfos.add(interfaceInfo);
                    }
                }
                if ((interfaces = interfaceInfos.toArray(new InterfaceInfo[0])).length == 2) {
                    SelectInterfacesDialog dialog = new SelectInterfacesDialog(project, interfaces, suggestedName);
                    dialog.show();
                    break;
                }
                if (interfaces.length == 1) {
                    interfaces[0].isSelected = true;
                    interfaces[0].selectedInterfaceClass = interfaces[0].interfaces[0];
                    break;
                }
                Messages.showMessageDialog((Project)project, (String)J2EEBundle.message((String)"intention.add.method.to.ejb.interface.error.no.home.interface", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
                break;
            }
            default: {
                InterfaceInfo interfaceInfo;
                int nParents = 0;
                for (PsiClass aClass : EjbUtil.getComponentInterfaces(ejb, false)) {
                    PsiClass[] parents = EJBDeclarationAction.getSelfOrParentInterfaces(aClass);
                    if (parents.length == 0 || (interfaceInfo = new InterfaceInfo(parents, suggestedDeclarations[0])).isImplemented()) continue;
                    interfaceInfos.add(interfaceInfo);
                    nParents += parents.length;
                }
                PsiClass remoteClass = JavaPsiFacade.getInstance((Project)ejb.getPsiManager().getProject()).findClass("java.rmi.Remote", GlobalSearchScope.allScope((Project)ejb.getPsiManager().getProject()));
                boolean preEjb30 = ejb.getEjbVersion().compareTo((Enum)EjbDescriptorVersion.EJB_VERSION_3_0) < 0;
                for (PsiClass aClass : EjbUtil.getComponentInterfaces(ejb, true)) {
                    PsiMethod suggestedDeclaration;
                    PsiClass[] parents = EJBDeclarationAction.getSelfOrParentInterfaces(aClass);
                    if (parents.length == 0 || (interfaceInfo = new InterfaceInfo(parents, suggestedDeclaration = preEjb30 || remoteClass == null || aClass.isInheritor(remoteClass, true) ? suggestedDeclarations[1] : suggestedDeclarations[0])).isImplemented()) continue;
                    interfaceInfos.add(interfaceInfo);
                    nParents += parents.length;
                }
                interfaces = interfaceInfos.toArray(new InterfaceInfo[0]);
                if (nParents > 1) {
                    SelectInterfacesDialog dialog = new SelectInterfacesDialog(project, interfaces, suggestedName);
                    dialog.show();
                    break;
                }
                if (nParents == 1) {
                    interfaces[0].isSelected = true;
                    interfaces[0].selectedInterfaceClass = interfaces[0].interfaces[0];
                    break;
                }
                Messages.showMessageDialog((Project)project, (String)J2EEBundle.message((String)"intention.add.method.to.ejb.interface.error.no.interface", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
            }
        }
        String[] warningMessage = new String[]{""};
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (element == null) {
                EJBDeclarationAction.$$$reportNull$$$0(5);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (element == null) {
                    EJBDeclarationAction.$$$reportNull$$$0(6);
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                for (InterfaceInfo selectedInterface : interfaces) {
                    if (!selectedInterface.isSelected) continue;
                    PsiFile targetFile = selectedInterface.selectedInterfaceClass.getContainingFile();
                    if (FileModificationService.getInstance().prepareFileForWrite(targetFile)) continue;
                    return;
                }
                boolean dirty = false;
                for (InterfaceInfo selectedInterface : interfaces) {
                    if (!selectedInterface.isSelected || !selectedInterface.introduceMethod()) continue;
                    dirty = true;
                }
                if (dirty) {
                    UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
                }
            });
        }, J2EEBundle.message((String)"intention.add.method.to.ejb.interface.command.name", (Object[])new Object[0]), (Object)this);
        if (!warningMessage[0].equals("")) {
            Messages.showMessageDialog((Project)project, (String)warningMessage[0], (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
        }
    }

    private static PsiClass[] getSelfOrParentInterfaces(PsiClass anInterface) {
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        if (anInterface.getManager().isInProject((PsiElement)anInterface)) {
            PsiClass[] parents;
            result.add(anInterface);
            for (PsiClass psiClass : parents = anInterface.getInterfaces()) {
                Object[] interfaces = EJBDeclarationAction.getSelfOrParentInterfaces(psiClass);
                if (interfaces == null) continue;
                ContainerUtil.addAll(result, (Object[])interfaces);
            }
        }
        return result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(PsiClass.EMPTY_ARRAY);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/EJBDeclarationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/EJBDeclarationAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SelectInterfacesDialog
    extends DialogWrapper {
        private final InterfaceInfo[] interfaceInfo;
        private final String method;
        private JCheckBox[] checkBoxes;
        private JComboBox[] selInterface;

        SelectInterfacesDialog(Project project, InterfaceInfo[] interfaceInfo, String method) {
            super(project, true);
            this.interfaceInfo = interfaceInfo;
            this.method = method;
            this.setTitle(J2EEBundle.message((String)"intention.add.method.to.ejb.interface.chooser.title", (Object[])new Object[0]));
            this.init();
        }

        protected Border createContentPaneBorder() {
            return BorderFactory.createEtchedBorder();
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel();
            JLabel label = new JLabel(J2EEBundle.message((String)"intention.add.method.to.ejb.interface.chooser.label", (Object[])new Object[]{this.method}));
            panel.add(label);
            return panel;
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel();
            panel.setOpaque(true);
            panel.setLayout(new GridLayout(this.interfaceInfo.length, 1));
            panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.checkBoxes = new JCheckBox[this.interfaceInfo.length];
            this.selInterface = new JComboBox[this.interfaceInfo.length];
            for (int i = 0; i < this.interfaceInfo.length; ++i) {
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout(0, 0));
                p.setBorder(BorderFactory.createEmptyBorder());
                String interfaceName = this.interfaceInfo[i].interfaceName;
                this.checkBoxes[i] = new JCheckBox(interfaceName);
                LOG.assertTrue(this.interfaceInfo[i].interfaces != null);
                this.checkBoxes[i].setSelected(true);
                this.checkBoxes[i].setMnemonic(interfaceName.charAt(0));
                p.add((Component)this.checkBoxes[i], "West");
                this.selInterface[i] = new JComboBox();
                for (PsiClass anInterface : this.interfaceInfo[i].interfaces) {
                    this.selInterface[i].addItem(anInterface.getName());
                }
                if (this.interfaceInfo[i].interfaces.length == 1) {
                    this.checkBoxes[i].setText(interfaceName + " (" + this.interfaceInfo[i].interfaces[0].getName() + ")");
                } else {
                    this.checkBoxes[i].setText(this.checkBoxes[i].getText() + ": ");
                    p.add((Component)this.selInterface[i], "East");
                    final int index = i;
                    this.checkBoxes[i].addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            selInterface[index].setEnabled(checkBoxes[index].isSelected());
                        }
                    });
                }
                panel.add(p);
                this.interfaceInfo[i].isSelected = true;
            }
            return panel;
        }

        public void doCancelAction() {
            for (InterfaceInfo aInterfaceInfo : this.interfaceInfo) {
                aInterfaceInfo.isSelected = false;
            }
            super.doCancelAction();
        }

        protected void doOKAction() {
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                JCheckBox checkBox = this.checkBoxes[i];
                this.interfaceInfo[i].isSelected = checkBox.isSelected();
                PsiClass[] interfaces = this.interfaceInfo[i].interfaces;
                this.interfaceInfo[i].selectedInterfaceClass = interfaces == null ? null : interfaces[this.selInterface[i].getSelectedIndex()];
            }
            super.doOKAction();
        }
    }

    public static class InterfaceInfo {
        public final PsiClass[] interfaces;
        private final PsiMethod mySuggestedMethod;
        public PsiClass selectedInterfaceClass;
        public final String interfaceName;
        public final boolean isRemote;
        public boolean isSelected;

        public InterfaceInfo(PsiClass[] interfaces, PsiMethod suggested) {
            this.interfaces = interfaces;
            this.mySuggestedMethod = suggested;
            String interfaceName = null;
            boolean isRemote = false;
            for (PsiClass anInterface : interfaces) {
                EjbClassRole classRole = OldEjbRolesUtil.getEjbRole(anInterface);
                if (classRole == null) continue;
                interfaceName = classRole.getTitle();
                isRemote = classRole.isRemote();
                break;
            }
            this.interfaceName = interfaceName;
            this.isRemote = isRemote;
        }

        public boolean isImplemented() {
            for (PsiClass anInterface : this.interfaces) {
                if (anInterface == null || anInterface.findMethodBySignature(this.mySuggestedMethod, true) == null) continue;
                return true;
            }
            return false;
        }

        public boolean introduceMethod() {
            PsiMethod copy = (PsiMethod)this.mySuggestedMethod.copy();
            if (this.selectedInterfaceClass.findMethodBySignature(copy, true) != null) {
                return false;
            }
            try {
                if (copy.getBody() != null) {
                    copy.getBody().delete();
                }
                this.selectedInterfaceClass.add((PsiElement)copy);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return true;
        }
    }
}

