/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.supportProvider;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class AddAppServerSupportUtil {
    private static final String LAST_USED_SERVER_PROPERTY = "javaee.appServer.lastUsedServer";
    private static final String LAST_USED_INTEGRATION_PROPERTY = "javaee.appServer.lastUsedIntegration";

    private AddAppServerSupportUtil() {
    }

    public static Comparator<AppServerIntegration> createIntegrationsComparator() {
        String lastUsed = PropertiesComponent.getInstance().getValue(LAST_USED_INTEGRATION_PROPERTY);
        return (o1, o2) -> {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            String name1 = o1.getPresentableName();
            String name2 = o2.getPresentableName();
            if (name1.equals(lastUsed)) {
                return -1;
            }
            if (name2.equals(lastUsed)) {
                return 1;
            }
            return name1.compareToIgnoreCase(name2);
        };
    }

    public static Comparator<ApplicationServer> createAppServerComparator() {
        Comparator<AppServerIntegration> integrationComparator = AddAppServerSupportUtil.createIntegrationsComparator();
        String lastUsed = PropertiesComponent.getInstance().getValue(LAST_USED_SERVER_PROPERTY);
        return (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            if (name1.equals(lastUsed)) {
                return -1;
            }
            if (name2.equals(lastUsed)) {
                return 1;
            }
            int res = integrationComparator.compare(o1.getSourceIntegration(), o2.getSourceIntegration());
            if (res != 0) {
                return res;
            }
            return name1.compareToIgnoreCase(name2);
        };
    }

    public static void markAppServerAsUsed(@NotNull ApplicationServer server) {
        if (server == null) {
            AddAppServerSupportUtil.$$$reportNull$$$0(0);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(LAST_USED_SERVER_PROPERTY, server.getName());
        AppServerIntegration integration = server.getSourceIntegration();
        if (integration != null) {
            properties.setValue(LAST_USED_INTEGRATION_PROPERTY, integration.getPresentableName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/appServers/supportProvider/AddAppServerSupportUtil", "markAppServerAsUsed"));
    }
}

