/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbInterfaceMethodInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.interface.method.signature", new Object[0]);
        if (string == null) {
            EjbInterfaceMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbInterfaceMethodInspection" == null) {
            EjbInterfaceMethodInspection.$$$reportNull$$$0(1);
        }
        return "EjbInterfaceMethodInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbInterfaceMethodInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            if (!role.getType().isInterface()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbInterfaceMethodInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
            }

            public void visitMethod(PsiMethod method) {
                EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
                EjbInterfaceMethodInspection.checkApplicationException(holder, method);
                EjbInterfaceMethodInspection.checkBeanClassNotExposed(holder, method, methodRoles);
                EjbInterfaceMethodInspection.checkBusinessMethodName(holder, method);
            }
        };
    }

    private static void checkBusinessMethodName(ProblemsHolder holder, PsiMethod method) {
        String name = method.getName();
        if (name.equals("class$") || name.startsWith("ejb") || name.equals("setEntityContext") || name.equals("unsetEntityContext") || name.equals("setSessionContext")) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingMessages.message("method.name.conflict", name), new LocalQuickFix[0]);
        }
    }

    private static void checkBeanClassNotExposed(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return;
        }
        HashSet<PsiClass> interfaces = null;
        String typeQName = returnType.getCanonicalText();
        for (EjbMethodRole role : methodRoles) {
            String ejbClassName;
            EnterpriseBean ejb = role.getEnterpriseBean();
            if (ejb == null || role.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL || role.getType() == EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL || !Comparing.equal((String)(ejbClassName = ejb.getEjbClass().getStringValue()), (String)typeQName)) continue;
            List<PsiClass> list = EjbUtil.getComponentInterfaces(ejb, role.getClassRole().isRemote());
            if (interfaces == null) {
                interfaces = new HashSet<PsiClass>(list);
                continue;
            }
            interfaces.retainAll(list);
        }
        if (interfaces != null) {
            ArrayList<LocalQuickFixAndIntentionActionOnPsiElement> quickFixes = new ArrayList<LocalQuickFixAndIntentionActionOnPsiElement>();
            for (PsiClass psiClass : interfaces) {
                if (psiClass == null) continue;
                PsiClassType type = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createType(psiClass);
                quickFixes.add(QuickFixFactory.getInstance().createMethodReturnFix(method, (PsiType)type, false));
            }
            String message = EjbHighlightingMessages.message("ejb.class.should.not.be.exposed", typeQName, method.getContainingClass().getName());
            holder.registerProblem((PsiElement)method.getReturnTypeElement(), message, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static void checkApplicationException(ProblemsHolder holder, PsiMethod method) {
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        PsiClass remoteException = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)nameIdentifier, "java.rmi.RemoteException");
        PsiClass runtimeException = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)nameIdentifier, "java.lang.RuntimeException");
        PsiClass exceptionException = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)nameIdentifier, "java.lang.Exception");
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        for (PsiJavaCodeReferenceElement element : method.getThrowsList().getReferenceElements()) {
            PsiClassType throwsType = psiElementFactory.createType(element);
            PsiClass throwException = throwsType.resolve();
            if (remoteException == null || throwException == null || method.getManager().areElementsEquivalent((PsiElement)remoteException, (PsiElement)throwException) || InheritanceUtil.isInheritorOrSelf((PsiClass)throwException, (PsiClass)exceptionException, (boolean)true) && !throwException.isInheritor(remoteException, true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)throwException, (PsiClass)runtimeException, (boolean)true)) continue;
            holder.registerProblem((PsiElement)element, EjbHighlightingMessages.message("method.should.not.throw", method.getName(), throwException.getQualifiedName()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodThrowsFix(method, throwsType, false, false)});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbInterfaceMethodInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbInterfaceMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

