/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import java.util.EnumSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbInterfaceSignatureInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.interface.signature", new Object[0]);
        if (string == null) {
            EjbInterfaceSignatureInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbInterfaceSignatureInspection" == null) {
            EjbInterfaceSignatureInspection.$$$reportNull$$$0(1);
        }
        return "EjbInterfaceSignatureInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbInterfaceSignatureInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbInterfaceSignatureInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(aClass);
                EnumSet<EjbClassRoleEnum> roleTypes = AbstractEjbInspection.getRoleTypes(classRoles);
                for (EjbClassRoleEnum type : roleTypes) {
                    if (!type.isInterface()) continue;
                    EjbInterfaceSignatureInspection.checkClassSignature(holder, aClass, classRoles, roleTypes);
                    return;
                }
            }
        };
    }

    private static void checkClassSignature(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles, EnumSet<EjbClassRoleEnum> roleTypes) {
        EjbHighlightUtil.checkClassIsInterface(holder, aClass, true);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "public", true);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "final", false);
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBLocalObject", false);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBObject", false);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "java.rmi.Remote", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBHome", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBLocalHome", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBLocalObject", true);
        }
        if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE) && EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE, classRoles)) {
            EjbHighlightUtil.checkClassExtends(holder, aClass, "javax.ejb.EJBObject", true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbInterfaceSignatureInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbInterfaceSignatureInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

