/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbSessionHomeInterfaceInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.session.home.interface", new Object[0]);
        if (string == null) {
            EjbSessionHomeInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbSessionHomeInterfaceInspection" == null) {
            EjbSessionHomeInterfaceInspection.$$$reportNull$$$0(1);
        }
        return "EjbSessionHomeInterfaceInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbSessionHomeInterfaceInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        if (!EjbSessionHomeInterfaceInspection.isOfType(SessionBean.class, classRoles)) {
            return false;
        }
        EnumSet<EjbClassRoleEnum> roleTypes = EjbSessionHomeInterfaceInspection.getRoleTypes(classRoles);
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbSessionHomeInterfaceInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbSessionHomeInterfaceInspection.checkExistsCreateMethod(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }

            public void visitMethod(PsiMethod method) {
                EnumSet<EjbClassRoleEnum> roleTypes = AbstractEjbInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(method.getContainingClass()));
                EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
                EjbSessionHomeInterfaceInspection.checkCreateMethod(holder, method, methodRoles);
                EjbSessionHomeInterfaceInspection.checkFinderMethod(holder, method);
                EjbSessionHomeInterfaceInspection.checkCreateMethodReturn(holder, method, methodRoles, roleTypes);
            }
        };
    }

    static void checkCreateMethodReturn(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles, EnumSet<EjbClassRoleEnum> roleTypes) {
        boolean checkCreate = false;
        for (EjbMethodRole role : methodRoles) {
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL) continue;
            checkCreate = true;
        }
        if (!checkCreate) {
            return;
        }
        HashSet<String> interfaces = EjbSessionHomeInterfaceInspection.getRequiredInterfaces(methodRoles, EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL, roleTypes);
        if (interfaces.size() > 1) {
            holder.registerProblem((PsiElement)method.getReturnTypeElement(), EjbHighlightingMessages.message("method.should.return", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(interfaces.toArray())), new LocalQuickFix[0]);
        } else if (interfaces.size() == 1) {
            EjbHighlightUtil.checkMethodReturns(holder, method, interfaces.iterator().next());
        }
    }

    static HashSet<String> getRequiredInterfaces(EjbMethodRole[] methodRoles, EjbMethodRoleEnum roleType, EnumSet<EjbClassRoleEnum> roleTypes) {
        HashSet<String> interfaces = new HashSet<String>();
        for (EjbMethodRole role : methodRoles) {
            PsiClass psiInterface;
            if (role.getType() != roleType) continue;
            EjbWithHome ejb = (EjbWithHome)role.getEnterpriseBean();
            PsiClass psiClass = psiInterface = roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) ? (PsiClass)ejb.getRemote().getValue() : (PsiClass)ejb.getLocal().getValue();
            if (psiInterface == null) continue;
            interfaces.add(psiInterface.getQualifiedName());
        }
        return interfaces;
    }

    private static void checkFinderMethod(ProblemsHolder holder, PsiMethod method) {
        if (method.getName().startsWith("find")) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingMessages.message("session.home.should.not.define.finder.methods", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkCreateMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean checkCreateException = false;
        boolean checkStatelessCreate = false;
        for (EjbMethodRole methodRole : methodRoles) {
            if (methodRole.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL) continue;
            checkCreateException = true;
            EnterpriseBean ejb = methodRole.getEnterpriseBean();
            if (!(ejb instanceof SessionBean) || ((SessionBean)ejb).getSessionType().getValue() == SessionType.STATEFUL) continue;
            checkStatelessCreate = true;
        }
        if (checkCreateException) {
            EjbHighlightUtil.checkMethodThrows(holder, method, "javax.ejb.CreateException", true);
        }
        if (checkStatelessCreate && (method.getName().length() > "create".length() || method.getParameterList().getParametersCount() > 0)) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingMessages.message("stateless.session.bean.home.interface.should.define.exactly.one.create.method", new Object[0]), new LocalQuickFix[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkExistsCreateMethod(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        LocalQuickFix[] localQuickFixArray;
        EjbClassRole chosenClassRole = null;
        for (EjbClassRole ejbClassRole : classRoles) {
            SessionBean ejb;
            if (!(ejbClassRole.getEnterpriseBean() instanceof SessionBean) || aClass != (ejb = (SessionBean)ejbClassRole.getEnterpriseBean()).getHome().getValue() && aClass != ejb.getLocalHome().getValue()) continue;
            chosenClassRole = ejbClassRole;
            break;
        }
        if (chosenClassRole == null) {
            return;
        }
        SessionBean ejb = (SessionBean)chosenClassRole.getEnterpriseBean();
        boolean isRemote = aClass == ejb.getHome().getValue();
        PsiClass ejbInterface = isRemote ? (PsiClass)ejb.getRemote().getValue() : (PsiClass)ejb.getLocal().getValue();
        for (PsiMethod psiMethod : aClass.getAllMethods()) {
            for (EjbMethodRole role : OldEjbRolesUtil.getEjbRoles(psiMethod)) {
                if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL) continue;
                return;
            }
        }
        if (isRemote) {
            String[] stringArray = new String[]{"javax.ejb.CreateException", "java.rmi.RemoteException"};
        } else {
            String[] stringArray = new String[]{"javax.ejb.CreateException"};
        }
        if (ejbInterface == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        } else {
            void var7_12;
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = QuickFixFactory.getInstance().createAddMethodFix(EjbSessionHomeInterfaceInspection.createMethodTemplate(ejbInterface), aClass, (String[])var7_12);
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        holder.registerProblem((PsiElement)aClass, EjbHighlightUtil.getClassDeclarationRange(aClass), EjbHighlightingMessages.message("home.interface.should.define.create.method", aClass.getName()), quickFixes);
    }

    private static String createMethodTemplate(PsiClass ejbInterface) {
        return "public " + ejbInterface.getQualifiedName() + " create();";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbSessionHomeInterfaceInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbSessionHomeInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

