/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.facet;

import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.artifact.JavaeeArtifactUtilImpl;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.ui.packaging.JavaeeFacetClassesPackagingElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaeeFacetEditorValidator
extends FacetEditorValidator {
    private final FacetEditorContext myContext;
    private final JavaeeFacet myFacet;

    public JavaeeFacetEditorValidator(JavaeeFacet facet, FacetEditorContext context) {
        this.myFacet = facet;
        this.myContext = context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ValidationResult check() {
        ArtifactsStructureConfigurableContext context = this.getArtifactsContext();
        JavaeeFacetType facetType = (JavaeeFacetType)this.myFacet.getType();
        Collection<ArtifactType> artifactTypes = facetType.getArtifactTypes();
        JavaeeArtifactUtilImpl artifactUtil = (JavaeeArtifactUtilImpl)JavaeeArtifactUtil.getInstance();
        Collection<Artifact> artifacts = artifactUtil.getArtifactsContainingFacet(this.myFacet, (PackagingElementResolvingContext)context, artifactTypes, false);
        if (artifacts.isEmpty()) {
            void var8_12;
            ArrayList<Artifact> existingArtifacts = new ArrayList<Artifact>();
            for (ArtifactType artifactType : artifactTypes) {
                existingArtifacts.addAll(context.getArtifactModel().getArtifactsByType(artifactType));
            }
            HashSet includedArtifacts = new HashSet();
            for (Artifact artifact : existingArtifacts) {
                ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)ArtifactElementType.ARTIFACT_ELEMENT_TYPE, artifactPackagingElement -> {
                    ContainerUtil.addIfNotNull((Collection)includedArtifacts, (Object)artifactPackagingElement.findArtifact((PackagingElementResolvingContext)context));
                    return true;
                }, (PackagingElementResolvingContext)context, (boolean)true);
            }
            existingArtifacts.removeAll(includedArtifacts);
            if (existingArtifacts.isEmpty()) {
                CreateArtifactQuickFix createArtifactQuickFix = new CreateArtifactQuickFix(context, facetType);
            } else {
                IncludeInArtifactQuickFix includeInArtifactQuickFix = new IncludeInArtifactQuickFix(existingArtifacts, context, facetType);
            }
            ValidationResult validationResult = new ValidationResult("'" + this.myFacet.getName() + "' Facet resources are not included in an artifact", (FacetConfigurationQuickFix)var8_12);
            if (validationResult == null) {
                JavaeeFacetEditorValidator.$$$reportNull$$$0(0);
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            JavaeeFacetEditorValidator.$$$reportNull$$$0(1);
        }
        return validationResult;
    }

    private ArtifactsStructureConfigurableContext getArtifactsContext() {
        return ((FacetEditorContextBase)this.myContext).getArtifactsStructureContext();
    }

    private void doIncludeInArtifact(Artifact artifact) {
        ArtifactsStructureConfigurableContext context = this.getArtifactsContext();
        context.editLayout(artifact, () -> {
            CompositePackagingElement root = context.getRootElement(artifact);
            root.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement(this.myFacet));
            if (!JavaeeApplicationFacet.ID.equals(this.myFacet.getTypeId())) {
                String path = ((JavaeeFacetType)this.myFacet.getType()).getDefaultUriForDirectory();
                PackagingElement<?> facetClasses = JavaeeFacetClassesPackagingElement.createPackagingElementForFacetClasses(this.myFacet, (PackagingElementResolvingContext)context);
                PackagingElementFactory.getInstance().getOrCreateDirectory(root, path).addOrFindChild(facetClasses);
            }
        });
        ArtifactEditor editor = context.getOrCreateEditor(artifact);
        ((ArtifactEditorEx)editor).rebuildTries();
        ProjectStructureConfigurable.getInstance((Project)this.myContext.getProject()).select(artifact, true);
    }

    private void createArtifact(JavaeeFacetType<?, ?> facetType, ArtifactsStructureConfigurableContext context) {
        String name = JavaeeUtil.suggestArtifactName(this.myFacet.getModule().getName(), this.myFacet.getName(), (FacetTypeId<? extends JavaeeFacet>)this.myFacet.getTypeId());
        ModifiableArtifact artifact = context.getOrCreateModifiableArtifactModel().addArtifact(name, facetType.getExplodedArtifactType());
        this.doIncludeInArtifact((Artifact)artifact);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/facet/JavaeeFacetEditorValidator", "check"));
    }

    private class IncludeInArtifactQuickFix
    extends FacetConfigurationQuickFix {
        private final List<Artifact> myExistingArtifacts;
        private final ArtifactsStructureConfigurableContext myContext;
        private final JavaeeFacetType<?, ?> myFacetType;

        IncludeInArtifactQuickFix(List<Artifact> existingArtifacts, ArtifactsStructureConfigurableContext context, JavaeeFacetType<?, ?> facetType) {
            this.myExistingArtifacts = existingArtifacts;
            this.myContext = context;
            this.myFacetType = facetType;
        }

        public void run(JComponent place) {
            String createTitle = "Create Artifact";
            String includeTitle = this.myExistingArtifacts.size() == 1 ? "Include in '" + this.myExistingArtifacts.get(0).getName() + "'" : "Include in artifact...";
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, new String[]{"Create Artifact", includeTitle}){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    if ("Create Artifact".equals(selectedValue)) {
                        JavaeeFacetEditorValidator.this.createArtifact(IncludeInArtifactQuickFix.this.myFacetType, IncludeInArtifactQuickFix.this.myContext);
                        return FINAL_CHOICE;
                    }
                    return IncludeInArtifactQuickFix.this.includeInArtifact();
                }
            }).showUnderneathOf((Component)place);
        }

        private PopupStep includeInArtifact() {
            if (this.myExistingArtifacts.size() == 1) {
                JavaeeFacetEditorValidator.this.doIncludeInArtifact(this.myExistingArtifacts.get(0));
                return PopupStep.FINAL_CHOICE;
            }
            return new BaseListPopupStep<Artifact>("Select Artifact", this.myExistingArtifacts){

                public Icon getIconFor(Artifact aValue) {
                    return aValue.getArtifactType().getIcon();
                }

                @NotNull
                public String getTextFor(Artifact value) {
                    String string = value.getName();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(Artifact selectedValue, boolean finalChoice) {
                    JavaeeFacetEditorValidator.this.doIncludeInArtifact(selectedValue);
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/facet/JavaeeFacetEditorValidator$IncludeInArtifactQuickFix$2", "getTextFor"));
                }
            };
        }
    }

    private class CreateArtifactQuickFix
    extends FacetConfigurationQuickFix {
        private final ArtifactsStructureConfigurableContext myContext;
        private final JavaeeFacetType<?, ?> myFacetType;

        CreateArtifactQuickFix(ArtifactsStructureConfigurableContext context, JavaeeFacetType<?, ?> facetType) {
            super("Create Artifact");
            this.myContext = context;
            this.myFacetType = facetType;
        }

        public void run(JComponent place) {
            JavaeeFacetEditorValidator.this.createArtifact(this.myFacetType, this.myContext);
        }
    }
}

