/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.jam.JamService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.ejb.EnvironmentGroupImpl;
import com.intellij.javaee.model.annotations.ejb.InterceptorMethodImpl;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.InterceptorBinding;
import com.intellij.javaee.model.common.ejb.InterceptorMethod;
import com.intellij.javaee.model.common.ejb.InterceptorMethodType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericValue;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InterceptorImpl
extends EnvironmentGroupImpl
implements Interceptor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.model.annotations.ejb.InterceptorImpl");
    public static final JamAnnotationMeta INTERCEPTORS_ANNO_META = new JamAnnotationMeta("javax.interceptor.Interceptors").addAttribute((JamAttributeMeta)JamClassAttributeMeta.Collection.CLASS_COLLECTION_VALUE_META);
    public static final JamClassMeta<InterceptorImpl> INTERCEPTOR_META = new JamClassMeta(ENV_GROUP_ARCHETYPE, InterceptorImpl.class, JAVAEE_ENVIRONMENT_KEY.subKey("@Interceptor", new SemKey[0]));

    public InterceptorImpl(PsiClass psiClass) {
        super(psiClass);
    }

    @Override
    protected JamClassMeta<?> getClassMeta() {
        return INTERCEPTOR_META;
    }

    public GenericValue<PsiClass> getInterceptorClass() {
        return AnnotationGenericValue.getInstance((Object)this.getPsiClass());
    }

    public List<InterceptorMethodImpl> getInterceptorMethods() {
        return JamService.getJamService((Project)this.getPsiClass().getProject()).getAnnotatedMembersList(this.getPsiClass(), false, true, false, true, new JamMemberMeta[]{InterceptorMethodImpl.METHOD_META});
    }

    public void processInterceptorBindings(Processor<InterceptorBinding> processor) {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null || !psiClass.isValid()) {
            return;
        }
        ReferencesSearch.search((PsiElement)psiClass).forEach(t -> {
            final PsiClassObjectAccessExpression classAccessExpression = (PsiClassObjectAccessExpression)PsiTreeUtil.getParentOfType((PsiElement)t.getElement(), PsiClassObjectAccessExpression.class);
            if (classAccessExpression != null) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiAnnotation.class);
                final PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiMember.class);
                if (psiMember != null && psiAnnotation != null && "javax.interceptor.Interceptors".equals(psiAnnotation.getQualifiedName()) && !processor.process((Object)new InterceptorBinding(){

                    public String getEjbName() {
                        return null;
                    }

                    public PsiMember getTargetMember() {
                        return psiMember;
                    }

                    public void delete() {
                        try {
                            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiAnnotation.class);
                            if (psiAnnotation != null && AnnotationModelUtil.getPsiClassArrayValue(psiAnnotation, "value").size() == 1) {
                                psiAnnotation.delete();
                            } else {
                                classAccessExpression.delete();
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                })) {
                    return false;
                }
            }
            return true;
        });
    }

    public void processInterceptorMethods(PsiClass currentClass, Processor<InterceptorMethod> processor) {
        boolean processDeep;
        PsiClass topClass = this.getPsiClass();
        boolean bl = processDeep = currentClass == null;
        if (topClass == null || !processDeep && topClass != currentClass && !topClass.isInheritor(currentClass, true)) {
            return;
        }
        InterceptorImpl.processInterceptorMethodsImpl(processDeep ? topClass : currentClass, processor, processDeep);
    }

    static void processInterceptorMethodsImpl(PsiClass interceptorClass, Processor<? super InterceptorMethod> processor, boolean processDeep) {
        block0: for (InterceptorMethodType type : InterceptorMethodType.values()) {
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)interceptorClass.getProject()).findClass(type.getMethodAnnotation(), interceptorClass.getResolveScope());
            if (annotationClass == null) continue;
            for (PsiClass currentClass : JamCommonUtil.getSuperClassList((PsiClass)interceptorClass)) {
                AnnotatedMembersSearch.search((PsiClass)annotationClass, (SearchScope)GlobalSearchScope.fileScope((PsiFile)currentClass.getContainingFile())).forEach(t -> !(t instanceof PsiMethod) || t.getContainingClass() != currentClass || processor.process((Object)new MyInterceptorMethod((PsiMember)t, type)));
                if (processDeep) continue;
                continue block0;
            }
        }
    }

    private static class MyInterceptorMethod
    implements InterceptorMethod {
        private final PsiMember myT;
        private final InterceptorMethodType myType;

        MyInterceptorMethod(PsiMember t, InterceptorMethodType type) {
            this.myT = t;
            this.myType = type;
        }

        @Nullable
        public PsiMethod getMethod() {
            return (PsiMethod)this.myT;
        }

        public InterceptorMethodType getType() {
            return this.myType;
        }

        public void delete() throws IncorrectOperationException {
            PsiAnnotation psiAnnotation = this.getDefiningElement();
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }

        public PsiAnnotation getDefiningElement() {
            return this.myT.getModifierList().findAnnotation(this.myType.getMethodAnnotation());
        }

        public PsiFile getContainingFile() {
            return this.myT.getContainingFile();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyInterceptorMethod that = (MyInterceptorMethod)o;
            if (this.myT != null ? !this.myT.equals(that.myT) : that.myT != null) {
                return false;
            }
            return this.myType == that.myType;
        }

        public int hashCode() {
            int result = this.myT != null ? this.myT.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            return result;
        }
    }
}

