/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.j2ee.JavaeeDataContextWrapper;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.module.view.JavaeeAbstractAction;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeAbstractCreateAction<T extends JavaeeModelElement, V extends Facet>
extends JavaeeAbstractAction {
    private final FacetTypeId<V> myFacetTypeId;

    protected JavaeeAbstractCreateAction(String text, String description, Icon icon, FacetTypeId<V> facetTypeId) {
        super(text, description, icon);
        this.myFacetTypeId = facetTypeId;
    }

    public static WebApp getWebApp(WebFacet webFacet) {
        List apps = webFacet.getWebApps();
        return apps.isEmpty() ? null : (WebApp)apps.get(0);
    }

    protected boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            JavaeeAbstractCreateAction.$$$reportNull$$$0(0);
        }
        return this.getFacet(e) != null;
    }

    @Nullable
    protected V getFacet(AnActionEvent e) {
        Module module;
        List<Object> srcRoot;
        ProjectFileIndex fileIndex;
        JavaeeFacet javaeeFacet = (JavaeeFacet)e.getData(JavaeeFacetNodeDescriptor.FACET_NODE_KEY);
        if (javaeeFacet != null) {
            if (javaeeFacet.getType().getId() == this.myFacetTypeId) {
                return (V)javaeeFacet;
            }
            return null;
        }
        PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        if (element instanceof PsiDirectory) {
            fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            VirtualFile file = ((PsiDirectory)element).getVirtualFile();
            srcRoot = Collections.singletonList(fileIndex.getSourceRootForFile(file));
            module = fileIndex.getModuleForFile(file);
        } else if (element instanceof PsiPackage) {
            srcRoot = new ArrayList();
            fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            for (PsiDirectory directory : ((PsiPackage)element).getDirectories()) {
                ContainerUtil.addIfNotNull(srcRoot, (Object)fileIndex.getSourceRootForFile(directory.getVirtualFile()));
            }
            module = (Module)e.getData(LangDataKeys.MODULE);
        } else {
            module = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
            srcRoot = Collections.emptyList();
        }
        if (module == null) {
            return null;
        }
        Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(this.myFacetTypeId);
        if (!srcRoot.isEmpty()) {
            for (Facet facet : facets) {
                if (!(facet instanceof FacetRootsProvider) || !((FacetRootsProvider)facet).getFacetRoots().containsAll(srcRoot)) continue;
                return (V)facet;
            }
            return null;
        }
        return (V)(facets.size() == 1 ? (Facet)facets.iterator().next() : null);
    }

    @Nullable
    protected abstract T createElement(@NotNull V var1, @NotNull String var2, @Nullable PsiDirectory var3);

    protected abstract void showAndSelect(@NotNull V var1, @NotNull T var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            JavaeeAbstractCreateAction.$$$reportNull$$$0(1);
        }
        V facet = this.getFacet(e);
        assert (facet != null) : this;
        JavaeeDataContextWrapper contextWrapper = new JavaeeDataContextWrapper(e);
        T t = this.createElement(facet, contextWrapper.getPackageName(), contextWrapper.getFirstDirectory());
        if (t != null) {
            PsiElement element = t.getIdentifyingPsiElement();
            if (element != null) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)element);
            }
            this.showAndSelect(facet, t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/javaee/module/view/JavaeeAbstractCreateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

