/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.ejbLevel;

import com.intellij.javaee.EjbDataHolder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.EjbRenameDialog;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.module.view.ejb.ejbLevel.EjbClassesPropertiesDialog;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;

public class EjbClassesListPanel
implements CommittablePanel {
    private final EjbBase myEjb;
    private JButton myChangeButton;
    private JButton myRenameButton;
    private JList myClassesList;
    private JPanel myPanel;
    private final DefaultListModel myClassesModel;

    public EjbClassesListPanel(final EjbBase ejb) {
        this.myEjb = ejb;
        this.$$$setupUI$$$();
        this.myChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EjbDataHolder ejbInfo = new EjbDataHolder(ejb);
                EjbClassesPropertiesDialog dialog = new EjbClassesPropertiesDialog(EjbUtil.getEjbFacet((JavaeeModelElement)ejb), ejbInfo, J2EEBundle.message((String)"dialog.title.change.ejb.classes", (Object[])new Object[0]), ejb.getManager().getProject(), ejb);
                if (!dialog.showAndGet()) {
                    return;
                }
                WriteCommandAction.writeCommandAction((Project)ejb.getManager().getProject(), (PsiFile[])new PsiFile[]{DomUtil.getFile((DomElement)ejb)}).withName(J2EEBundle.message((String)"command.name.ejb.editing", (Object[])new Object[0])).run(() -> ejbInfo.installTo(ejb));
            }
        });
        this.myRenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new EjbRenameDialog((EnterpriseBean)ejb).show();
            }
        });
        this.myClassesModel = new DefaultListModel();
        this.myClassesList.setModel(this.myClassesModel);
        this.myClassesList.getSelectionModel().setSelectionMode(0);
        this.myClassesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ModelElement element = (ModelElement)value;
                this.setText(element.className);
                this.setToolTipText(element.tooltip);
                this.setIcon(element.icon);
                if (!element.valid) {
                    this.setForeground((Color)JBColor.RED);
                }
                if (index % 2 == 0 && !isSelected) {
                    this.setBackground(StripeTableCellRenderer.darken((Color)this.getBackground()));
                }
                return this;
            }
        });
        this.reset();
    }

    public void commit() {
    }

    public void reset() {
        this.refreshClasses();
    }

    private void refreshClasses() {
        this.myClassesModel.removeAllElements();
        for (GenericValue aClass : EjbCommonModelUtil.getEjbClassesReferences((EnterpriseBean)this.myEjb, (boolean)true, (boolean)true, (boolean)true)) {
            if (aClass.getStringValue() == null) continue;
            ModelElement element = new ModelElement();
            element.className = aClass.getStringValue();
            PsiClass psiClass = (PsiClass)aClass.getValue();
            if (psiClass == null) {
                element.tooltip = J2EEBundle.message((String)"warning.text.class.does.not.exist", (Object[])new Object[]{element.className});
            } else {
                element.valid = true;
                element.icon = psiClass.getIcon(0);
                EjbClassRole role = EjbHelper.getEjbHelper().getEjbRole(psiClass);
                if (role != null) {
                    element.tooltip = role.getTitle();
                }
            }
            this.myClassesModel.addElement(element);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 2, null, new Dimension(-1, 110), null));
        JBList jBList = new JBList();
        this.myClassesList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myChangeButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/J2EEBundle").getString("button.change.ejb.classes"));
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRenameButton = jButton = new JButton();
        jButton.setActionCommand(ResourceBundle.getBundle("messages/J2EEBundle").getString("button.rename.ejb.and.classes"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/J2EEBundle").getString("button.rename.ejb.and.classes"));
        jPanel3.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ModelElement {
        Icon icon;
        String className;
        String tooltip;
        boolean valid;

        private ModelElement() {
        }
    }
}

