/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.permissions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.UserResponse;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodContainer;
import com.intellij.javaee.model.xml.ejb.MethodPermission;
import com.intellij.javaee.module.view.ejb.nodes.EjbFacetNodeDescriptor;
import com.intellij.javaee.module.view.ejb.permissions.EditSecurityRoleDialog;
import com.intellij.javaee.module.view.ejb.permissions.EjbMethodPermissionsModuleNodeDescriptor;
import com.intellij.javaee.module.view.ejb.permissions.MethodContainerHelper;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.ui.DefaultUserResponse;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ArrayConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.GenericDomValue;
import gnu.trove.THashSet;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbMethodPermissionsView
extends JamTreeTableView {
    private static final BooleanTableCellRenderer ourBooleanTableCellRenderer = new BooleanTableCellRenderer();
    private static final BooleanTableCellEditor ourBooleanTableCellEditor = new BooleanTableCellEditor();
    private final EjbFacet myEjbFacet;
    private final EjbJar myEjbJar;
    private final List<Runnable> myChanges = new ArrayList<Runnable>();
    private final AnAction myAddSecurityRoleAction = new AnAction(J2EEBundle.message((String)"action.text.add.security.role", (Object[])new Object[0]), null, IconUtil.getAddIcon()){

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            new EditSecurityRoleDialog(EjbMethodPermissionsView.this.getAssemblyDescriptor(), null, J2EEBundle.message((String)"action.text.add.security.role", (Object[])new Object[0])).show();
            EjbMethodPermissionsView.this.reset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView$1", "actionPerformed"));
        }
    };

    public EjbMethodPermissionsView(EjbFacet ejbFacet, EjbJar ejbJar) {
        super(ejbFacet.getModule().getProject(), new EjbMethodPermissionsModuleNodeDescriptor(ejbFacet, (Object)new J2EEModuleParameters(true)));
        this.myEjbFacet = ejbFacet;
        this.myEjbJar = ejbJar;
        this.getComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.getComponent().setFocusable(true);
        final TreeTableView table = this.getTreeTableView();
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add(EjbMethodPermissionsView.this.myAddSecurityRoleAction);
                    int i = table.columnAtPoint(e.getPoint());
                    if (i > 0 && i < table.getModel().getColumnCount() - 2) {
                        final SecurityRole role = (SecurityRole)EjbMethodPermissionsView.this.getAssemblyDescriptor().getSecurityRoles().get(i - 1);
                        String roleName = (String)role.getRoleName().getValue();
                        group.add(new AnAction(J2EEBundle.message((String)"action.text.edit.security.role.0", (Object[])new Object[]{roleName}), null, IconUtil.getEditIcon()){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                EjbMethodPermissionsView.this.showEditRoleDialog(role);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView$2$1", "actionPerformed"));
                            }
                        });
                        group.add(new AnAction(J2EEBundle.message((String)"action.text.remove.security.role.0", (Object[])new Object[]{roleName}), null, IconUtil.getRemoveIcon()){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                EjbMethodPermissionsView.this.deleteRole(role);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView$2$2", "actionPerformed"));
                            }
                        });
                    }
                    ActionManager.getInstance().createActionPopupMenu("ProjectViewPopup", (ActionGroup)group).getComponent().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        table.setAutoResizeMode(0);
        this.init();
        new TreeTableSpeedSearch((TreeTable)this.getTreeTableView());
    }

    @Override
    protected ColumnInfo[] createColumnInfos() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new TreeColumnInfo(J2EEBundle.message((String)"column.name.method.permissions.name", (Object[])new Object[0])));
        AssemblyDescriptor descriptor = this.getAssemblyDescriptor();
        for (SecurityRole role : descriptor.getSecurityRoles()) {
            list.add((Object)new SecurityRoleColumnInfo((String)role.getRoleName().getValue(), descriptor));
        }
        list.add((Object)new ExcludedColumnInfo());
        list.add((Object)new UncheckedColumnInfo(descriptor));
        return list.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    @Override
    @Nullable
    protected ActionGroup createToolbarActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.myAddSecurityRoleAction);
        actionGroup.add(new AnAction(J2EEBundle.message((String)"action.text.edit.security.role", (Object[])new Object[0]), null, IconUtil.getEditIcon()){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!EjbMethodPermissionsView.this.getAssemblyDescriptor().getSecurityRoles().isEmpty());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                EjbMethodPermissionsView.this.showSecurityRolesPopupMenu((Consumer<? super SecurityRole>)t -> EjbMethodPermissionsView.this.showEditRoleDialog(t), e, J2EEBundle.message((String)"action.text.edit.security.role", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actionGroup.add(new AnAction(J2EEBundle.message((String)"action.text.remove.security.role", (Object[])new Object[0]), null, IconUtil.getRemoveIcon()){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!EjbMethodPermissionsView.this.getAssemblyDescriptor().getSecurityRoles().isEmpty());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                EjbMethodPermissionsView.this.showSecurityRolesPopupMenu((Consumer<? super SecurityRole>)t -> EjbMethodPermissionsView.this.deleteRole(t), e, J2EEBundle.message((String)"action.text.remove.security.role", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return actionGroup;
    }

    @Override
    protected void setValueAt(ColumnInfo columnInfo, JamNodeDescriptor descriptor, Object aValue) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> this.myChanges.add(() -> columnInfo.setValue((Object)descriptor, aValue)), null, null);
    }

    @Override
    protected void cacheNode(JamNodeDescriptor node) {
    }

    @Override
    public void commit() {
        super.commit();
        this.doCommit();
    }

    @Override
    public void reset() {
        if (this.myChanges.isEmpty()) {
            super.reset();
        }
    }

    private void doCommit() {
        Runnable[] runnables = this.myChanges.toArray(new Runnable[0]);
        this.myChanges.clear();
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    @Override
    protected void cacheValues() {
        super.cacheValues();
        List allRoles = ContainerUtil.map((Collection)this.getAssemblyDescriptor().getSecurityRoles(), s -> (String)s.getRoleName().getValue());
        for (MethodPermission methodPermission : this.getAssemblyDescriptor().getMethodPermissions()) {
            final Set<Integer> columns = EjbMethodPermissionsView.getColumns(methodPermission, allRoles);
            MethodContainerHelper.processMethods(this.myEjbFacet, (MethodContainer)methodPermission, new ArrayConsumer<Object>(){

                public void consume(Object[] url) {
                    EjbMethodPermissionsView.this.setCachedValues(Boolean.TRUE, columns, url);
                }
            });
        }
        final Set<Integer> columns = Collections.singleton(1 + allRoles.size());
        MethodContainerHelper.processMethods(this.myEjbFacet, (MethodContainer)this.getAssemblyDescriptor().getExcludeList(), new ArrayConsumer<Object>(){

            public void consume(Object ... url) {
                EjbMethodPermissionsView.this.setCachedValues(Boolean.TRUE, columns, url);
            }
        });
    }

    @Override
    protected List<Object> getEmptyColumnValues() {
        return Collections.nCopies(this.getColumnInfos().length, Boolean.FALSE);
    }

    private static Set<Integer> getColumns(MethodPermission methodPermission, List<String> allRoles) {
        THashSet columns = new THashSet();
        if (((Boolean)methodPermission.getUnchecked().getValue()).booleanValue()) {
            columns.add(1 + allRoles.size() + 1);
        }
        List iterable = methodPermission.getRoleNames();
        for (GenericDomValue value : iterable) {
            int i = allRoles.indexOf(value.getStringValue());
            if (i < 0) continue;
            columns.add(1 + i);
        }
        return columns;
    }

    private void showEditRoleDialog(SecurityRole role) {
        new EditSecurityRoleDialog(this.getAssemblyDescriptor(), role, J2EEBundle.message((String)"action.text.edit.security.role", (Object[])new Object[0])).show();
        this.reset();
    }

    private void showSecurityRolesPopupMenu(final Consumer<? super SecurityRole> consumer, AnActionEvent e, String title) {
        AssemblyDescriptor descriptor = this.getAssemblyDescriptor();
        DefaultActionGroup group = new DefaultActionGroup();
        for (final SecurityRole role : descriptor.getSecurityRoles()) {
            group.add(new AnAction((String)role.getRoleName().getValue()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    consumer.consume((Object)role);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView$7", "actionPerformed"));
                }
            });
        }
        JBPopupFactory.getInstance().createActionGroupPopup(title, (ActionGroup)group, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showUnderneathOf(e.getInputEvent().getComponent());
    }

    private AssemblyDescriptor getAssemblyDescriptor() {
        return this.myEjbJar.getAssemblyDescriptor();
    }

    @Override
    protected boolean isShowTree() {
        return !EjbCommonModelUtil.getAllEjbs((Project)this.getProject(), null, (EjbFacet)this.myEjbFacet).isEmpty() || !this.getAssemblyDescriptor().getSecurityRoles().isEmpty();
    }

    @Override
    @NotNull
    protected String getEmptyPaneText() {
        String string = J2EEBundle.message((String)"message.text.no.ejbs.in.this.module", (Object[])new Object[0]);
        if (string == null) {
            EjbMethodPermissionsView.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void deleteRole(SecurityRole role) {
        EjbUtil.deleteModelElement((JavaeeModelElement)role, (JamUserResponse)new DefaultUserResponse(this.getProject()));
        this.reset();
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            EjbMethodPermissionsView.$$$reportNull$$$0(1);
        }
        if (PlatformDataKeys.HELP_ID.getName().equals(dataId)) {
            return "newEJBedit_module_method";
        }
        return super.getData(dataId);
    }

    @NotNull
    public static List<Method> getObjectAttributes(MethodContainerHelper container, JavaeeNodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        if (element instanceof EnterpriseBean) {
            EnterpriseBean ejb = (EnterpriseBean)element;
            List<Method> list = ejb.isValid() ? container.getEjbAttributes(ejb) : Collections.emptyList();
            if (list == null) {
                EjbMethodPermissionsView.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (element instanceof PsiClass) {
            EnterpriseBean ejb = (EnterpriseBean)descriptor.getParentDescriptor().getElement();
            List<Method> list = ejb.isValid() ? container.getClassAttributes((PsiClass)element, ejb) : Collections.emptyList();
            if (list == null) {
                EjbMethodPermissionsView.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (element instanceof PsiMethod) {
            EnterpriseBean ejb = (EnterpriseBean)descriptor.getParentDescriptor().getParentDescriptor().getElement();
            List<Method> list = ejb.isValid() ? container.getMethodAttributes((PsiMethod)element, (PsiClass)descriptor.getParentDescriptor().getElement(), ejb) : Collections.emptyList();
            if (list == null) {
                EjbMethodPermissionsView.$$$reportNull$$$0(4);
            }
            return list;
        }
        throw new AssertionError((Object)("Unexpected Element: " + element));
    }

    public static void setObjectAttribute(MethodContainerHelper attributeContainer, JamNodeDescriptor descriptor, String roleName, boolean set, JamUserResponse response) {
        EnterpriseBean ejb;
        Object element = descriptor.getElement();
        if (element instanceof EnterpriseBean) {
            ejb = (EnterpriseBean)element;
        } else if (element instanceof PsiClass) {
            ejb = (EnterpriseBean)descriptor.getParentDescriptor().getElement();
        } else if (element instanceof PsiMethod) {
            ejb = (EnterpriseBean)descriptor.getParentDescriptor().getParentDescriptor().getElement();
        } else {
            throw new AssertionError(element);
        }
        EjbFacet facet = (EjbFacet)ObjectUtils.assertNotNull((Object)EjbFacetNodeDescriptor.getEjbFacetForElement((NodeDescriptor)descriptor));
        EjbJar ejbJar = facet.getXmlRoot();
        if (ejbJar == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)descriptor.getProject(), (PsiFile[])new PsiFile[]{ejbJar.getContainingFile()}).run(() -> {
            if (element instanceof EnterpriseBean) {
                attributeContainer.setEjbAttribute(ejb, roleName, set, response);
            } else if (element instanceof PsiClass) {
                attributeContainer.setClassAttribute((PsiClass)element, ejb, roleName, set, response);
            } else if (element instanceof PsiMethod) {
                attributeContainer.setMethodAttribute((PsiMethod)element, (PsiClass)descriptor.getParentDescriptor().getElement(), ejb, roleName, set, response);
            }
        });
    }

    public static Boolean getMethodPermission(JavaeeNodeDescriptor descriptor, String roleName, AssemblyDescriptor assemblyDescriptor) {
        List<Method> attributes = EjbMethodPermissionsView.getObjectAttributes(new MethodContainerHelper.MethodPermissionHelper(assemblyDescriptor), descriptor);
        for (Method methodAttribute : attributes) {
            MethodPermission ejbMethodPermission = (MethodPermission)methodAttribute.getParent();
            Boolean unchecked = (Boolean)ejbMethodPermission.getUnchecked().getValue();
            if ((roleName != null || unchecked == null || !unchecked.booleanValue()) && !MethodContainerHelper.containsRoleWithName(ejbMethodPermission, roleName)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void setMethodPermissions(JavaeeNodeDescriptor descriptor, String roleName, Boolean set, AssemblyDescriptor assemblyDescriptor) {
        EjbMethodPermissionsView.setObjectAttribute(new MethodContainerHelper.MethodPermissionHelper(assemblyDescriptor), (JamNodeDescriptor)descriptor, roleName, set, UserResponse.QUIET);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyPaneText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/module/view/ejb/permissions/EjbMethodPermissionsView";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UncheckedColumnInfo
    extends AbstractBooleanColumnInfo {
        private final AssemblyDescriptor myDescriptor;

        UncheckedColumnInfo(AssemblyDescriptor descriptor) {
            super(J2EEBundle.message((String)"column.name.method.permissions.unchecked", (Object[])new Object[0]));
            this.myDescriptor = descriptor;
        }

        public Boolean valueOf(JavaeeNodeDescriptor object) {
            return Boolean.FALSE;
        }

        @Override
        public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
            EjbMethodPermissionsView.setMethodPermissions(o, null, aValue, this.myDescriptor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UncheckedColumnInfo that = (UncheckedColumnInfo)((Object)o);
            return !(this.myDescriptor != null ? !this.myDescriptor.equals(that.myDescriptor) : that.myDescriptor != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myDescriptor != null ? this.myDescriptor.hashCode() : 0);
            return result;
        }
    }

    private class ExcludedColumnInfo
    extends AbstractBooleanColumnInfo {
        ExcludedColumnInfo() {
            super(J2EEBundle.message((String)"column.name.method.permissions.excluded", (Object[])new Object[0]));
        }

        public Boolean valueOf(JavaeeNodeDescriptor object) {
            return Boolean.FALSE;
        }

        @Override
        public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
            EjbMethodPermissionsView.setObjectAttribute(new MethodContainerHelper.ExcludeListHelper(EjbMethodPermissionsView.this.getAssemblyDescriptor().getExcludeList()), (JamNodeDescriptor)o, null, aValue, UserResponse.QUIET);
        }
    }

    private static class SecurityRoleColumnInfo
    extends AbstractBooleanColumnInfo {
        private final String myName;
        private final AssemblyDescriptor myDescriptor;

        SecurityRoleColumnInfo(String name, AssemblyDescriptor descriptor) {
            super(name);
            this.myName = name;
            this.myDescriptor = descriptor;
        }

        public String getTooltipText() {
            return this.hasError() ? IdeBundle.message((String)"model.highlighting.identity", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(SecurityRole.class)}) : super.getTooltipText();
        }

        public final boolean hasError() {
            List all = ContainerUtil.findAll((Collection)this.myDescriptor.getSecurityRoles(), object -> Comparing.equal((String)((String)object.getRoleName().getValue()), (String)this.myName));
            return all.size() > 1;
        }

        @Override
        public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
            EjbMethodPermissionsView.setMethodPermissions(o, this.myName, aValue, this.myDescriptor);
        }

        public Boolean valueOf(JavaeeNodeDescriptor object) {
            return Boolean.FALSE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SecurityRoleColumnInfo that = (SecurityRoleColumnInfo)((Object)o);
            if (this.myDescriptor != null ? !this.myDescriptor.equals(that.myDescriptor) : that.myDescriptor != null) {
                return false;
            }
            return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myName.hashCode();
            result = 31 * result + this.myDescriptor.hashCode();
            return result;
        }
    }

    private static abstract class AbstractBooleanColumnInfo
    extends ColumnInfo<JavaeeNodeDescriptor, Boolean> {
        AbstractBooleanColumnInfo(String name) {
            super(name);
        }

        public int getWidth(JTable table) {
            return 15;
        }

        public boolean isCellEditable(JavaeeNodeDescriptor o) {
            return true;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public TableCellRenderer getRenderer(JavaeeNodeDescriptor p0) {
            return ourBooleanTableCellRenderer;
        }

        public TableCellEditor getEditor(JavaeeNodeDescriptor item) {
            return ourBooleanTableCellEditor;
        }

        public abstract void setValue(JavaeeNodeDescriptor var1, Boolean var2);
    }
}

