/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.references;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.enums.EjbRefType;
import com.intellij.javaee.model.xml.EjbLocalRef;
import com.intellij.javaee.model.xml.EjbRef;
import com.intellij.javaee.model.xml.EjbReference;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.JndiEnvironmentRefsGroup;
import com.intellij.javaee.module.view.DescriptionChildColumnInfo;
import com.intellij.javaee.module.view.ejb.references.CreateEjbReferenceTab;
import com.intellij.javaee.module.view.ejb.references.OneTabDialogSection;
import com.intellij.javaee.ui.DialogCommittableTab;
import com.intellij.javaee.ui.DialogElementWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.util.xml.ui.ChildGenericValueColumnInfo;
import com.intellij.util.xml.ui.ComboTableCellEditor;
import com.intellij.util.xml.ui.PsiClassTableCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class EjbReferenceSection<T extends EjbReference>
extends OneTabDialogSection<T> {
    private final Class<T> myClass;
    private final JndiEnvironmentRefsGroup myGroup;
    private final Project myProject;
    private final GlobalSearchScope myScope;
    private final String mySectionName;
    @NonNls
    private final String myHomeInterfaceTagName;
    @NonNls
    private final String myRemoteInterfaceTagName;
    @NonNls
    private final String myTagName;

    public EjbReferenceSection(JndiEnvironmentRefsGroup group, Class<T> aClass, String sectionName, @NonNls String tagName, @NonNls String remoteInterfaceTagName, @NonNls String homeInterfaceTagName) {
        this.myGroup = group;
        this.myClass = aClass;
        this.myProject = group.getManager().getProject();
        this.myScope = group.getResolveScope();
        this.mySectionName = sectionName;
        this.myHomeInterfaceTagName = homeInterfaceTagName;
        this.myRemoteInterfaceTagName = remoteInterfaceTagName;
        this.myTagName = tagName;
    }

    @Override
    public ColumnInfo<T, ?>[] createColumnInfos() {
        DomGenericInfo info = this.myGroup.getManager().getGenericInfo(this.myClass);
        PsiClassTableCellEditor editor = new PsiClassTableCellEditor(this.myProject, this.myScope);
        return new ColumnInfo[]{new ChildGenericValueColumnInfo(this.mySectionName, info.getFixedChildDescription("ejb-ref-name"), (TableCellEditor)new DefaultCellEditor(new JTextField())), new ChildGenericValueColumnInfo(J2EEBundle.message((String)"column.name.ejb.reference.type", (Object[])new Object[0]), info.getFixedChildDescription("ejb-ref-type"), (TableCellEditor)new ComboTableCellEditor(EjbRefType.class, false)), new DescriptionChildColumnInfo(), new ChildGenericValueColumnInfo(J2EEBundle.message((String)"column.name.ejb.reference.home", (Object[])new Object[0]), info.getFixedChildDescription(this.myHomeInterfaceTagName), (TableCellEditor)editor), new ChildGenericValueColumnInfo(J2EEBundle.message((String)"column.name.ejb.reference.component", (Object[])new Object[0]), info.getFixedChildDescription(this.myRemoteInterfaceTagName), (TableCellEditor)editor), new ChildGenericValueColumnInfo(J2EEBundle.message((String)"column.name.ejb.reference.link", (Object[])new Object[0]), info.getFixedChildDescription("ejb-link"), (TableCellEditor)new DefaultCellEditor(new JTextField()))};
    }

    @Override
    @NotNull
    public JavaeeDomModelElement getParentElement() {
        JndiEnvironmentRefsGroup jndiEnvironmentRefsGroup = this.myGroup;
        if (jndiEnvironmentRefsGroup == null) {
            EjbReferenceSection.$$$reportNull$$$0(0);
        }
        return jndiEnvironmentRefsGroup;
    }

    @Override
    @NotNull
    public String getSubTagName() {
        String string = this.myTagName;
        if (string == null) {
            EjbReferenceSection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected DialogCommittableTab<T> createDialogCommittableTab(DialogElementWrapper<T> wrapper) {
        return new CreateEjbReferenceTab<T>(wrapper, this.myGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/module/view/ejb/references/EjbReferenceSection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTagName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class EjbRefSection
    extends EjbReferenceSection<EjbRef> {
        public EjbRefSection(JndiEnvironmentRefsGroup group) {
            super(group, EjbRef.class, J2EEBundle.message((String)"title.module.ejb.remote.references", (Object[])new Object[0]), "ejb-ref", "remote", "home");
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        protected String getHelpId() {
            return "reference.javaee.webModuleEditor.assemblyDescriptorReferences.createEJBReference";
        }
    }

    public static abstract class EjbLocalRefSection
    extends EjbReferenceSection<EjbLocalRef> {
        public EjbLocalRefSection(JndiEnvironmentRefsGroup group) {
            super(group, EjbLocalRef.class, J2EEBundle.message((String)"title.module.ejb.local.references", (Object[])new Object[0]), "ejb-local-ref", "local", "local-home");
        }

        @Override
        protected String getHelpId() {
            return "reference.javaee.webModuleEditor.assemblyDescriptorReferences.createEJBLocalReference";
        }
    }
}

