/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.oss.util.TripleCheckBoxIcon;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.plaf.metal.MetalIconFactory;
import org.jetbrains.annotations.Nullable;

public class TripleCheckBox
extends JCheckBox {
    private static final Icon METAL_ICON = new TripleCheckBoxIcon(MetalIconFactory.getCheckBoxIcon());
    private static final List<Boolean> values = Arrays.asList(null, Boolean.TRUE, Boolean.FALSE);
    private int state;

    public TripleCheckBox() {
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setSelected(boolean selected) {
                TripleCheckBox.this.state = (TripleCheckBox.this.state + 1) % 3;
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            }

            @Override
            public boolean isSelected() {
                return Boolean.TRUE.equals(TripleCheckBox.this.getValue());
            }
        });
    }

    @Nullable
    public Boolean getValue() {
        return values.get(this.state);
    }

    public void setValue(@Nullable Boolean value) {
        this.state = values.indexOf(value);
        this.repaint();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setIcon(METAL_ICON);
    }
}

