/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.RunnerSpecificLocalConfigurationBit;
import com.intellij.javaee.run.execution.ExecutionHelper;
import com.intellij.javaee.run.execution.J2EELocalProcessHandlerWrapper;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.J2EEProcessHandlerHelper;
import com.intellij.javaee.run.execution.J2EEProcessHandlerWrapper;
import com.intellij.javaee.run.execution.J2EERunnableState;
import com.intellij.javaee.run.execution.LocalJavaeeServerProcessHandler;
import com.intellij.javaee.run.localRun.EnvironmentHelper;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ScriptInfo;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PatchedLocalState
implements PatchedRunnableState,
J2EERunnableState {
    private static final Logger LOG = Logger.getInstance(PatchedLocalState.class);
    private final RunnerSpecificLocalConfigurationBit myRunnerSpec;
    private final CommonStrategy myConfiguration;
    private final RunnerSettings myRunnerSettings;
    private final ExecutionHelper myExecutionHelper;
    private boolean myShutdownScriptSaved;
    private ExecutableObject myShutdownScript;
    private String myWorkingDirectory;
    private Map<String, String> myShutdownEnvParams;

    public PatchedLocalState(RunnerSpecificLocalConfigurationBit runnerSpec, CommonStrategy configuration, RunnerSettings runnerSettings, ExecutionHelper executionHelper) {
        this.myRunnerSpec = runnerSpec;
        this.myConfiguration = configuration;
        this.myRunnerSettings = runnerSettings;
        this.myExecutionHelper = executionHelper;
    }

    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            PatchedLocalState.$$$reportNull$$$0(0);
        }
        J2EEServerInstance serverInstance = this.myExecutionHelper.createServerInstance();
        J2EELocalProcessHandlerWrapper processHandlerWrapper = new J2EELocalProcessHandlerWrapper(serverInstance, executor, this.myConfiguration, this);
        return this.myExecutionHelper.createExecutionResult(processHandlerWrapper, executor);
    }

    @Override
    public J2EEProcess startJ2EEProcess(J2EEProcessHandlerWrapper processHandlerWrapper) throws ExecutionException {
        try {
            this.myExecutionHelper.checkAddressesAlreadyInUse(processHandlerWrapper);
            CommonStrategy runConfiguration = this.myRunnerSpec.getParentConfiguration();
            ScriptInfo startupInfo = this.myRunnerSpec.getStartupInfo();
            ScriptInfo shutdownInfo = this.myRunnerSpec.getShutdownInfo();
            startupInfo.initRunnerSettings((RunConfigurationBase)runConfiguration, this.myRunnerSettings);
            shutdownInfo.initRunnerSettings((RunConfigurationBase)runConfiguration, this.myRunnerSettings);
            ExecutableObject startupScript = this.myRunnerSpec.getStartupInfo().getScript();
            if (startupScript == null) {
                throw new ExecutionException(J2EEBundle.message((String)"exception.text.startup.script.is.not.specified", (Object[])new Object[0]));
            }
            J2EEServerInstance serverInstance = processHandlerWrapper.getServerInstance();
            boolean startupScriptTerminatesAfterServerStartup = serverInstance instanceof DefaultServerInstance && ((DefaultServerInstance)serverInstance).isStartupScriptTerminatesAfterServerStartup(startupScript);
            String workingDirectory = this.myConfiguration.getWorkingDirectory();
            OSProcessHandler startupHandler = startupScript.createProcessHandler(workingDirectory, this.getEnvParams(startupInfo, true));
            ScriptBasedLocalJavaeeServerProcessHandler result = new ScriptBasedLocalJavaeeServerProcessHandler(processHandlerWrapper.createHelper(), startupHandler, startupScriptTerminatesAfterServerStartup);
            processHandlerWrapper.connectToProcess();
            JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)processHandlerWrapper, this.myRunnerSettings);
            this.myShutdownScriptSaved = Registry.is((String)"javaee.save.shutdown.script.on.start");
            if (this.myShutdownScriptSaved) {
                this.myShutdownScript = shutdownInfo.getScript();
                if (this.myShutdownScript != null) {
                    this.myWorkingDirectory = workingDirectory;
                    this.myShutdownEnvParams = this.getEnvParams(shutdownInfo, false);
                }
            }
            return result;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new ExecutionException(J2EEBundle.message((String)"message.text.error.running.configuration.exception.occured.with.message", (Object[])new Object[]{this.myConfiguration.getIntegration().getPresentableName(), e.getClass().getName(), e.getMessage()}));
        }
    }

    private Map<String, String> getEnvParams(ScriptInfo scriptInfo, boolean addPredefinedVars) throws ExecutionException {
        return (Map)ReadAction.compute(() -> this.calcEnvParams(scriptInfo, addPredefinedVars));
    }

    @NotNull
    private Map<String, String> calcEnvParams(ScriptInfo scriptInfo, boolean addPredefinedVars) throws ExecutionException {
        EnvironmentHelper environmentHelper;
        Object envVariables;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.myRunnerSpec.USE_ENV_VARIABLES) {
            JavaParameters javaParameters = this.myRunnerSpec.createJavaParameters();
            this.myRunnerSpec.getRunner().patch(javaParameters, this.myRunnerSettings, (RunProfile)this.myRunnerSpec.getParentConfiguration(), true);
            for (RunConfigurationExtension ext : RunConfigurationExtension.EP_NAME.getExtensionList()) {
                ext.updateJavaParameters((RunConfigurationBase)this.myConfiguration, javaParameters, this.myRunnerSettings);
            }
            result.putAll(javaParameters.getEnv());
            envVariables = this.myRunnerSpec.getEnvVarValues(scriptInfo, addPredefinedVars, this.myRunnerSpec.appendVMArguments(javaParameters));
            result.putAll((Map<String, String>)envVariables);
        }
        if ((environmentHelper = this.myConfiguration.getHelper()) != null && (envVariables = environmentHelper.getAdditionalEnvironmentVariables((CommonModel)this.myConfiguration)) != null) {
            Iterator iterator = envVariables.iterator();
            while (iterator.hasNext()) {
                EnvironmentVariable variable = (EnvironmentVariable)iterator.next();
                if (result.containsKey(variable.getName())) continue;
                result.put(variable.getName(), variable.getValue());
            }
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            PatchedLocalState.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/run/execution/PatchedLocalState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/run/execution/PatchedLocalState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcEnvParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScriptBasedLocalJavaeeServerProcessHandler
    extends LocalJavaeeServerProcessHandler {
        ScriptBasedLocalJavaeeServerProcessHandler(J2EEProcessHandlerHelper helper, OSProcessHandler startupHandler, boolean startupScriptTerminatesAfterServerStartup) {
            super(helper, startupHandler, startupScriptTerminatesAfterServerStartup);
        }

        @Override
        protected void onBaseProcessTerminated() {
        }

        @Override
        public void shutdown() {
            ExecutableObject shutdownScript;
            ScriptInfo shutdownInfo = PatchedLocalState.this.myRunnerSpec.getShutdownInfo();
            ExecutableObject executableObject = shutdownScript = PatchedLocalState.this.myShutdownScriptSaved ? PatchedLocalState.this.myShutdownScript : shutdownInfo.getScript();
            if (shutdownScript == null) {
                this.myStartupHandler.destroyProcess();
                return;
            }
            try {
                Map shutdownEnvParams;
                String workingDirectory;
                if (PatchedLocalState.this.myShutdownScriptSaved) {
                    workingDirectory = PatchedLocalState.this.myWorkingDirectory;
                    shutdownEnvParams = PatchedLocalState.this.myShutdownEnvParams;
                } else {
                    workingDirectory = PatchedLocalState.this.myConfiguration.getWorkingDirectory();
                    shutdownEnvParams = PatchedLocalState.this.getEnvParams(shutdownInfo, false);
                }
                OSProcessHandler processHandler = shutdownScript.createProcessHandler(workingDirectory, shutdownEnvParams);
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ScriptBasedLocalJavaeeServerProcessHandler.this.notifyTextAvailable(event.getText(), outputType);
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (ScriptBasedLocalJavaeeServerProcessHandler.this.myStartupScriptTerminatesAfterServerStartup) {
                            ScriptBasedLocalJavaeeServerProcessHandler.this.terminateAndNotify();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/javaee/run/execution/PatchedLocalState$ScriptBasedLocalJavaeeServerProcessHandler$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                processHandler.startNotify();
            }
            catch (ExecutionException e) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(buffer));
                try {
                    this.myStartupHandler.notifyTextAvailable(buffer.toString(this.myStartupHandler.getCharset().name()), ProcessOutputTypes.STDERR);
                }
                catch (UnsupportedEncodingException e1) {
                    LOG.error((Throwable)e1);
                }
            }
        }
    }
}

