/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.transport;

import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportService;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.javaee.transport.TransportType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransportManager {
    private final List<TransportService> myServices = new ArrayList<TransportService>();

    public static TransportManager getInstance() {
        return (TransportManager)ServiceManager.getService(TransportManager.class);
    }

    public TransportManager() {
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(TransportService.EP_NAME);
        extensionPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<TransportService>(){

            public void extensionAdded(@NotNull TransportService service, @Nullable PluginDescriptor pluginDescriptor) {
                if (service == null) {
                    1.$$$reportNull$$$0(0);
                }
                TransportManager.this.myServices.add(service);
            }

            public void extensionRemoved(@NotNull TransportService service, @Nullable PluginDescriptor pluginDescriptor) {
                if (service == null) {
                    1.$$$reportNull$$$0(1);
                }
                TransportManager.this.myServices.remove(service);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "service";
                objectArray2[1] = "com/intellij/javaee/transport/TransportManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (this.myServices.isEmpty()) {
            this.myServices.addAll(Arrays.asList(extensionPoint.getExtensions()));
        }
    }

    public boolean hasServices() {
        return !this.myServices.isEmpty();
    }

    public List<TransportType> getTypes() {
        ArrayList<TransportType> result = new ArrayList<TransportType>();
        for (TransportService service : this.myServices) {
            result.addAll(service.getTypes());
        }
        return result;
    }

    public List<TransportHost> getAllHosts(@Nullable Project project) {
        ArrayList<TransportHost> result = new ArrayList<TransportHost>();
        for (TransportService service : this.myServices) {
            result.addAll(service.getHosts(project));
        }
        return result;
    }

    public List<TransportHost> getHostsOfType(TransportType type, @Nullable Project project) {
        ArrayList<TransportHost> result = new ArrayList<TransportHost>();
        for (TransportService service : this.myServices) {
            for (TransportHost host : service.getHosts(project)) {
                if (host.getType() != type) continue;
                result.add(host);
            }
        }
        return result;
    }

    @Nullable
    public TransportHost findHost(String hostId, @Nullable Project project) {
        for (TransportService service : this.myServices) {
            for (TransportHost host : service.getHosts(project)) {
                if (!host.getId().equals(hostId)) continue;
                return host;
            }
        }
        return null;
    }

    @Nullable
    public TransportHost editHostsOfType(TransportType type, TransportHost selectedHost, @Nullable Project project) {
        for (TransportService service : this.myServices) {
            if (!service.getTypes().contains(type)) continue;
            return service.editHostsOfType(type, selectedHost, project);
        }
        return null;
    }

    public static TransportTarget createTarget() {
        TransportTarget result = new TransportTarget();
        result.setId(TransportTarget.getNextId());
        return result;
    }
}

