/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.j2ee.web.WebUtilImpl;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.CustomServletReferenceProvider;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServletPathReferenceProvider
extends PathReferenceProviderBase {
    @NonNls
    private static final String J_SECURITY_CHECK = "j_security_check";

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        WebFacet webFacet;
        if (path == null) {
            ServletPathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ServletPathReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((webFacet = WebUtil.getWebFacet((PsiElement)element)) == null || !(element instanceof XmlElement)) {
            return null;
        }
        ServletMappingInfo info = WebUtilImpl.resolveServletMappingInfo(path, webFacet);
        if (info != null) {
            XmlElement xmlElement = (XmlElement)element;
            for (CustomServletReferenceProvider provider : CustomServletReferenceProvider.EXTENSION_POINT_NAME.getExtensionList()) {
                PathReference webPath = provider.createWebPath(path, (PsiElement)xmlElement, info);
                if (webPath == null) continue;
                return webPath;
            }
            return new PathReference(path, (Function)PathReference.NULL_ICON);
        }
        return null;
    }

    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, boolean soft) {
        WebFacet webFacet;
        if (psiElement == null) {
            ServletPathReferenceProvider.$$$reportNull$$$0(2);
        }
        if (references == null) {
            ServletPathReferenceProvider.$$$reportNull$$$0(3);
        }
        if ((webFacet = WebUtil.getWebFacet((PsiElement)psiElement)) != null) {
            ServletMappingInfo info = J_SECURITY_CHECK.equals(text) ? null : WebUtilImpl.resolveServletMappingInfo(text, webFacet);
            List providers = CustomServletReferenceProvider.EXTENSION_POINT_NAME.getExtensionList();
            boolean resolved = false;
            for (CustomServletReferenceProvider provider : providers) {
                Object[] psiReferences = provider.createReferences(psiElement, info, soft);
                if (psiReferences.length > 0) {
                    resolved = true;
                }
                ContainerUtil.addAll(references, (Object[])psiReferences);
            }
            if (info == null || info.getType() != ServletMappingType.DEFAULT) {
                references.add((PsiReference)new ServletReference(psiElement, offset, text, soft, info, !resolved));
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiReference createMappingReference(PsiElement psiElement) {
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiElement);
        if (webFacet != null && webFacet.getRoot() != null) {
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
            assert (manipulator != null) : "Cannot find manipulator for " + psiElement;
            TextRange range = manipulator.getRangeInElement(psiElement);
            String fullText = WebUtil.trimURL((String)range.substring(psiElement.getText()));
            ServletMappingInfo info = WebUtilImpl.resolveServletMappingInfo(fullText, webFacet);
            if (info != null) {
                return new ServletReference(psiElement, range.getStartOffset(), fullText, false, info, false);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/web/ServletPathReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ServletReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myText;

        ServletReference(PsiElement psiElement, int offset, String text, boolean soft, @Nullable ServletMappingInfo info, boolean isTheOnlyReference) {
            super(psiElement, new TextRange(offset, offset + text.length()), soft);
            TextRange range;
            this.myText = text;
            if (info != null && !isTheOnlyReference && (range = info.getMappingRange(text)) != null) {
                this.setRangeInElement(range.shiftRight(this.getRangeInElement().getStartOffset()));
            }
        }

        @Nullable
        private ServletMappingInfo resolveMapping() {
            WebFacet webFacet = this.getWebFacet();
            return webFacet == null || ServletPathReferenceProvider.J_SECURITY_CHECK.equals(this.myText) ? null : WebUtilImpl.resolveServletMappingInfo(this.myText, webFacet);
        }

        @Nullable
        public PsiElement resolve() {
            if (this.myText.equals(ServletPathReferenceProvider.J_SECURITY_CHECK)) {
                return this.getElement();
            }
            ServletMappingInfo mapping = this.resolveMapping();
            return mapping == null ? null : mapping.getServletMapping().getMappingElement();
        }

        @NotNull
        public Object[] getVariants() {
            WebFacet webFacet = this.getWebFacet();
            if (webFacet == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    ServletReference.$$$reportNull$$$0(0);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            List mappings = webFacet.getWebModel().getServletMappings();
            ArrayList<LookupElementBuilder> elements = new ArrayList<LookupElementBuilder>();
            for (CommonServletMapping mapping : mappings) {
                for (GenericValue pattern : mapping.getUrlPatterns()) {
                    int i;
                    String s = (String)pattern.getValue();
                    if (s == null || (i = s.indexOf(42)) == 0) continue;
                    if (i > 0) {
                        s = s.substring(0, i);
                    }
                    elements.add(LookupElementBuilder.create((String)s));
                    if (s.length() <= 1 || !s.startsWith("/")) continue;
                    elements.add(LookupElementBuilder.create((String)s.substring(1)));
                }
            }
            Object[] objectArray = ArrayUtil.toObjectArray(elements);
            if (objectArray == null) {
                ServletReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @Nullable
        private WebFacet getWebFacet() {
            return WebUtil.getWebFacet((PsiElement)this.getElement());
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = J2EEBundle.message((String)"servlet.reference.canonical.text", (Object[])new Object[0]);
            if (string == null) {
                ServletReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/javaee/web/ServletPathReferenceProvider$ServletReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

