/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.framework;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.framework.JavaeeFrameworkDetector;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetConfigurationImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.javaee.web.framework.WebFrameworkType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class WebFrameworkDetector
extends JavaeeFrameworkDetector<WebFacet, WebFacetConfiguration> {
    public WebFrameworkDetector() {
        super("web");
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().withName(DeploymentDescriptorsConstants.WEB_XML_META_DATA.getFileName()).andOr(new ElementPattern[]{FileContentPattern.fileContent().xmlWithRootTag("web-app"), FileContentPattern.fileContent().inDirectory("WEB-INF")});
        if (objectPattern == null) {
            WebFrameworkDetector.$$$reportNull$$$0(0);
        }
        return objectPattern;
    }

    @Override
    @NotNull
    public WebFacetType getFacetType() {
        WebFacetType webFacetType = WebFacetType.getInstance();
        if (webFacetType == null) {
            WebFrameworkDetector.$$$reportNull$$$0(1);
        }
        return webFacetType;
    }

    public FrameworkType getFrameworkType() {
        return WebFrameworkType.getInstance();
    }

    public void setupFacet(@NotNull WebFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            WebFrameworkDetector.$$$reportNull$$$0(2);
        }
        String[] sourceRootUrls = model.getSourceRootUrls(false);
        ((WebFacetConfigurationImpl)facet.getConfiguration()).setSourceRoots(Arrays.asList(sourceRootUrls));
    }

    @Override
    protected void setupConfiguration(WebFacetConfiguration configuration, VirtualFile file) {
        WebFacetConfigurationImpl configurationImpl = (WebFacetConfigurationImpl)configuration;
        VirtualFile parent = file.getParent();
        if (parent != null) {
            VirtualFile grandParent = parent.getParent();
            String webInf = DeploymentDescriptorsConstants.WEB_XML_META_DATA.getDirectoryPath();
            WebRootData webRoot = grandParent != null && webInf.equals(parent.getName()) ? new WebRootData(grandParent.getUrl(), "/") : new WebRootData(parent.getUrl(), "/" + webInf);
            configurationImpl.addWebRoot(webRoot);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/framework/WebFrameworkDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/framework/WebFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupFacet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

