/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.database.psi.DbTable;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaOrmReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JpaOrmReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.Table", "catalog"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.JoinTable", "catalog"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.CollectionTable", "catalog"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.SecondaryTable", "catalog"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.TableGenerator", "catalog")}), ORMReferencesUtil.createStringBasedReferenceProvider(ORMReferencesUtil.CATALOG_LOOKUP_MAPPER, element -> {
            PsiClass psiClass = ORMReferencesUtil.getTargetClass(element);
            if (psiClass == null) {
                return Collections.emptyList();
            }
            return ORMReferencesUtil.getCatalogVariants(PersistenceUtil.getDataSources((PsiClass)psiClass));
        }, JpaMessages.message((String)"cannot.resolve.catalog.0", (Object[])new Object[0])));
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.Table", "schema"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.JoinTable", "schema"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.CollectionTable", "schema"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.SecondaryTable", "schema"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.TableGenerator", "schema")}), ORMReferencesUtil.createStringBasedReferenceProvider(ORMReferencesUtil.SCHEMA_LOOKUP_MAPPER, element -> {
            PsiClass psiClass = ORMReferencesUtil.getTargetClass(element);
            if (psiClass == null) {
                return Collections.emptyList();
            }
            PsiAnnotation psiTableAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiTableAnnotation != null);
            String tableName = ORMReferencesUtil.getStringParameter(psiTableAnnotation, "javax.persistence.TableGenerator".equals(psiTableAnnotation.getQualifiedName()) ? "table" : "name");
            Collection dataSources = PersistenceUtil.getDataSources((PsiClass)psiClass);
            return ORMReferencesUtil.getSchemaVariants(dataSources, tableName);
        }, JpaMessages.message((String)"cannot.resolve.schema.0", (Object[])new Object[0])));
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.Table", "name"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.JoinTable", "name"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.CollectionTable", "name"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.SecondaryTable", "name"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.TableGenerator", "table")}), ORMReferencesUtil.createTableNameReferenceProvider((Function<? super PsiElement, ? extends Collection<DbTable>>)((Function)element -> {
            PsiClass psiClass = ORMReferencesUtil.getTargetClass(element);
            if (psiClass == null) {
                return Collections.emptyList();
            }
            PsiAnnotation psiTableAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiTableAnnotation != null);
            String schemaName = ORMReferencesUtil.getStringParameter(psiTableAnnotation, "schema");
            Collection dataSources = PersistenceUtil.getDataSources((PsiClass)psiClass);
            return ORMReferencesUtil.getTableVariants(dataSources, schemaName);
        })));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.Column", "table"), ORMReferencesUtil.createTableNameReferenceProvider((Function<? super PsiElement, ? extends Collection<DbTable>>)((Function)element -> {
            PsiClass psiClass = ORMReferencesUtil.getTargetClass(element);
            if (psiClass == null) {
                return Collections.emptyList();
            }
            Collection dataSources = PersistenceUtil.getDataSources((PsiClass)psiClass);
            return ORMReferencesUtil.getColumnTableVariants(dataSources, JpaUtil.getPersistentObjectsOfClass(psiClass, PersistentEntity.class), FunctionUtil.id());
        })));
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.UniqueConstraint", "columnNames"), PsiJavaPatterns.literalExpression().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiArrayInitializerMemberValue.class).annotationParam("javax.persistence.UniqueConstraint", "columnNames"))}), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> {
            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiAnnotation != null);
            PsiAnnotation psiTableAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiAnnotation.class);
            return psiTableAnnotation == null ? null : ORMReferencesUtil.getTableInfo(psiTableAnnotation, "name");
        })));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.Column", "name"), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> {
            PsiAnnotation annotation;
            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiAnnotation != null);
            String specifiedName = ORMReferencesUtil.getStringParameter(psiAnnotation, "table");
            if (StringUtil.isEmpty((String)specifiedName) && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)ORMReferencesUtil.getTargetMember((PsiElement)psiAnnotation, false), (String[])new String[]{"javax.persistence.CollectionTable"})) != null) {
                return ORMReferencesUtil.getTableInfo(annotation, "name");
            }
            return ORMReferencesUtil.getEntityTableInfo(element, null, specifiedName);
        })));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.JoinColumn", "name"), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> {
            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiAnnotation != null);
            String specifiedName = ORMReferencesUtil.getStringParameter(psiAnnotation, "table");
            PsiAnnotation psiParentAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiAnnotation.class);
            if (psiParentAnnotation != null && ("javax.persistence.JoinTable".equals(psiParentAnnotation.getQualifiedName()) || "javax.persistence.CollectionTable".equals(psiParentAnnotation.getQualifiedName()))) {
                return ORMReferencesUtil.getTableInfo(psiParentAnnotation, "name");
            }
            PsiMember targetMember = ORMReferencesUtil.getTargetMember(element, true);
            ORMReferencesUtil.TableInfo tableInfo = JpaOrmReferenceContributor.getEmbeddedAttributeTableInfoForAssociationOverride(psiParentAnnotation, targetMember, element, specifiedName);
            if (tableInfo != null) {
                return tableInfo;
            }
            return ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(targetMember, false), element, specifiedName);
        })));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.JoinColumn", "referencedColumnName"), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> {
            PsiMember member;
            boolean isTargetEntity;
            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiAnnotation != null);
            PsiAnnotation psiParentAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiAnnotation.class);
            if (psiParentAnnotation != null && ("javax.persistence.JoinTable".equals(psiParentAnnotation.getQualifiedName()) || "javax.persistence.CollectionTable".equals(psiParentAnnotation.getQualifiedName()))) {
                PsiAnnotationMemberValue joinColumns = psiParentAnnotation.findAttributeValue("joinColumns");
                PsiAnnotationMemberValue inverseColumns = psiParentAnnotation.findAttributeValue("inverseJoinColumns");
                if (PsiTreeUtil.isAncestor((PsiElement)joinColumns, (PsiElement)element, (boolean)true)) {
                    isTargetEntity = false;
                } else {
                    if (!PsiTreeUtil.isAncestor((PsiElement)inverseColumns, (PsiElement)element, (boolean)true)) return null;
                    isTargetEntity = true;
                }
            } else {
                isTargetEntity = true;
            }
            if (!isTargetEntity) return ORMReferencesUtil.getEntityTableInfo(element, null);
            if (psiParentAnnotation != null && "javax.persistence.AssociationOverride".equals(psiParentAnnotation.getQualifiedName())) {
                String attributeName = ORMReferencesUtil.getStringParameter(psiParentAnnotation, "name");
                PersistentAttribute base = attributeName == null ? null : (PersistentAttribute)ElementPresentationManager.findByName(ORMReferencesUtil.getPersistenceAttributes(ORMReferencesUtil.getTargetMember(element, true), true), (String)attributeName);
                member = base == null ? null : base.getPsiMember();
                return ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(member, true), element);
            } else {
                member = ORMReferencesUtil.getTargetMember(element, false);
            }
            return ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(member, true), element);
        })));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.PrimaryKeyJoinColumn", "name"), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> {
            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiAnnotation != null);
            PsiAnnotation psiParentAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiAnnotation.class);
            if (psiParentAnnotation != null && "javax.persistence.SecondaryTable".equals(psiParentAnnotation.getQualifiedName())) {
                return ORMReferencesUtil.getTableInfo(psiParentAnnotation, "name");
            }
            return ORMReferencesUtil.getEntityTableInfo(element, null);
        })));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.PrimaryKeyJoinColumn", "referencedColumnName"), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> {
            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiAnnotation != null);
            PsiAnnotation psiParentAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiAnnotation.class);
            if (psiParentAnnotation != null && "javax.persistence.SecondaryTable".equals(psiParentAnnotation.getQualifiedName())) {
                return ORMReferencesUtil.getEntityTableInfo(element, null);
            }
            PsiMember member = ORMReferencesUtil.getTargetMember(element, false);
            if (member == null) {
                PsiClass psiClass = ORMReferencesUtil.getTargetClass(element);
                if (psiClass == null) {
                    return null;
                }
                return ORMReferencesUtil.getEntityTableInfo((PsiElement)psiClass.getSuperClass(), (PsiElement)psiClass);
            }
            return ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(member, true), element);
        })));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.DiscriminatorColumn", "name"), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> ORMReferencesUtil.getEntityTableInfo(element, null))));
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.TableGenerator", "pkColumnName"), PsiJavaPatterns.literalExpression().annotationParam("javax.persistence.TableGenerator", "valueColumnName")}), ORMReferencesUtil.createColumnNameReferenceProvider((Function<? super PsiElement, ? extends ORMReferencesUtil.TableInfo>)((Function)element -> {
            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            assert (psiAnnotation != null);
            return ORMReferencesUtil.getTableInfo(psiAnnotation, "table");
        })));
    }

    @Nullable
    private static ORMReferencesUtil.TableInfo getEmbeddedAttributeTableInfoForAssociationOverride(@Nullable PsiAnnotation psiParentAnnotation, @Nullable PsiMember targetMember, @NotNull PsiElement element, @Nullable String specifiedName) {
        if (element == null) {
            JpaOrmReferenceContributor.$$$reportNull$$$0(1);
        }
        if (targetMember == null) {
            return null;
        }
        if (psiParentAnnotation == null || !"javax.persistence.AssociationOverride".equals(psiParentAnnotation.getQualifiedName())) {
            return null;
        }
        final String nameParam = AnnotationUtil.getStringAttributeValue((PsiAnnotation)psiParentAnnotation, (String)"name");
        if (StringUtil.isNotEmpty((String)nameParam)) {
            PersistenceModelBrowser browser = PersistenceHelper.getHelper().getSharedModelBrowser();
            for (PersistentAttribute attribute : browser.getPersistenceAttributes(targetMember)) {
                PsiClass psiClass;
                if (!(attribute instanceof PersistentEmbeddedAttribute) || (psiClass = (PsiClass)((PersistentEmbeddedAttribute)attribute).getTargetEmbeddableClass().getValue()) == null) continue;
                for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
                    CommonProcessors.FindFirstProcessor<PersistentAttribute> firstProcessor = new CommonProcessors.FindFirstProcessor<PersistentAttribute>(){

                        protected boolean accept(PersistentAttribute attribute) {
                            return nameParam.equals(attribute.getName().getStringValue());
                        }
                    };
                    browser.queryAttributes(role.getPersistentObject()).forEach((Processor)firstProcessor);
                    PersistentAttribute foundValue = (PersistentAttribute)firstProcessor.getFoundValue();
                    if (foundValue == null) continue;
                    return ORMReferencesUtil.getEntityTableInfo((PsiElement)ORMReferencesUtil.getEntityClass(foundValue.getPsiMember(), false), element, specifiedName);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/JpaOrmReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEmbeddedAttributeTableInfoForAssociationOverride";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

