/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.ULiteralExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.UastLiteralReferenceProvider;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastLiteralUtils;

public class JpaQueryReferenceProvider
extends UastLiteralReferenceProvider {
    private static final ULiteralExpressionPattern CREATE_NAMED_QUERY_PATTERN = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("createNamedQuery")).definedInClass("javax.persistence.EntityManager"));
    private static final ULiteralExpressionPattern GET_NAMED_QUERY_PATTERN = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getNamedQuery")).definedInClass("org.hibernate.Session"));
    private static final ULiteralExpressionPattern CREATE_NAMED_QUERY_PATTERN_2 = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getNamedQuery")).definedInClass("org.hibernate.SharedSessionContract"));
    private static final ULiteralExpressionPattern QUERY_PRODUCER = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getNamedQuery")).definedInClass("org.hibernate.query.QueryProducer"));
    private static final ULiteralExpressionPattern JPA_OPERTIONS_PATTERN = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.jpa.JpaOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParams"})));
    private static final ULiteralExpressionPattern HIBERNATE_3_OPERATIONS_PATTERN = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate3.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParam", "findByNamedQueryAndValueBean"})));
    private static final ULiteralExpressionPattern HIBERNATE_4_OPERATIONS_PATTERN = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate4.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParam", "findByNamedQueryAndValueBean"})));
    private static final ULiteralExpressionPattern HIBERNATE_5_OPERATIONS_PATTERN = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().methodCallParameter(0, (ElementPattern)PsiJavaPatterns.psiMethod().definedInClass("org.springframework.orm.hibernate5.HibernateOperations").withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"findByNamedQuery", "findByNamedQueryAndNamedParam", "findByNamedQueryAndValueBean"})));
    public static final ElementPattern<UElement> ALL_PATTERNS = StandardPatterns.or((ElementPattern[])new ElementPattern[]{CREATE_NAMED_QUERY_PATTERN, QUERY_PRODUCER, GET_NAMED_QUERY_PATTERN, CREATE_NAMED_QUERY_PATTERN_2, JPA_OPERTIONS_PATTERN, HIBERNATE_3_OPERATIONS_PATTERN, HIBERNATE_4_OPERATIONS_PATTERN, HIBERNATE_5_OPERATIONS_PATTERN});

    @NotNull
    public PsiReference[] getReferencesByULiteral(@NotNull ULiteralExpression uLiteral, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        Module module;
        if (uLiteral == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host)) != null) {
            String queryName = UastLiteralUtils.getValueIfStringLiteral((UElement)uLiteral);
            List facets = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module);
            PsiReference[] psiReferenceArray = new PsiReference[]{new QueryReference((PsiElement)host, queryName, facets)};
            if (psiReferenceArray == null) {
                JpaQueryReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JpaQueryReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uLiteral";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaQueryReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaQueryReferenceProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByULiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByULiteral";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QueryReference
    extends QueryRelatedReference {
        private final String myQueryName;
        private final List<? extends PersistenceFacet> myFacets;
        private String myLocalName;

        public QueryReference(PsiElement element, String queryName, List<? extends PersistenceFacet> facets) {
            super(element);
            this.myQueryName = queryName;
            this.myFacets = facets;
        }

        @Nullable
        public PersistenceQuery resolveQuery() {
            PersistenceQuery query;
            if (StringUtil.isEmpty((String)this.myQueryName)) {
                return null;
            }
            this.myLocalName = null;
            CommonProcessors.FindFirstProcessor<PersistenceQuery> processor = new CommonProcessors.FindFirstProcessor<PersistenceQuery>(){

                public boolean process(PersistenceQuery persistenceQuery) {
                    return !Comparing.equal((String)myQueryName, (String)((String)persistenceQuery.getName().getValue()), (boolean)true) || super.process((Object)persistenceQuery);
                }
            };
            PersistenceRoleHolder roleHolder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet persistenceFacet : this.myFacets) {
                if (!roleHolder.processMergedQueries(persistenceFacet, (Processor)processor)) break;
            }
            PersistenceQuery persistenceQuery = query = processor.isFound() ? (PersistenceQuery)processor.getFoundValue() : null;
            if (query != null) {
                this.myLocalName = query.getName().getStringValue();
            }
            return query;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            String text;
            if (newElementName == null) {
                QueryReference.$$$reportNull$$$0(0);
            }
            String realNewName = (text = this.getRangeInElement().substring(this.myElement.getText())).endsWith(this.myLocalName) && text.length() > this.myLocalName.length() ? text.substring(0, text.length() - this.myLocalName.length()) + newElementName : newElementName;
            return super.handleElementRename(realNewName);
        }

        public PsiElement resolve() {
            PersistenceQuery persistenceQuery = this.resolveQuery();
            return persistenceQuery == null ? null : persistenceQuery.getIdentifyingPsiElement();
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList result = new ArrayList();
            Processor processor = persistenceQuery -> {
                String name = (String)persistenceQuery.getName().getValue();
                if (StringUtil.isNotEmpty((String)name)) {
                    String query = (String)persistenceQuery.getQuery().getValue();
                    LookupElementBuilder lookupItem = LookupElementBuilder.create((String)name);
                    if (StringUtil.isNotEmpty((String)query)) {
                        int maxDisplayChars = 30;
                        String text = query.length() < maxDisplayChars ? query : query.substring(0, maxDisplayChars) + "...";
                        lookupItem = lookupItem.withTypeText(text);
                    }
                    result.add(lookupItem);
                }
                return true;
            };
            PersistenceRoleHolder holder = PersistenceRoleHolder.getInstance((Project)this.myElement.getProject());
            for (PersistenceFacet persistenceFacet : this.myFacets) {
                if (!holder.processMergedQueries(persistenceFacet, processor)) break;
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                QueryReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = JpaMessages.message((String)"cannot.resolve.query.0", (Object[])new Object[0]);
            if (string == null) {
                QueryReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/JpaQueryReferenceProvider$QueryReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/JpaQueryReferenceProvider$QueryReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class QueryRelatedReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        public QueryRelatedReference(PsiElement element) {
            super(element, false);
        }

        public LocalQuickFix[] getQuickFixes() {
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }
}

