/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.persistence.util.JavaContainerType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DatabaseRelationshipData {
    private final Role source = new Role(this);
    private final Role target = new Role(this);
    private final List<Join> joins = new ArrayList<Join>();
    private DasTable joinTable;

    public Role getSource() {
        return this.source;
    }

    public Role getTarget() {
        return this.target;
    }

    public DasTable getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(DasTable joinTable) {
        this.joinTable = joinTable;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public static class Join {
        private DasColumn source;
        private DasColumn sourceJoin;
        private DasColumn targetJoin;
        private DasColumn target;

        public Join(DasColumn source, DasColumn sourceJoin, DasColumn targetJoin, DasColumn target) {
            this.source = source;
            this.sourceJoin = sourceJoin;
            this.targetJoin = targetJoin;
            this.target = target;
        }

        public DasColumn getSource() {
            return this.source;
        }

        public void setSource(@Nullable DasColumn source) {
            this.source = source;
        }

        public DasColumn getSourceJoin() {
            return this.sourceJoin;
        }

        public void setSourceJoin(@Nullable DasColumn sourceJoin) {
            this.sourceJoin = sourceJoin;
        }

        public DasColumn getTargetJoin() {
            return this.targetJoin;
        }

        public void setTargetJoin(@Nullable DasColumn targetJoin) {
            this.targetJoin = targetJoin;
        }

        public DasColumn getTarget() {
            return this.target;
        }

        public void setTarget(@Nullable DasColumn target) {
            this.target = target;
        }
    }

    public static class Role {
        private DasTable table;
        private JavaContainerType containerType;
        private String attribute;
        private DasColumn mapKey;
        private final DatabaseRelationshipData myRelationship;

        public Role(DatabaseRelationshipData parent) {
            this.myRelationship = parent;
        }

        public DatabaseRelationshipData getRelationship() {
            return this.myRelationship;
        }

        public DasTable getTable() {
            return this.table;
        }

        public void setTable(DasTable table) {
            this.table = table;
        }

        public Role getOppositeRole() {
            return this.getRelationship().getSource() == this ? this.getRelationship().getTarget() : this.getRelationship().getSource();
        }

        public JavaContainerType getContainerType() {
            return this.containerType;
        }

        public void setContainerType(JavaContainerType containerType) {
            this.containerType = containerType;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public DasColumn getMapKey() {
            return this.mapKey;
        }

        public void setMapKey(DasColumn mapKey) {
            this.mapKey = mapKey;
        }
    }
}

