/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.CascadeType;
import com.intellij.javaee.model.common.persistence.mapping.CascadeTypeMode;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.javaee.model.xml.persistence.mapping.Attributes;
import com.intellij.javaee.model.xml.persistence.mapping.Basic;
import com.intellij.javaee.model.xml.persistence.mapping.Column;
import com.intellij.javaee.model.xml.persistence.mapping.ColumnBase;
import com.intellij.javaee.model.xml.persistence.mapping.EmbeddableAttributes;
import com.intellij.javaee.model.xml.persistence.mapping.Embedded;
import com.intellij.javaee.model.xml.persistence.mapping.Entity;
import com.intellij.javaee.model.xml.persistence.mapping.EntityBase;
import com.intellij.javaee.model.xml.persistence.mapping.FetchType;
import com.intellij.javaee.model.xml.persistence.mapping.Id;
import com.intellij.javaee.model.xml.persistence.mapping.ManyToMany;
import com.intellij.javaee.model.xml.persistence.mapping.NamedQuery;
import com.intellij.javaee.model.xml.persistence.mapping.PersistentObjectBase;
import com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase;
import com.intellij.javaee.model.xml.persistence.mapping.Table;
import com.intellij.jpa.model.manipulators.JpaObjectManipulatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.model.manipulators.PersistentRelationshipAttributeManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JdbcTypesUtil;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JpaDomObjectManipulator
extends JpaObjectManipulatorBase<PersistentObjectBase> {
    public JpaDomObjectManipulator(PersistentObjectBase target) {
        super(target);
    }

    @Override
    protected JpaObjectManipulatorBase.MyJpaAttributeAction createNewAttributeAction(AttributeType type) {
        return new MyDomAttributeAction(this, type);
    }

    public void setTable(DasTable tableInfo) {
        PersistentObjectBase object = (PersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof Entity);
        Table table = ((Entity)object).getTable();
        table.getTableName().setStringValue(tableInfo.getName());
        table.getSchema().setStringValue(DasUtil.getSchema((DasObject)tableInfo));
        table.getCatalog().setStringValue(DasUtil.getCatalog((DasObject)tableInfo));
    }

    public Embedded addEmbeddedAttribute(PersistentEmbeddable embeddable, String attributeName, PropertyMemberType accessMode) throws IncorrectOperationException {
        PsiClass embeddableClass;
        PersistentObjectBase object = (PersistentObjectBase)this.getManipulatorTarget();
        Embedded embedded = object.getAttributes().addEmbedded();
        embedded.getName().setValue((Object)attributeName);
        if (this.ensureClassExists() == null) {
            return embedded;
        }
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)embeddable, PersistentObjectManipulator.class);
        if (manipulator == null || (embeddableClass = manipulator.ensureClassExists()) == null) {
            return embedded;
        }
        this.ensurePropertyExists((PsiClass)((PersistentObjectBase)this.getManipulatorTarget()).getClazz().getValue(), attributeName, (PsiType)JavaPsiFacade.getInstance((Project)embeddableClass.getProject()).getElementFactory().createType(embeddableClass), accessMode, PsiAnnotation.EMPTY_ARRAY);
        return embedded;
    }

    public PersistentRelationshipAttribute addRelationshipAttribute(PersistentEntityBase entity, RelationshipType relationshipType, JavaContainerType containerType, String attributeName, String targetAttributeName, boolean inverse, boolean optional, String fetchType, Collection<String> cascadeVariants, PropertyMemberType accessMode) throws IncorrectOperationException {
        PsiClass psiClass;
        PsiClass curClass;
        boolean sameAttr;
        ManyToMany attrBase;
        PersistentObjectBase thisEntity = (PersistentObjectBase)this.getManipulatorTarget();
        switch (relationshipType) {
            case MANY_TO_MANY: {
                attrBase = thisEntity.getAttributes().addManyToMany();
                break;
            }
            case MANY_TO_ONE: {
                attrBase = thisEntity.getAttributes().addManyToOne();
                break;
            }
            case ONE_TO_MANY: {
                attrBase = thisEntity.getAttributes().addOneToMany();
                break;
            }
            case ONE_TO_ONE: {
                attrBase = thisEntity.getAttributes().addOneToOne();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        attrBase.getName().setValue((Object)attributeName);
        for (CascadeTypeMode cascadeTypeMode : CascadeTypeMode.values()) {
            if (!cascadeVariants.contains(cascadeTypeMode.getDisplayName())) continue;
            ((GenericDomValue)cascadeTypeMode.getCascadeTypeModeValue((CascadeType)attrBase.getCascade())).setValue((Object)Boolean.TRUE);
        }
        if (fetchType != null) {
            for (CascadeTypeMode cascadeTypeMode : FetchType.values()) {
                if (!cascadeTypeMode.getDisplayName().equals(fetchType)) continue;
                attrBase.getFetch().setValue((Object)cascadeTypeMode);
                break;
            }
        }
        boolean bl = sameAttr = thisEntity == entity && attributeName.equals(targetAttributeName);
        if (optional && attrBase instanceof RelationAttributeBase.AnyToOneBase) {
            ((RelationAttributeBase.AnyToOneBase)attrBase).getOptional().setValue((Object)optional);
        }
        if ((sameAttr || inverse) && StringUtil.isNotEmpty((String)targetAttributeName) && attrBase instanceof RelationAttributeBase.NonManyToOneBase) {
            ((RelationAttributeBase.NonManyToOneBase)attrBase).getMappedBy().setStringValue(targetAttributeName);
        }
        if ((curClass = this.ensureClassExists()) == null) {
            return attrBase;
        }
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)entity, PersistentObjectManipulator.class);
        if (manipulator == null || (psiClass = manipulator.ensureClassExists()) == null) {
            return attrBase;
        }
        attrBase.getTargetEntityClass().setValue((Object)psiClass);
        PsiClassType entityClassType = JavaPsiFacade.getInstance((Project)curClass.getProject()).getElementFactory().createType(psiClass);
        PsiClassType propertyType = relationshipType.isMany(false) ? containerType.createCollectionType((PsiElement)curClass, (PsiType)entityClassType, null) : entityClassType;
        this.ensurePropertyExists((PsiClass)((PersistentObjectBase)this.getManipulatorTarget()).getClazz().getValue(), attributeName, (PsiType)propertyType, accessMode, PsiAnnotation.EMPTY_ARRAY);
        return attrBase;
    }

    public PersistentAttribute addAttribute(String attributeName, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns) throws IncorrectOperationException {
        PersistentObjectBase object = (PersistentObjectBase)this.getManipulatorTarget();
        Basic basic = object.getAttributes().addBasic();
        basic.getName().setValue((Object)attributeName);
        String typeText = attributeType.getCanonicalText();
        if ("java.sql.Blob".equals(typeText) || "java.sql.Clob".equals(typeText)) {
            basic.getLob().ensureTagExists();
        }
        if (!columns.isEmpty()) {
            this.setColumnInfo(basic.getColumn(), columns.iterator().next());
        }
        if (this.ensureClassExists() == null) {
            return basic;
        }
        this.ensurePropertyExists((PsiClass)((PersistentObjectBase)this.getManipulatorTarget()).getClazz().getValue(), attributeName, attributeType, accessType, PsiAnnotation.EMPTY_ARRAY);
        return basic;
    }

    private void setColumnInfo(Column column, DasColumn columnInfo) {
        String defaultTableName = this.getManipulatorTarget() instanceof Entity ? (String)((Entity)this.getManipulatorTarget()).getTable().getTableName().getValue() : null;
        JpaDomObjectManipulator.setColumnInfo((ColumnBase)column, columnInfo, defaultTableName, this.isGenerateColumnProperties());
        if (this.isGenerateColumnProperties()) {
            int jdbcType = JdbcTypesUtil.getJdbcType((DasTypedObject)columnInfo, null);
            if (JdbcUtil.hasLength((int)jdbcType)) {
                int length = columnInfo.getDataType().getLength();
                if (length > 0 && length != 255) {
                    column.getLength().setValue((Object)length);
                }
            } else {
                int precision = columnInfo.getDataType().getPrecision();
                int scale = columnInfo.getDataType().getScale();
                if (precision != 0) {
                    column.getPrecision().setValue((Object)precision);
                }
                if (scale != 0) {
                    column.getPrecision().setValue((Object)scale);
                }
            }
        }
    }

    static void setColumnInfo(ColumnBase column, DasColumn columnInfo, String defaultTableName, boolean extendedColumnInfo) {
        column.getName().setValue((Object)columnInfo.getName());
        if (!Comparing.equal((String)defaultTableName, (String)columnInfo.getTable().getName())) {
            column.getTable().setValue((Object)columnInfo.getTable().getName());
        }
        if (extendedColumnInfo && !columnInfo.isNotNull()) {
            column.getNullable().setValue((Object)false);
        }
    }

    public PersistentAttribute addIdAttribute(boolean compositeId, String attributeName, PsiType attributeType, PropertyMemberType accessType, Collection<? extends DasColumn> columns) throws IncorrectOperationException {
        PersistentObjectBase object = (PersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof EntityBase);
        Id id = ((EntityBase)object).getAttributes().addId();
        id.getName().setValue((Object)attributeName);
        if (!columns.isEmpty()) {
            this.setColumnInfo(id.getColumn(), columns.iterator().next());
        }
        if (this.ensureClassExists() == null) {
            return id;
        }
        this.ensurePropertyExists((PsiClass)((PersistentObjectBase)this.getManipulatorTarget()).getClazz().getValue(), attributeName, attributeType, accessType, PsiAnnotation.EMPTY_ARRAY);
        return id;
    }

    public void setIdClass(String qualifiedName) {
        PersistentObjectBase object = (PersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof EntityBase);
        ((EntityBase)object).getIdClass().getClazz().setStringValue(qualifiedName);
    }

    public void addNamedQuery(String queryName, String queryText) {
        PersistentObjectBase object = (PersistentObjectBase)this.getManipulatorTarget();
        assert (object instanceof Entity);
        NamedQuery query = ((Entity)object).addNamedQuery();
        query.getName().setValue((Object)queryName);
        query.getQuery().setValue((Object)queryText);
    }

    public static class MyDomAttributeAction
    extends JpaObjectManipulatorBase.MyJpaAttributeAction<JpaDomObjectManipulator> {
        public MyDomAttributeAction(JpaDomObjectManipulator manipulator, AttributeType attributeType) {
            super(manipulator, attributeType);
        }

        @Override
        public void invokeAction(@NotNull Collection<PsiElement> result) throws IncorrectOperationException {
            Basic attribute;
            if (result == null) {
                MyDomAttributeAction.$$$reportNull$$$0(0);
            }
            EmbeddableAttributes attributes = ((PersistentObjectBase)((JpaDomObjectManipulator)this.getManipulator()).getManipulatorTarget()).getAttributes();
            assert (attributes instanceof Attributes || this.myAttributeType == JpaAttributeType.BASIC || this.myAttributeType == JpaAttributeType.TRANSIENT);
            if (this.myAttributeType == JpaAttributeType.BASIC) {
                attribute = attributes.addBasic();
            } else if (this.myAttributeType == JpaAttributeType.EMBEDDED) {
                attribute = attributes.addEmbedded();
            } else if (this.myAttributeType == JpaAttributeType.EMBEDDED_ID) {
                attribute = ((Attributes)attributes).getEmbeddedId();
            } else if (this.myAttributeType == JpaAttributeType.ID) {
                Id id = ((Attributes)attributes).addId();
                id.getGeneratedValue().ensureTagExists();
                attribute = id;
            } else if (this.myAttributeType == JpaAttributeType.MANY_TO_MANY) {
                attribute = attributes.addManyToMany();
            } else if (this.myAttributeType == JpaAttributeType.MANY_TO_ONE) {
                attribute = attributes.addManyToOne();
            } else if (this.myAttributeType == JpaAttributeType.ONE_TO_MANY) {
                attribute = attributes.addOneToMany();
            } else if (this.myAttributeType == JpaAttributeType.ONE_TO_ONE) {
                attribute = attributes.addOneToOne();
            } else if (this.myAttributeType == JpaAttributeType.TRANSIENT) {
                attribute = attributes.addBasic();
            } else if (this.myAttributeType == JpaAttributeType.VERSION) {
                attribute = ((Attributes)attributes).addVersion();
            } else if (this.myAttributeType == JpaAttributeType.ELEMENT_COLLECTION) {
                attribute = attributes.addElementCollection();
            } else {
                assert (false);
                attribute = null;
            }
            attribute.getName().setValue((Object)this.myInfo.name);
            if (this.getRelationshipType() != null) {
                PsiClass psiClass;
                PsiType entityType = PersistenceCommonUtil.getTargetEntityType((PsiType)this.myInfo.type);
                PsiClass psiClass2 = psiClass = entityType instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null;
                if (psiClass != null) {
                    ((RelationAttributeBase)attribute).getTargetEntityClass().setValue((Object)psiClass);
                } else if (entityType != null) {
                    ((RelationAttributeBase)attribute).getTargetEntityClass().setStringValue(entityType.getCanonicalText());
                }
                PersistentRelationshipAttributeManipulator manipulator = (PersistentRelationshipAttributeManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)attribute, PersistentRelationshipAttributeManipulator.class);
                if (manipulator != null) {
                    manipulator.setMappedByAndInverse(this.myInfo.targetAttribute, this.myInfo.inverse);
                }
            }
            super.invokeAction(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/model/manipulators/JpaDomObjectManipulator$MyDomAttributeAction", "invokeAction"));
        }
    }
}

