/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.mapping.EntityMappings;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.manipulators.AbstractPersistenceAction;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaUnitManipulator
extends AbstractPersistenceManipulator<PersistenceUnit>
implements PersistenceUnitManipulator<PersistenceUnit> {
    public JpaUnitManipulator(PersistenceUnit target) {
        super((Object)target);
    }

    public List<PersistenceAction> getCreateActions() {
        return JpaUnitManipulator.getCreateActionsDefault(this, new ArrayList<PersistenceAction>());
    }

    public static List<PersistenceAction> getCreateActionsDefault(PersistenceUnitManipulator<?> unitManipulator, List<PersistenceAction> result) {
        PersistencePackage unit = (PersistencePackage)unitManipulator.getManipulatorTarget();
        List facets = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceFacets(unit);
        result.add((PersistenceAction)new MyMappingsAction(unitManipulator, JpaMessages.message((String)"action.name.create.persistence.mappings", (Object[])new Object[0]), JpaMessages.message((String)"model.object.type.persistence.mappings", (Object[])new Object[0]), JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA.getDefaultVersion().getTemplateName(), EntityMappings.class));
        for (PersistenceFacet facet : facets) {
            PersistenceMappings mappings = facet.getEntityMappings(unit);
            PersistenceManipulator manipulator = PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)mappings, PersistenceManipulator.class);
            if (manipulator == null) continue;
            result.addAll(manipulator.getCreateActions());
        }
        return result;
    }

    public void ensureMappingIncluded(PersistenceMappings mappings) {
        JpaUtil.ensureMappingsIncluded((PersistenceUnit)this.getManipulatorTarget(), mappings);
    }

    public void ensureClassIncluded(PsiClass psiClass) {
        JpaUtil.ensureClassIncluded((PersistenceUnit)this.getManipulatorTarget(), null, psiClass);
    }

    public void setConnectionProperties(@NotNull Project project, @NotNull RawConnectionConfig info, @Nullable Credentials credentials) {
        if (project == null) {
            JpaUnitManipulator.$$$reportNull$$$0(0);
        }
        if (info == null) {
            JpaUnitManipulator.$$$reportNull$$$0(1);
        }
        PersistenceUnit unit = (PersistenceUnit)this.getManipulatorTarget();
        this.setConnectionProperties(JpaUtil.findJpaProvider(null, (PersistencePackage)unit, true), project, info, credentials);
    }

    public void setConnectionProperties(JpaImplementationProvider configuredProvider, @NotNull Project project, @NotNull RawConnectionConfig info, @Nullable Credentials credentials) {
        if (project == null) {
            JpaUnitManipulator.$$$reportNull$$$0(2);
        }
        if (info == null) {
            JpaUnitManipulator.$$$reportNull$$$0(3);
        }
        PersistenceUnit unit = (PersistenceUnit)this.getManipulatorTarget();
        if (configuredProvider != null) {
            configuredProvider.setConnectionProperties(project, unit, info, credentials);
        } else {
            for (JpaImplementationProvider provider : JpaImplementationProvider.EP_NAME.getExtensionList()) {
                provider.setConnectionProperties(project, unit, info, credentials);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/model/manipulators/JpaUnitManipulator";
        objectArray[2] = "setConnectionProperties";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyMappingsAction
    extends AbstractPersistenceAction<PersistenceUnitManipulator> {
        private PersistenceFacet myFacet;
        private PersistencePackage myUnit;
        private Collection<PsiFile> myTargetFiles;
        private final String myTemplate;
        private final Class<? extends PersistenceMappings> myMappingsClass;

        public MyMappingsAction(PersistenceUnitManipulator manipulator, String name, String title, String template, Class<? extends PersistenceMappings> mappingsClass) {
            super((PersistenceManipulator)manipulator, name, title, StdFileTypes.XML.getIcon());
            this.myTemplate = template;
            this.myMappingsClass = mappingsClass;
        }

        public int getGroupId() {
            return 20;
        }

        public void update(AnActionEvent e) {
            this.myFacet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
            this.myUnit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(e.getDataContext());
            this.getPresentation().setEnabled(this.myFacet != null && this.myUnit != null && !JamCommonUtil.isInLibrary((CommonModelElement)this.myUnit));
        }

        public boolean preInvoke(UserResponse response) {
            Object[] files = response.getPersistenceMappingFiles(this.myFacet, this.myTemplate, this.myMappingsClass);
            this.myTargetFiles = ContainerUtil.mapNotNull((Object[])files, virtualFile -> PsiManager.getInstance((Project)this.myFacet.getModule().getProject()).findFile(virtualFile));
            return !this.myTargetFiles.isEmpty();
        }

        protected PsiElement getTargetElement() {
            List currentFiles = this.myUnit.getModelHelper().getMappingFiles(this.myMappingsClass);
            for (PsiFile file : this.myTargetFiles) {
                PersistenceMappings element = (PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)file, this.myMappingsClass, (Module)this.myFacet.getModule());
                if (element == null || GenericValueUtil.containsValue((Collection)currentFiles, (Object)element)) continue;
                return this.myUnit.getIdentifyingPsiElement();
            }
            return null;
        }

        public void addAffectedElements(@NotNull Collection<PsiElement> affectedElements) {
            if (affectedElements == null) {
                MyMappingsAction.$$$reportNull$$$0(0);
            }
            affectedElements.add((PsiElement)this.myUnit.getContainingFile());
        }

        public void invokeAction(@NotNull Collection<PsiElement> result) {
            PersistenceUnitManipulator manipulator;
            if (result == null) {
                MyMappingsAction.$$$reportNull$$$0(1);
            }
            if ((manipulator = (PersistenceUnitManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)this.myUnit, PersistenceUnitManipulator.class)) == null) {
                return;
            }
            for (PsiFile file : this.myTargetFiles) {
                PersistenceMappings element = (PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)file, this.myMappingsClass, (Module)this.myFacet.getModule());
                if (element == null) continue;
                result.add(element.getIdentifyingPsiElement());
                manipulator.ensureMappingIncluded(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affectedElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jpa/model/manipulators/JpaUnitManipulator$MyMappingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAffectedElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

