/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.Multiplicity;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.module.EjbQlAnnotationVisitor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.JavaeeIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbQlModel
extends QlModel {
    private final EjbRootElement myRoot;
    private final int myParamCount;

    public EjbQlModel(@NotNull EjbRootElement rootElement, int paramCount) {
        if (rootElement == null) {
            EjbQlModel.$$$reportNull$$$0(0);
        }
        this.myRoot = rootElement;
        this.myParamCount = paramCount;
    }

    @Override
    public int getParametersCount() {
        return this.myParamCount;
    }

    @Override
    public QlEntity[] getEntities() {
        ArrayList<EjbQlEntity> entities = new ArrayList<EjbQlEntity>();
        for (EntityBean entityBean : this.myRoot.getEnterpriseBeans().getEntities()) {
            if (entityBean.getPersistenceType().getValue() != PersistenceType.CONTAINER) continue;
            entities.add(new EjbQlEntity(entityBean));
        }
        return entities.toArray(new QlEntity[0]);
    }

    @Override
    public QlVisitor createAnnotationVisitor(AnnotationHolder holder) {
        EjbDescriptorVersion ejbVersion = EjbUtil.getVersion((JavaeeModelElement)this.myRoot);
        return new EjbQlAnnotationVisitor(holder, ejbVersion);
    }

    public final QlEntity getPersistenceEntity(EntityBean s) {
        return new EjbQlEntity(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/module/EjbQlModel", "<init>"));
    }

    public class EjbQlEntity
    extends QlEntity {
        private final EntityBean myEjb;

        public EjbQlEntity(EntityBean ejb) {
            this.myEjb = ejb;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return JavaeeIcons.ENTITY_BEAN;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            XmlTag tag1;
            XmlTag tag = JamCommonUtil.getXmlTag((CommonModelElement)this.myEjb);
            if (tag != null && (tag1 = tag.findFirstSubTag("abstract-schema-name")) != null) {
                return tag1;
            }
            return tag;
        }

        @Override
        public String getPersistenceElementName() {
            String schemaName = this.myEjb.getAbstractSchemaName().getStringValue();
            return schemaName != null ? schemaName : StringUtil.notNullize((String)((String)this.myEjb.getEjbName().getValue()));
        }

        @Override
        public List<QlAttribute> getAttributes() {
            ArrayList<QlAttribute> result = new ArrayList<QlAttribute>();
            for (final CmpField s : this.myEjb.getCmpFields()) {
                result.add(new QlAttribute(){

                    @Override
                    @Nullable
                    public Icon getIcon() {
                        return JavaeeIcons.ATTRIBUTE_ICON;
                    }

                    @Override
                    @Nullable
                    public PsiElement getPsiElement() {
                        return s.getIdentifyingPsiElement();
                    }

                    @Override
                    public QlAttribute.ComponentTarget getComponentTarget(QlAttribute.ComponentType component) {
                        if (component != QlAttribute.ComponentType.SINGLE) {
                            return null;
                        }
                        return QlAttribute.ComponentTarget.VALUE;
                    }

                    @Override
                    public QlElement getComponentValue(QlAttribute.ComponentType component) {
                        if (component != QlAttribute.ComponentType.SINGLE) {
                            return null;
                        }
                        return this;
                    }

                    @Override
                    public PsiType getPsiType() {
                        return EjbUtil.findType(s);
                    }

                    @Override
                    @NotNull
                    public String getPersistenceElementName() {
                        String string = StringUtil.notNullize((String)((String)s.getFieldName().getValue()));
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/EjbQlModel$EjbQlEntity$1", "getPersistenceElementName"));
                    }
                });
            }
            for (final CmpField s : this.myEjb.getCmrFields()) {
                CmrField oppositeField = s.getOppositeField();
                boolean isToMany = oppositeField != null && oppositeField.getMultiplicity().getValue() == Multiplicity.MANY;
                result.add(new QlAttribute((CmrField)s, isToMany){
                    final /* synthetic */ CmrField val$s;
                    final /* synthetic */ boolean val$isToMany;
                    {
                        this.val$s = cmrField;
                        this.val$isToMany = bl;
                    }

                    @Override
                    @Nullable
                    public Icon getIcon() {
                        return JavaeeIcons.RELATIONSHIP_ICON;
                    }

                    @Override
                    public String getPersistenceElementName() {
                        return StringUtil.notNullize((String)((String)this.val$s.getCmrFieldName().getValue()));
                    }

                    @Override
                    public QlAttribute.ComponentTarget getComponentTarget(QlAttribute.ComponentType component) {
                        if (this.val$isToMany && component == QlAttribute.ComponentType.VALUE) {
                            return QlAttribute.ComponentTarget.ENTITY;
                        }
                        if (!this.val$isToMany && component == QlAttribute.ComponentType.SINGLE) {
                            return QlAttribute.ComponentTarget.ENTITY;
                        }
                        return null;
                    }

                    @Override
                    public QlElement getComponentValue(QlAttribute.ComponentType component) {
                        if (this.val$isToMany && component == QlAttribute.ComponentType.VALUE || !this.val$isToMany && component == QlAttribute.ComponentType.SINGLE) {
                            EntityBean entityBean = this.val$s.getOppositeEntity();
                            return entityBean == null ? null : EjbQlModel.this.getPersistenceEntity(entityBean);
                        }
                        return null;
                    }

                    @Override
                    public boolean isToMany() {
                        return this.val$isToMany;
                    }

                    @Override
                    @Nullable
                    public PsiElement getPsiElement() {
                        return this.val$s.getIdentifyingPsiElement();
                    }
                });
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EjbQlEntity that = (EjbQlEntity)o;
            return !(this.myEjb != null ? !this.myEjb.equals(that.myEjb) : that.myEjb != null);
        }

        public int hashCode() {
            return this.myEjb != null ? this.myEjb.hashCode() : 0;
        }
    }
}

