/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesReferenceManager {
    private final PsiManager myPsiManager;
    private final DumbService myDumbService;

    public static PropertiesReferenceManager getInstance(@NotNull Project project) {
        if (project == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(0);
        }
        return (PropertiesReferenceManager)ServiceManager.getService((Project)project, PropertiesReferenceManager.class);
    }

    public PropertiesReferenceManager(PsiManager psiManager, DumbService dumbService) {
        this.myPsiManager = psiManager;
        this.myDumbService = dumbService;
    }

    @NotNull
    public List<PropertiesFile> findPropertiesFiles(@NotNull Module module, @NotNull String bundleName) {
        if (module == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(1);
        }
        if (bundleName == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(2);
        }
        ConcurrentMap map = (ConcurrentMap)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                PropertiesReferenceManager.$$$reportNull$$$0(18);
            }
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(bundleName1 -> {
                if (module == null) {
                    PropertiesReferenceManager.$$$reportNull$$$0(19);
                }
                return this.findPropertiesFiles(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), (String)bundleName1, BundleNameEvaluator.DEFAULT);
            });
            return CachedValueProvider.Result.create((Object)factoryMap, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        List list = (List)map.get(bundleName);
        if (list == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<PropertiesFile> findPropertiesFiles(@NotNull GlobalSearchScope searchScope, @NotNull String bundleName, @NotNull BundleNameEvaluator bundleNameEvaluator) {
        if (searchScope == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(4);
        }
        if (bundleName == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(5);
        }
        if (bundleNameEvaluator == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(6);
        }
        ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>();
        this.processPropertiesFiles(searchScope, (baseName, propertiesFile) -> {
            if (bundleName == null) {
                PropertiesReferenceManager.$$$reportNull$$$0(17);
            }
            if (baseName.equals(bundleName)) {
                result.add(propertiesFile);
            }
            return true;
        }, bundleNameEvaluator);
        ArrayList<PropertiesFile> arrayList = result;
        if (arrayList == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public PropertiesFile findPropertiesFile(@NotNull Module module, @NotNull String bundleName, @Nullable Locale locale) {
        if (module == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(8);
        }
        if (bundleName == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(9);
        }
        List<PropertiesFile> propFiles = this.findPropertiesFiles(module, bundleName);
        if (locale != null) {
            for (PropertiesFile propFile : propFiles) {
                if (!propFile.getLocale().equals(locale)) continue;
                return propFile;
            }
        }
        for (PropertiesFile propFile : propFiles) {
            if (propFile.getLocale().getLanguage().length() != 0 && !propFile.getLocale().equals(Locale.getDefault())) continue;
            return propFile;
        }
        if (!propFiles.isEmpty()) {
            return propFiles.get(0);
        }
        return null;
    }

    public boolean processAllPropertiesFiles(@NotNull PropertiesFileProcessor processor) {
        if (processor == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(10);
        }
        return this.processPropertiesFiles(GlobalSearchScope.allScope((Project)this.myPsiManager.getProject()), processor, BundleNameEvaluator.DEFAULT);
    }

    public boolean processPropertiesFiles(@NotNull GlobalSearchScope searchScope, @NotNull PropertiesFileProcessor processor, @NotNull BundleNameEvaluator evaluator) {
        if (searchScope == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(12);
        }
        if (evaluator == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(13);
        }
        for (VirtualFile file : FileTypeIndex.getFiles((FileType)PropertiesFileType.INSTANCE, (GlobalSearchScope)searchScope)) {
            if (this.processFile(file, evaluator, processor)) continue;
            return false;
        }
        if (!this.myDumbService.isDumb()) {
            for (VirtualFile file : FileBasedIndex.getInstance().getContainingFiles(XmlPropertiesIndex.NAME, (Object)XmlPropertiesIndex.MARKER_KEY, searchScope)) {
                if (this.processFile(file, evaluator, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processFile(@NotNull VirtualFile file, @NotNull BundleNameEvaluator evaluator, @NotNull PropertiesFileProcessor processor) {
        String qName;
        PsiFile psiFile;
        PropertiesFile propertiesFile;
        if (file == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(14);
        }
        if (evaluator == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PropertiesReferenceManager.$$$reportNull$$$0(16);
        }
        return (propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile = this.myPsiManager.findFile(file))) == null || (qName = evaluator.evaluateBundleName(psiFile)) == null || processor.process(qName, propertiesFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/PropertiesReferenceManager";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleNameEvaluator";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/PropertiesReferenceManager";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertiesFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPropertiesFiles";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPropertiesFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllPropertiesFiles";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processPropertiesFiles";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findPropertiesFiles$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findPropertiesFiles$1";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

