/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FunctionsFromAnyGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionsFromAnyGeneratorImpl
extends FunctionsFromAnyGenerator {
    private final ClassDescriptor classDescriptor;
    private final Type classAsmType;
    private final FieldOwnerContext<?> fieldOwnerContext;
    private final ClassBuilder v;
    private final GenerationState generationState;
    private final KotlinTypeMapper typeMapper;
    private final JvmKotlinType underlyingType;

    public FunctionsFromAnyGeneratorImpl(@NotNull KtClassOrObject declaration2, @NotNull BindingContext bindingContext2, @NotNull ClassDescriptor descriptor2, @NotNull Type type2, @NotNull FieldOwnerContext<?> fieldOwnerContext, @NotNull ClassBuilder v, @NotNull GenerationState state) {
        super(declaration2, bindingContext2);
        this.classDescriptor = descriptor2;
        this.classAsmType = type2;
        this.fieldOwnerContext = fieldOwnerContext;
        this.v = v;
        this.generationState = state;
        this.typeMapper = state.getTypeMapper();
        this.underlyingType = new JvmKotlinType(this.typeMapper.mapType(descriptor2), InlineClassesUtilsKt.substitutedUnderlyingType(descriptor2.getDefaultType()));
    }

    @Override
    protected void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
        MethodContext context = this.fieldOwnerContext.intoFunction(function2);
        JvmDeclarationOrigin methodOrigin = JvmDeclarationOriginKt.OtherOrigin(function2);
        String toStringMethodName = this.mapFunctionName(function2);
        MethodVisitor mv = this.v.newMethod(methodOrigin, this.getAccess(), toStringMethodName, this.getToStringDesc(), null, null);
        if (this.fieldOwnerContext.getContextKind() != OwnerKind.ERASED_INLINE_CLASS && this.classDescriptor.isInline()) {
            FunctionCodegen.generateMethodInsideInlineClassWrapper(methodOrigin, function2, this.classDescriptor, mv, this.typeMapper);
            return;
        }
        mv.visitAnnotation(Type.getDescriptor(NotNull.class), false);
        if (!this.generationState.getClassBuilderMode().generateBodies) {
            FunctionCodegen.endVisit(mv, toStringMethodName, this.getDeclaration());
            return;
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        AsmUtil.genStringBuilderConstructor(iv);
        boolean first = true;
        for (PropertyDescriptor propertyDescriptor : properties2) {
            if (first) {
                iv.aconst((Object)(this.classDescriptor.getName() + "(" + propertyDescriptor.getName().asString() + "="));
                first = false;
            } else {
                iv.aconst((Object)(", " + propertyDescriptor.getName().asString() + "="));
            }
            AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE, null);
            JvmKotlinType type2 = this.genOrLoadOnStack(iv, context, propertyDescriptor, 0);
            Type asmType = type2.getType();
            if (asmType.getSort() == 9) {
                Type elementType = AsmUtil.correctElementType(asmType);
                if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                    iv.invokestatic("java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;", false);
                    asmType = AsmTypes.JAVA_STRING_TYPE;
                } else if (elementType.getSort() != 2) {
                    iv.invokestatic("java/util/Arrays", "toString", "(" + asmType.getDescriptor() + ")Ljava/lang/String;", false);
                    asmType = AsmTypes.JAVA_STRING_TYPE;
                }
            }
            AsmUtil.genInvokeAppendMethod(iv, asmType, type2.getKotlinType());
        }
        iv.aconst((Object)")");
        AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE, null);
        iv.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        iv.areturn(AsmTypes.JAVA_STRING_TYPE);
        FunctionCodegen.endVisit(mv, toStringMethodName, this.getDeclaration());
    }

    @Override
    protected void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
        MethodContext context = this.fieldOwnerContext.intoFunction(function2);
        JvmDeclarationOrigin methodOrigin = JvmDeclarationOriginKt.OtherOrigin(function2);
        String hashCodeMethodName = this.mapFunctionName(function2);
        MethodVisitor mv = this.v.newMethod(methodOrigin, this.getAccess(), hashCodeMethodName, this.getHashCodeDesc(), null, null);
        if (this.fieldOwnerContext.getContextKind() != OwnerKind.ERASED_INLINE_CLASS && this.classDescriptor.isInline()) {
            FunctionCodegen.generateMethodInsideInlineClassWrapper(methodOrigin, function2, this.classDescriptor, mv, this.typeMapper);
            return;
        }
        if (!this.generationState.getClassBuilderMode().generateBodies) {
            FunctionCodegen.endVisit(mv, hashCodeMethodName, this.getDeclaration());
            return;
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        boolean first = true;
        for (PropertyDescriptor propertyDescriptor : properties2) {
            if (!first) {
                iv.iconst(31);
                iv.mul(Type.INT_TYPE);
            }
            JvmKotlinType propertyType = this.genOrLoadOnStack(iv, context, propertyDescriptor, 0);
            KotlinType kotlinType = propertyDescriptor.getReturnType();
            Type asmType = this.typeMapper.mapType(kotlinType);
            StackValue.coerce(propertyType.getType(), propertyType.getKotlinType(), asmType, kotlinType, iv);
            Label ifNull = null;
            if (!AsmUtil.isPrimitive(asmType)) {
                ifNull = new Label();
                iv.dup();
                iv.ifnull(ifNull);
            }
            AsmUtil.genHashCode(mv, iv, asmType, this.generationState.getTarget());
            if (ifNull != null) {
                Label end = new Label();
                iv.goTo(end);
                iv.mark(ifNull);
                iv.pop();
                iv.iconst(0);
                iv.mark(end);
            }
            if (first) {
                first = false;
                continue;
            }
            iv.add(Type.INT_TYPE);
        }
        mv.visitInsn(172);
        FunctionCodegen.endVisit(mv, hashCodeMethodName, this.getDeclaration());
    }

    private String mapFunctionName(@NotNull FunctionDescriptor functionDescriptor2) {
        return this.typeMapper.mapFunctionName(functionDescriptor2, this.fieldOwnerContext.getContextKind());
    }

    @Override
    protected void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
        boolean isErasedInlineClassKind;
        MethodContext context = this.fieldOwnerContext.intoFunction(function2);
        JvmDeclarationOrigin methodOrigin = JvmDeclarationOriginKt.OtherOrigin(function2);
        String equalsMethodName = this.mapFunctionName(function2);
        MethodVisitor mv = this.v.newMethod(methodOrigin, this.getAccess(), equalsMethodName, this.getEqualsDesc(), null, null);
        boolean bl = isErasedInlineClassKind = this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS;
        if (!isErasedInlineClassKind && this.classDescriptor.isInline()) {
            FunctionCodegen.generateMethodInsideInlineClassWrapper(methodOrigin, function2, this.classDescriptor, mv, this.typeMapper);
            return;
        }
        mv.visitParameterAnnotation(isErasedInlineClassKind ? 1 : 0, Type.getDescriptor(Nullable.class), false);
        if (!this.generationState.getClassBuilderMode().generateBodies) {
            FunctionCodegen.endVisit(mv, equalsMethodName, this.getDeclaration());
            return;
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        mv.visitCode();
        Label eq = new Label();
        Label ne = new Label();
        int storedValueIndex = this.generateBasicChecksAndStoreTarget(iv, eq, ne);
        for (PropertyDescriptor propertyDescriptor : properties2) {
            KotlinType kotlinType = propertyDescriptor.getReturnType();
            Type asmType = this.typeMapper.mapType(kotlinType);
            JvmKotlinType thisPropertyType = this.genOrLoadOnStack(iv, context, propertyDescriptor, 0);
            StackValue.coerce(thisPropertyType.getType(), thisPropertyType.getKotlinType(), asmType, kotlinType, iv);
            JvmKotlinType otherPropertyType = this.genOrLoadOnStack(iv, context, propertyDescriptor, storedValueIndex);
            StackValue.coerce(otherPropertyType.getType(), otherPropertyType.getKotlinType(), asmType, kotlinType, iv);
            if (asmType.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "compare", "(FF)I", false);
                iv.ifne(ne);
                continue;
            }
            if (asmType.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "compare", "(DD)I", false);
                iv.ifne(ne);
                continue;
            }
            StackValue value = AsmUtil.genEqualsForExpressionsOnStack(KtTokens.EQEQ, StackValue.onStack(asmType, kotlinType), StackValue.onStack(asmType, kotlinType));
            value.put(Type.BOOLEAN_TYPE, iv);
            iv.ifeq(ne);
        }
        iv.mark(eq);
        iv.iconst(1);
        iv.areturn(Type.INT_TYPE);
        iv.mark(ne);
        iv.iconst(0);
        iv.areturn(Type.INT_TYPE);
        FunctionCodegen.endVisit(mv, equalsMethodName, this.getDeclaration());
    }

    private int generateBasicChecksAndStoreTarget(InstructionAdapter iv, Label eq, Label ne) {
        if (this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS) {
            SimpleType wrapperKotlinType = this.classDescriptor.getDefaultType();
            Type wrapperType = this.typeMapper.mapTypeAsDeclaration(wrapperKotlinType);
            int secondParameterIndex = this.underlyingType.getType().getSize();
            iv.load(secondParameterIndex, AsmTypes.OBJECT_TYPE);
            iv.instanceOf(wrapperType);
            iv.ifeq(ne);
            int unboxedValueIndex = secondParameterIndex + 1;
            iv.load(secondParameterIndex, AsmTypes.OBJECT_TYPE);
            iv.checkcast(wrapperType);
            StackValue.unboxInlineClass(wrapperType, wrapperKotlinType, iv);
            iv.store(unboxedValueIndex, this.underlyingType.getType());
            return unboxedValueIndex;
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.ifacmpeq(eq);
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.instanceOf(this.classAsmType);
        iv.ifeq(ne);
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.checkcast(this.classAsmType);
        iv.store(2, AsmTypes.OBJECT_TYPE);
        return 2;
    }

    private JvmKotlinType genOrLoadOnStack(InstructionAdapter iv, MethodContext context, PropertyDescriptor propertyDescriptor, int index2) {
        if (this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS) {
            iv.load(index2, this.underlyingType.getType());
            return this.underlyingType;
        }
        return ImplementationBodyCodegen.genPropertyOnStack(iv, context, propertyDescriptor, this.classAsmType, index2, this.generationState);
    }

    private String getToStringDesc() {
        return "(" + this.getFirstParameterDesc() + ")Ljava/lang/String;";
    }

    private String getHashCodeDesc() {
        return "(" + this.getFirstParameterDesc() + ")I";
    }

    private String getEqualsDesc() {
        return "(" + this.getFirstParameterDesc() + "Ljava/lang/Object;)Z";
    }

    private String getFirstParameterDesc() {
        return this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS ? this.underlyingType.getType().getDescriptor() : "";
    }

    private int getAccess() {
        int access = 1;
        if (this.fieldOwnerContext.getContextKind() == OwnerKind.ERASED_INLINE_CLASS) {
            access |= 8;
        }
        return access;
    }
}

