/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class PsiDiagnosticUtils {
    public static String atLocation(@NotNull PsiElement element3) {
        if (element3.isValid()) {
            return PsiDiagnosticUtils.atLocation(element3.getContainingFile(), element3.getTextRange());
        }
        PsiFile file = null;
        int offset2 = -1;
        try {
            file = element3.getContainingFile();
            offset2 = element3.getTextOffset();
        }
        catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
            // empty catch block
        }
        return "at offset: " + (offset2 != -1 ? Integer.valueOf(offset2) : "<unknown>") + " file: " + (file != null ? file : "<unknown>");
    }

    public static String atLocation(KtExpression expression2) {
        return PsiDiagnosticUtils.atLocation(expression2.getNode());
    }

    public static String atLocation(@NotNull ASTNode node) {
        int startOffset = node.getStartOffset();
        PsiElement element3 = PsiUtilsKt.closestPsiElement(node);
        if (element3 != null) {
            return PsiDiagnosticUtils.atLocation(element3);
        }
        return "at offset " + startOffset + " (line and file unknown: no PSI element)";
    }

    @NotNull
    public static String atLocation(@NotNull PsiFile file, @NotNull TextRange textRange) {
        Document document = file.getViewProvider().getDocument();
        return PsiDiagnosticUtils.atLocation(file, textRange, document);
    }

    @NotNull
    public static String atLocation(PsiFile file, TextRange textRange, Document document) {
        int offset2 = textRange.getStartOffset();
        VirtualFile virtualFile = file.getVirtualFile();
        String pathSuffix = " in " + (virtualFile == null ? file.getName() : virtualFile.getPath());
        return PsiDiagnosticUtils.offsetToLineAndColumn(document, offset2).toString() + pathSuffix;
    }

    @NotNull
    public static LineAndColumn offsetToLineAndColumn(@Nullable Document document, int offset2) {
        if (document == null) {
            return new LineAndColumn(-1, offset2, null);
        }
        int lineNumber = document.getLineNumber(offset2);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int column = offset2 - lineStartOffset;
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        return new LineAndColumn(lineNumber + 1, column + 1, lineContent.toString());
    }

    public static final class LineAndColumn {
        public static final LineAndColumn NONE = new LineAndColumn(-1, -1, null);
        private final int line;
        private final int column;
        private final String lineContent;

        public LineAndColumn(int line, int column, @Nullable String lineContent) {
            this.line = line;
            this.column = column;
            this.lineContent = lineContent;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        @Nullable
        public String getLineContent() {
            return this.lineContent;
        }

        public String toString() {
            if (this.line < 0) {
                return "(offset: " + this.column + " line unknown)";
            }
            return "(" + this.line + "," + this.column + ")";
        }
    }
}

